/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.storage.console.gui.STableCellInfo;
import com.ibm.storage.console.gui.STableColumn;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class STableCellComparator
implements Comparator,
Serializable {
    private Locale m_locale = null;
    private STableColumn m_column = null;

    public STableCellComparator(STableColumn column, Locale locale) {
        this.m_column = column;
        this.m_locale = locale;
    }

    public int compare(Object cell1, Object cell2) {
        int result = 0;
        STableCellInfo info1 = (STableCellInfo)cell1;
        STableCellInfo info2 = (STableCellInfo)cell2;
        String val1 = info1.getValue();
        String val2 = info2.getValue();
        switch (this.m_column.getType()) {
            case 1: {
                try {
                    Number num1 = SsgPsUtilities.getNumber(val1, this.m_locale);
                    Number num2 = SsgPsUtilities.getNumber(val2, this.m_locale);
                    if (num1 == null || num2 == null) {
                        if (num1 != null) {
                            result = 1;
                        }
                        if (num2 == null) break;
                        result = -1;
                        break;
                    }
                    Double dval1 = new Double(num1.doubleValue());
                    Double dval2 = new Double(num2.doubleValue());
                    result = dval1.compareTo(dval2);
                }
                catch (NumberFormatException ex) {
                    result = 0;
                }
                break;
            }
            case 2: {
                Date date1 = SsgPsUtilities.getTime(val1, this.m_locale);
                Date date2 = SsgPsUtilities.getTime(val2, this.m_locale);
                if (date1 == null || date2 == null) {
                    if (date1 != null) {
                        result = 1;
                    }
                    if (date2 == null) break;
                    result = -1;
                    break;
                }
                result = date1.compareTo(date2);
                break;
            }
            default: {
                result = val1.compareTo(val2);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        return obj.equals(this);
    }
}

