/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcl.components.table.DefaultTableBooleanFilter;
import com.ibm.psw.wcl.components.table.ITableFilter;
import com.ibm.storage.console.gui.STableCellNumericFilter;
import com.ibm.storage.console.gui.STableCellSelectFilter;
import com.ibm.storage.console.gui.STableCellStringFilter;
import java.util.Locale;
import java.util.Vector;

public class STableColumn {
    public static final int DATA_TYPE_STRING = 0;
    public static final int DATA_TYPE_NUMBER = 1;
    public static final int DATA_TYPE_DATETIME = 2;
    public static final int DATA_TYPE_SWITCH = 3;
    public static final int DATA_TYPE_SELECTION = 4;
    private String m_header = null;
    private Vector m_selections = null;
    private boolean m_linkEnabled = false;
    private int m_type = 0;

    public STableColumn(String header) {
        this(header, 0, false);
    }

    public STableColumn(String header, boolean linkEnabled) {
        this(header, 0, linkEnabled);
    }

    public STableColumn(String header, int datatype) {
        this(header, datatype, false);
    }

    public STableColumn(String header, int datatype, boolean linkEnabled) {
        this.m_header = header;
        this.m_type = datatype;
        this.m_linkEnabled = linkEnabled;
    }

    public ITableFilter getFilter(Locale locale) {
        Object colfilter = null;
        switch (this.m_type) {
            case 3: {
                colfilter = new DefaultTableBooleanFilter();
                break;
            }
            case 4: {
                colfilter = new STableCellSelectFilter();
                ((STableCellSelectFilter)colfilter).setSelectionList(this.getSelections());
                break;
            }
            case 1: {
                colfilter = new STableCellNumericFilter(locale);
                break;
            }
            default: {
                colfilter = new STableCellStringFilter();
            }
        }
        return colfilter;
    }

    public String getHeader() {
        return this.m_header;
    }

    public boolean isLinkEnabled() {
        return this.m_linkEnabled;
    }

    public void setSelections(Vector vector) {
        this.m_selections = vector;
    }

    public Vector getSelections() {
        return this.m_selections;
    }

    public int getType() {
        return this.m_type;
    }
}

