/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.cell.CellInfo;
import com.ibm.psw.wcl.core.cell.DefaultCell;
import com.ibm.psw.wcl.core.cell.DefaultHyperlinkCell;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.renderer.output.html.HTMLDocumentFragmentWrapper;
import com.ibm.psw.wcl.renderers.table.html.HTMLTableCellRenderer;
import com.ibm.storage.console.ImageUrlResource;
import com.ibm.storage.console.gui.SimpleTableCellInfo;
import com.ibm.storage.console.util.SsgLogUtilities;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLImageElement;

public class SimpleTableColumnRender
extends HTMLTableCellRenderer {
    public IOutput renderCell(RenderingContext rc, AWCell cell, CellInfo cellInfo) throws RendererException {
        SsgLogUtilities.logEntry((Object)this, "renderCell", cellInfo.getValue().toString());
        Object val = cellInfo.getValue();
        if (val != null) {
            SimpleTableCellInfo tablecell = (SimpleTableCellInfo)val;
            String displaystr = tablecell.getValue();
            if (displaystr == null || displaystr.length() == 0) {
                displaystr = "-";
            }
            if (cell instanceof DefaultHyperlinkCell) {
                WHyperlink link = ((DefaultHyperlinkCell)cell).getHyperlink();
                if (tablecell.getLink() != null) {
                    link.setURL(tablecell.getLink());
                } else {
                    link.setTriggerParameters(tablecell.getLinkParameters());
                }
                if (tablecell.getIconPath() == null) {
                    ((DefaultHyperlinkCell)cell).setText(tablecell.getValue());
                    ((DefaultHyperlinkCell)cell).setHorizontalAlignment(tablecell.getAlignment());
                    return cell.getOutput(rc);
                }
                HTMLDocumentFragmentWrapper doc = rc.getDocumentFactory().createHTMLDocumentFragmentWrapper();
                HTMLElement span = doc.createSPANElement();
                HTMLImageElement image = doc.createIMGElement();
                ImageUrlResource iconRes = new ImageUrlResource(tablecell.getIconPath());
                image.setSrc(iconRes.getFilePart());
                String alttext = tablecell.getIconAltText();
                if (alttext == null) {
                    alttext = displaystr;
                }
                image.setAlt(alttext);
                span.appendChild(image);
                span.appendChild(doc.createTextNode("  "));
                HTMLAnchorElement linkelem = doc.createAElement();
                linkelem.appendChild(doc.createTextNode(displaystr));
                linkelem.setHref(link.getURL(rc.getTriggerFactory()));
                linkelem.setTarget(link.getTarget());
                span.appendChild(linkelem);
                doc.appendToContentFragment((Node)span);
                return doc.createOutput(rc);
            }
            if (tablecell.getIconPath() == null) {
                ((DefaultCell)cell).setText(displaystr);
                ((DefaultCell)cell).setHorizontalAlignment(tablecell.getAlignment());
                return cell.getOutput(rc);
            }
            HTMLDocumentFragmentWrapper doc = rc.getDocumentFactory().createHTMLDocumentFragmentWrapper();
            HTMLElement span = doc.createSPANElement();
            HTMLImageElement image = doc.createIMGElement();
            ImageUrlResource iconRes = new ImageUrlResource(tablecell.getIconPath());
            image.setSrc(iconRes.getFilePart());
            String alttext = tablecell.getIconAltText();
            if (alttext == null) {
                alttext = displaystr;
            }
            image.setAlt(alttext);
            span.appendChild(image);
            span.appendChild(doc.createTextNode("  "));
            span.appendChild(doc.createTextNode(displaystr));
            doc.appendToContentFragment((Node)span);
            return doc.createOutput(rc);
        }
        SsgLogUtilities.logExit((Object)this, "renderCell", null);
        return super.renderCell(rc, cell, cellInfo);
    }
}

