/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WContainer;
import com.ibm.psw.wcl.core.form.WComboBox;
import com.ibm.psw.wcl.core.form.WTextEntry;
import com.ibm.psw.wcl.core.layout.WBoxLayout;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Vector;

public class StorageUnitEntry
extends WContainer {
    public static final int UNITS_MB = 0;
    public static final int UNITS_GB = 1;
    public static final int UNITS_TB = 2;
    public static final int UNITS_PB = 3;
    private static final int UNITS_LAST_SELECTABLE = 3;
    public static final int UNITS_BYTES = 100;
    public static final int UNITS_KB = 101;
    private SsgConsoleResource m_consoleResource = null;
    private WComboBox m_units = null;
    private WTextEntry m_value = null;

    public StorageUnitEntry(String name, String label, Locale locale) {
        this.m_consoleResource = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", locale);
        WBoxLayout layout = new WBoxLayout("horizontal");
        this.m_value = SsgPsUtilities.createRTextEntry(name + "_StorageUnitEntry_value", label, -1, false);
        this.m_value.setSize(8);
        Vector<String> model = new Vector<String>();
        model.add(this.m_consoleResource.getMessage("COMMON_CAPACITY_SHORT_MB"));
        model.add(this.m_consoleResource.getMessage("COMMON_CAPACITY_SHORT_GB"));
        model.add(this.m_consoleResource.getMessage("COMMON_CAPACITY_SHORT_TB"));
        model.add(this.m_consoleResource.getMessage("COMMON_CAPACITY_SHORT_PB"));
        this.m_units = new WComboBox(name + "_StorageUnitEntry_units", model);
        this.m_units.setStyleInfo(SsgPsUtilities.getComboBoxStyle());
        layout.add((WComponent)this.m_value);
        layout.add((WComponent)this.m_units);
        layout.setAlignment((WComponent)this.m_units, "bottom");
        this.add((WComponent)layout);
    }

    public void setCurrentUnits(int units) {
        this.setCurrentUnits(units, true);
    }

    public int getCurrentUnits() {
        return this.m_units.getSelectedIndex();
    }

    public BigInteger getCurrentValue(int requestedUnits) throws NumberFormatException {
        if (this.m_value.getText() == null || this.m_value.getText().equals("")) {
            return null;
        }
        BigInteger value = new BigInteger(this.m_value.getText());
        int currentUnits = this.getCurrentUnits();
        switch (requestedUnits) {
            case 100: {
                switch (currentUnits) {
                    case 0: {
                        return value.multiply(new BigInteger("1000000"));
                    }
                    case 1: {
                        return value.multiply(new BigInteger("1000000000"));
                    }
                    case 2: {
                        return value.multiply(new BigInteger("1000000000000"));
                    }
                    case 3: {
                        return value.multiply(new BigInteger("1000000000000000"));
                    }
                }
                break;
            }
            case 101: {
                switch (currentUnits) {
                    case 0: {
                        return value.multiply(new BigInteger("1000"));
                    }
                    case 1: {
                        return value.multiply(new BigInteger("1000000"));
                    }
                    case 2: {
                        return value.multiply(new BigInteger("1000000000"));
                    }
                    case 3: {
                        return value.multiply(new BigInteger("1000000000000"));
                    }
                }
                break;
            }
            case 0: {
                switch (currentUnits) {
                    case 0: {
                        return value;
                    }
                    case 1: {
                        return value.multiply(new BigInteger("1000"));
                    }
                    case 2: {
                        return value.multiply(new BigInteger("1000000"));
                    }
                    case 3: {
                        return value.multiply(new BigInteger("1000000000"));
                    }
                }
                break;
            }
            case 1: {
                switch (currentUnits) {
                    case 0: {
                        return value.divide(new BigInteger("1000"));
                    }
                    case 1: {
                        return value;
                    }
                    case 2: {
                        return value.multiply(new BigInteger("1000"));
                    }
                    case 3: {
                        return value.multiply(new BigInteger("1000000"));
                    }
                }
                break;
            }
            case 2: {
                switch (currentUnits) {
                    case 0: {
                        return value.divide(new BigInteger("1000000"));
                    }
                    case 1: {
                        return value.divide(new BigInteger("1000"));
                    }
                    case 2: {
                        return value;
                    }
                    case 3: {
                        return value.multiply(new BigInteger("1000"));
                    }
                }
                break;
            }
            case 3: {
                switch (currentUnits) {
                    case 0: {
                        return value.divide(new BigInteger("1000000000"));
                    }
                    case 1: {
                        return value.divide(new BigInteger("1000000"));
                    }
                    case 2: {
                        return value.divide(new BigInteger("1000"));
                    }
                    case 3: {
                        return value;
                    }
                }
            }
        }
        SsgLogUtilities.throwUnexpectedError((Object)this, "getCurrentValue(int)", "Unknown units requested: " + requestedUnits, null);
        return null;
    }

    public void setLabelPosition(int labelPosition) {
        this.m_value.setLabelPosition(labelPosition);
    }

    public void setStatus(int status) {
        this.m_value.setStatus(status);
    }

    public void setTextEntrySize(int size) {
        this.m_value.setSize(size);
    }

    public void setValue(int value, int units) {
        this.m_value.setText(String.valueOf(value));
        this.setCurrentUnits(units, false);
    }

    public void setValue(BigInteger value, int units) {
        this.m_value.setText(value.toString());
        this.setCurrentUnits(units, false);
    }

    public String toString() {
        if (this.m_value.getText() == null || this.m_value.getText().equals("")) {
            return "";
        }
        String rval = null;
        try {
            rval = this.getCurrentValue(this.getCurrentUnits()).toString();
        }
        catch (NumberFormatException nfe) {
            SsgLogUtilities.logUnexpectedError((Object)this, "toString()", "The StorageUnitsEntry box did not contain a valid numeric value.", null);
            return null;
        }
        rval = rval + " " + (String)this.m_units.getCurrentValue();
        return rval;
    }

    private void setCurrentUnits(int units, boolean convertValue) {
        if (convertValue) {
            BigInteger bi = this.getCurrentValue(units);
            if (bi != null) {
                this.setValue(bi, units);
            }
        } else {
            if (units < 0 || units > 3) {
                SsgLogUtilities.throwUnexpectedError((Object)this, "setCurrentUnits(int,boolean)", "The requested units cannot be selected in the combo box.", null);
            }
            this.m_units.setSelectedIndex(units);
        }
    }
}

