/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.CommandEvent;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.layout.WBoxLayout;
import com.ibm.psw.wcl.core.markup.WImage;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.skins.base.BasePageStyleInfo;
import com.ibm.storage.console.ImageUrlResource;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.User;
import com.ibm.storage.console.gui.LogoutPage;
import com.ibm.storage.console.gui.MainPage;
import com.ibm.storage.console.gui.ToolbarButton;
import com.ibm.storage.console.util.HelpUtilities;
import com.ibm.storage.console.util.SsgLogUtilities;

public class ToolbarPage
extends WPage
implements ICommandListener {
    private LogoutPage m_logoutPage = null;
    private MainPage m_mainPage = null;
    private ToolbarButton m_bannerToggleButton = null;
    private ToolbarButton m_helpButton = null;
    private ToolbarButton m_homeButton = null;
    private ToolbarButton m_refreshButton = null;
    private ToolbarButton m_signoutButton = null;
    private ToolbarButton m_taButton = null;
    private User m_user = null;

    public ToolbarPage(WclFacade wcl, MainPage mainPage, User user) {
        this.m_user = user;
        this.m_mainPage = mainPage;
        this.setPageStyle();
        WBoxLayout outerLayout = new WBoxLayout("horizontal");
        outerLayout.setWidth("100%");
        this.add((WComponent)outerLayout);
        WBoxLayout leftLayout = new WBoxLayout("horizontal");
        leftLayout.setWidth("null");
        leftLayout.setGap(10);
        WBoxLayout rightLayout = new WBoxLayout("horizontal");
        rightLayout.setWidth("null");
        rightLayout.setGap(10);
        outerLayout.add((WComponent)leftLayout);
        outerLayout.setAlignment((WComponent)leftLayout, "left");
        outerLayout.add((WComponent)rightLayout);
        outerLayout.setAlignment((WComponent)rightLayout, "right");
        this.createButtons(leftLayout, rightLayout);
        HelpUtilities.setHelpLauncher(this, this.m_helpButton);
        this.m_logoutPage = new LogoutPage(0, user.getLocale());
    }

    public void commandPerformed(CommandEvent ce) {
        ToolbarButton source = (ToolbarButton)((Object)ce.getSource());
        if (source.getName().equals("home")) {
            this.m_mainPage.getWorkAreaPage().showWelcomePage();
        } else if (source.getName().equals("refresh")) {
            this.m_mainPage.refresh();
        } else if (source.getName().equals("bannerToggle")) {
            if (source.getCurrentImage() == 0) {
                this.m_mainPage.showBanner();
            } else {
                this.m_mainPage.hideBanner();
            }
        } else if (source.getName().equals("signout")) {
            try {
                TriggerContext tc = ce.getTriggerContext();
                tc.setRedirectPath(this.m_logoutPage.getURL((AContext)tc));
            }
            catch (Exception e) {
                SsgLogUtilities.throwUnexpectedError((Object)this, "commandPerformed(CommandEvent)", "Unable to redirect to logout page!", e);
            }
        } else if (source.getName().equals("taToggle") || source.getName().equals("closeTA")) {
            this.m_mainPage.getWorkAreaPage().toggleHelp();
        }
    }

    private void setPageStyle() {
        BasePageStyleInfo pageStyle = new BasePageStyleInfo();
        pageStyle.setStyleValue("page1", "background-color", (Object)"#DEDEE2");
        pageStyle.setStyleValue("page1", "color", (Object)"#000000");
        pageStyle.setStyleValue("page1", "border-color", (Object)"#FFFFFF #DEDEE2 #718FB8 #DEDEE2");
        pageStyle.setStyleValue("page1", "border-style", (Object)"solid");
        pageStyle.setStyleValue("page1", "border-width", (Object)"1px");
        pageStyle.setStyleValue("page1", "margin-left", (Object)"0px");
        pageStyle.setStyleValue("page1", "margin-top", (Object)"0px");
        pageStyle.setStyleValue("page1", "margin-right", (Object)"3px");
        pageStyle.setStyleValue("page1", "margin-bottom", (Object)"0px");
        pageStyle.setStyleValue("page1", "padding-top", (Object)"3px");
        pageStyle.setStyleValue("page1", "padding-bottom", (Object)"0px");
        this.setStyleInfo((AStyleInfo)pageStyle);
    }

    private void createButtons(WBoxLayout leftLayout, WBoxLayout rightLayout) {
        SsgConsoleResource res = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.m_user.getLocale());
        this.m_homeButton = new ToolbarButton("home", res.getMessage("TOOLTIP_HOME"), new ImageUrlResource("ssg/tb_home_24.gif"), (ICommandListener)this);
        this.m_bannerToggleButton = new ToolbarButton("bannerToggle", res.getMessage("TOOLTIP_BANNERTOGGLE"), new ImageUrlResource[]{new ImageUrlResource("ssg/closebanner.gif"), new ImageUrlResource("ssg/bnnropen1616.gif")}, (ICommandListener)this);
        this.m_refreshButton = new ToolbarButton("refresh", res.getMessage("TOOLTIP_REFRESH"), new ImageUrlResource("ssg/tb_refresh_24.gif"), (ICommandListener)this);
        this.m_signoutButton = new ToolbarButton("signout", res.getMessage("TOOLTIP_SIGNOUT"), new ImageUrlResource("ssg/signout.gif"), (ICommandListener)this);
        this.m_taButton = new ToolbarButton("taToggle", res.getMessage("TOOLTIP_TATOGGLE"), new ImageUrlResource("ssg/panelassist.gif"), (ICommandListener)this);
        this.m_helpButton = new ToolbarButton("help", res.getMessage("TOOLTIP_INFOCENTER"), new ImageUrlResource("ssg/infocenter.gif"), null);
        leftLayout.add((WComponent)this.m_homeButton);
        leftLayout.add((WComponent)this.m_bannerToggleButton);
        leftLayout.add((WComponent)this.m_refreshButton);
        leftLayout.add((WComponent)this.m_signoutButton);
        leftLayout.add((WComponent)new WImage(new ImageUrlResource("ssg/tb_seperator_16.gif").getFilePart()));
        rightLayout.add((WComponent)this.m_taButton);
        rightLayout.add((WComponent)this.m_helpButton);
    }
}

