/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.form.WTextEntry;
import com.ibm.psw.wcl.core.layout.WBoxLayout;
import com.ibm.psw.wcl.core.markup.WImage;
import com.ibm.psw.wcl.core.markup.WTextComponent;
import com.ibm.psw.wcl.core.resource.PathResource;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.skins.base.BaseTextEntryStyleInfo;
import com.ibm.storage.console.LocalUrlResource;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.util.StringTokenizer;

public class WIpEntry {
    private static final int MAX_QUAD_VALUE = 255;
    private LocalUrlResource m_statusResErr;
    private LocalUrlResource m_statusResNrm;
    private LocalUrlResource m_statusResReq;
    private WBoxLayout m_cntnLayout = null;
    private WBoxLayout m_ipLayout = null;
    private WBoxLayout m_labelLayout = null;
    private WImage m_statusImgErr;
    private WImage m_statusImgNrm;
    private WImage m_statusImgReq;
    private WTextEntry m_ipQuad1 = null;
    private WTextEntry m_ipQuad2 = null;
    private WTextEntry m_ipQuad3 = null;
    private WTextEntry m_ipQuad4 = null;

    public WIpEntry(String label) {
        this("IP1", label);
    }

    public WIpEntry(String id, String label) {
        this(id, label, null);
    }

    public WIpEntry(String id, String label, String ipAddress) {
        WTextComponent dot1 = SsgPsUtilities.createBoldTextComponent(".");
        WTextComponent dot2 = SsgPsUtilities.createBoldTextComponent(".");
        WTextComponent dot3 = SsgPsUtilities.createBoldTextComponent(".");
        BaseTextEntryStyleInfo txEntrySyle = new BaseTextEntryStyleInfo();
        AStyleInfo style = SsgPsUtilities.getTextEntryStyle();
        if (style != null) {
            style.setImageValue("IMG_STATUS_REQUIRED", (Object)new PathResource(), "", "");
            style.setImageValue("IMG_STATUS_ERROR", (Object)new PathResource(), "", "");
        }
        this.m_cntnLayout = new WBoxLayout("vertical");
        this.m_cntnLayout.setGap(0);
        this.m_cntnLayout.setWidth(null);
        this.m_labelLayout = new WBoxLayout("horizontal");
        this.m_labelLayout.setGap(0);
        this.m_labelLayout.setWidth(null);
        this.m_cntnLayout.add((WComponent)this.m_labelLayout);
        this.m_statusResReq = new LocalUrlResource("/images/ssg/status_required_11.gif");
        this.m_statusImgReq = new WImage(this.m_statusResReq.getFilePart());
        this.m_statusImgReq.setVisible(true);
        this.m_statusResErr = new LocalUrlResource("/images/ssg/status_error_11.gif");
        this.m_statusImgErr = new WImage(this.m_statusResErr.getFilePart());
        this.m_statusImgErr.setVisible(false);
        this.m_statusResNrm = new LocalUrlResource("/images/ssg/blank.gif");
        this.m_statusImgNrm = new WImage(this.m_statusResNrm.getFilePart());
        this.m_statusImgNrm.setVisible(false);
        this.m_labelLayout.add((WComponent)this.m_statusImgReq);
        this.m_labelLayout.add((WComponent)this.m_statusImgErr);
        this.m_labelLayout.add((WComponent)this.m_statusImgNrm);
        WTextComponent switch_IP_text = SsgPsUtilities.createTextComponent(label);
        this.m_labelLayout.add((WComponent)switch_IP_text);
        this.m_ipLayout = new WBoxLayout("horizontal");
        this.m_ipLayout.setGap(5);
        this.m_ipLayout.setWidth(null);
        this.m_ipQuad1 = SsgPsUtilities.createTextEntry(id, "", 3, true);
        this.m_ipQuad1.setSize(3);
        this.m_ipQuad1.setStyleInfo(style);
        this.m_ipQuad1.setLabelPosition(1);
        this.m_ipLayout.add((WComponent)this.m_ipQuad1);
        this.m_ipLayout.setAlignment((WComponent)this.m_ipQuad1, "bottomright");
        this.m_ipLayout.add((WComponent)dot1);
        this.m_ipLayout.setAlignment((WComponent)dot1, "bottom");
        this.m_ipQuad2 = SsgPsUtilities.createTextEntry(id + "2", "", 3, true);
        this.m_ipQuad2.setSize(3);
        this.m_ipQuad2.setStyleInfo(style);
        this.m_ipLayout.add((WComponent)this.m_ipQuad2);
        this.m_ipLayout.setAlignment((WComponent)this.m_ipQuad2, "bottomleft");
        this.m_ipLayout.add((WComponent)dot2);
        this.m_ipLayout.setAlignment((WComponent)dot2, "bottom");
        this.m_ipQuad3 = SsgPsUtilities.createTextEntry(id + "3", "", 3, true);
        this.m_ipQuad3.setSize(3);
        this.m_ipQuad3.setStyleInfo(style);
        this.m_ipLayout.add((WComponent)this.m_ipQuad3);
        this.m_ipLayout.setAlignment((WComponent)this.m_ipQuad3, "bottomleft");
        this.m_ipLayout.add((WComponent)dot3);
        this.m_ipLayout.setAlignment((WComponent)dot3, "bottom");
        this.m_ipQuad4 = SsgPsUtilities.createTextEntry(id + "4", "", 3, true);
        this.m_ipQuad4.setSize(3);
        this.m_ipQuad4.setStyleInfo(style);
        this.m_ipLayout.add((WComponent)this.m_ipQuad4);
        this.m_ipLayout.setAlignment((WComponent)this.m_ipQuad4, "bottomleft");
        if (ipAddress != null) {
            StringTokenizer st = new StringTokenizer(ipAddress, ".");
            String sIPQuad = st.nextToken();
            this.m_ipQuad1.setText(sIPQuad);
            sIPQuad = st.nextToken();
            this.m_ipQuad2.setText(sIPQuad);
            sIPQuad = st.nextToken();
            this.m_ipQuad3.setText(sIPQuad);
            sIPQuad = st.nextToken();
            this.m_ipQuad4.setText(sIPQuad);
        }
        this.m_cntnLayout.add((WComponent)this.m_ipLayout);
    }

    public void setEnabled(boolean enabled) {
        this.m_ipQuad1.setEnabled(enabled);
        this.m_ipQuad2.setEnabled(enabled);
        this.m_ipQuad3.setEnabled(enabled);
        this.m_ipQuad4.setEnabled(enabled);
    }

    public String getIpAddress() {
        SsgLogUtilities.logEntry(this, "getIpAddress()", null);
        String ipAddress = "";
        if (this.validateIpAddress()) {
            ipAddress = this.m_ipQuad1.getText().trim() + ".";
            ipAddress = ipAddress + this.m_ipQuad2.getText().trim() + ".";
            ipAddress = ipAddress + this.m_ipQuad3.getText().trim() + ".";
            ipAddress = ipAddress + this.m_ipQuad4.getText().trim();
        }
        SsgLogUtilities.logExit(this, "getIpAddress()", null);
        return ipAddress;
    }

    public WBoxLayout getLayout() {
        SsgLogUtilities.logEntry(this, "getLayout()", null);
        SsgLogUtilities.logExit(this, "getLayout()", null);
        return this.m_cntnLayout;
    }

    public void setStatus(int status) {
        SsgLogUtilities.logEntry(this, "setStatus(..)", null);
        switch (status) {
            case 1: {
                this.m_statusImgErr.setVisible(false);
                this.m_statusImgReq.setVisible(true);
                this.m_statusImgNrm.setVisible(false);
                this.m_ipQuad1.setStatus(1);
                this.m_ipQuad2.setStatus(1);
                this.m_ipQuad3.setStatus(1);
                this.m_ipQuad4.setStatus(1);
                break;
            }
            case 2: {
                this.m_statusImgErr.setVisible(true);
                this.m_statusImgReq.setVisible(false);
                this.m_statusImgNrm.setVisible(false);
                this.m_ipQuad1.setStatus(2);
                this.m_ipQuad2.setStatus(2);
                this.m_ipQuad3.setStatus(2);
                this.m_ipQuad4.setStatus(2);
                break;
            }
            default: {
                this.m_statusImgErr.setVisible(false);
                this.m_statusImgReq.setVisible(false);
                this.m_statusImgNrm.setVisible(true);
                this.m_ipQuad1.setStatus(0);
                this.m_ipQuad2.setStatus(0);
                this.m_ipQuad3.setStatus(0);
                this.m_ipQuad4.setStatus(0);
            }
        }
        SsgLogUtilities.logExit(this, "setStatus(..)", null);
    }

    public void reset() {
        SsgLogUtilities.logEntry(this, "reset()", null);
        this.m_ipQuad1.reset();
        this.m_ipQuad2.reset();
        this.m_ipQuad3.reset();
        this.m_ipQuad4.reset();
        SsgLogUtilities.logExit(this, "reset()", null);
    }

    public boolean validateIpAddress() {
        SsgLogUtilities.logEntry(this, "validateIpAddress()", null);
        boolean result = true;
        if (!this.validateQuad(this.m_ipQuad1, 1)) {
            result = false;
        }
        if (!this.validateQuad(this.m_ipQuad2, 0)) {
            result = false;
        }
        if (!this.validateQuad(this.m_ipQuad3, 0)) {
            result = false;
        }
        if (!this.validateQuad(this.m_ipQuad4, 0)) {
            result = false;
        }
        SsgLogUtilities.logExit(this, "validateIpAddress", null);
        return result;
    }

    private boolean validateInt(String entry, int min, int max) {
        SsgLogUtilities.logEntry(this, "validateInt", null);
        char[] chars = entry.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isDigit(chars[i])) {
                SsgLogUtilities.logExit(this, "validateInt", "false");
                return false;
            }
            ++i;
        }
        int intVal = Integer.parseInt(entry);
        if (intVal < min) {
            SsgLogUtilities.logExit(this, "validateInt", "false");
            return false;
        }
        if (intVal > max) {
            SsgLogUtilities.logExit(this, "validateInt", "false");
            return false;
        }
        SsgLogUtilities.logExit(this, "validateInt", "true");
        return true;
    }

    private boolean validateQuad(WTextEntry quadEntry, int min) {
        SsgLogUtilities.logEntry(this, "validateQuad(..)", null);
        boolean result = true;
        quadEntry.setStatus(1);
        String val = quadEntry.getText();
        if (val != null) {
            String value = val.trim();
            if (value != null && value.length() > 0) {
                if (!this.validateInt(value, min, 255)) {
                    result = false;
                }
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        SsgLogUtilities.logExit(this, "validateQuad(..)", null);
        return result;
    }
}

