/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.help.eclipse.webclient;

import com.ibm.storage.console.help.eclipse.webclient.HTMLAppletUtil;
import com.ibm.storage.console.help.eclipse.webclient.HTMLAssistant;
import com.ibm.storage.console.help.eclipse.webclient.HTMLController;
import com.ibm.storage.console.help.eclipse.webclient.HTMLRequestor;
import com.ibm.storage.console.help.eclipse.webclient.HTMLToolbarUtil;
import com.ibm.storage.console.help.eclipse.webclient.HelpDescriptor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;

public class ServletHelper {
    protected static final String DESCRIPTOR_NAME = "ECLIPSE_DESCRIPTOR";
    protected static final String DESCRIPTOR_PROPERTIES = "/WEB-INF/Help.properties";

    protected ServletHelper() {
    }

    public static String getEclipsePath(ServletContext application) {
        HelpDescriptor descriptor = ServletHelper.getDescriptor(application);
        String path = descriptor.getEclipsePath();
        return path;
    }

    public static String getRequest(Servlet servlet, String topicPath) {
        return ServletHelper.getRequest(ServletHelper.createRequestor(servlet), topicPath);
    }

    public static String getRequest(ServletContext application, String topicPath) {
        return ServletHelper.getRequest(ServletHelper.createRequestor(application), topicPath);
    }

    public static String getRequest(HTMLRequestor requestor, String topicPath) {
        return requestor.getRequest(topicPath);
    }

    public static String getRequest(Servlet servlet, String pluginID, String topicPath) {
        return ServletHelper.getRequest(ServletHelper.createRequestor(servlet), pluginID, topicPath);
    }

    public static String getRequest(ServletContext application, String pluginID, String topicPath) {
        return ServletHelper.getRequest(ServletHelper.createRequestor(application), pluginID, topicPath);
    }

    public static String getRequest(HTMLRequestor requestor, String pluginID, String topicPath) {
        String request = requestor.getRequest(pluginID, topicPath);
        return request;
    }

    public static HTMLAppletUtil createAppletUtil(ServletContext application) {
        return new HTMLAppletUtil(ServletHelper.findDescriptor(application));
    }

    public static HTMLAssistant createAssistant(Servlet servlet) {
        return new HTMLAssistant(ServletHelper.findDescriptor(servlet));
    }

    public static HTMLAssistant createAssistant(ServletContext application) {
        return new HTMLAssistant(ServletHelper.findDescriptor(application));
    }

    public static HTMLController createController(Servlet servlet) {
        return new HTMLController(ServletHelper.findDescriptor(servlet));
    }

    public static HTMLController createController(ServletContext application) {
        return new HTMLController(ServletHelper.findDescriptor(application));
    }

    public static HTMLRequestor createRequestor(Servlet servlet) {
        return new HTMLRequestor(ServletHelper.findDescriptor(servlet));
    }

    public static HTMLRequestor createRequestor(ServletContext application) {
        return new HTMLRequestor(ServletHelper.findDescriptor(application));
    }

    public static HTMLToolbarUtil createToolbarUtil(Servlet servlet) {
        return new HTMLToolbarUtil(ServletHelper.findDescriptor(servlet));
    }

    public static HTMLToolbarUtil createToolbarUtil(ServletContext application) {
        return new HTMLToolbarUtil(ServletHelper.findDescriptor(application));
    }

    public static HelpDescriptor findDescriptor(Servlet servlet) {
        return ServletHelper.findDescriptor(servlet.getServletConfig().getServletContext());
    }

    public static HelpDescriptor findDescriptor(ServletContext application) {
        Object o = application.getAttribute(DESCRIPTOR_NAME);
        if (o != null && o instanceof HelpDescriptor) {
            return (HelpDescriptor)o;
        }
        HelpDescriptor descriptor = ServletHelper.getDescriptor(application);
        application.setAttribute(DESCRIPTOR_NAME, (Object)descriptor);
        return descriptor;
    }

    protected static HelpDescriptor getDescriptor(ServletContext application) {
        HelpDescriptor descriptor = new HelpDescriptor();
        try {
            InputStream is = application.getResourceAsStream(DESCRIPTOR_PROPERTIES);
            if (is == null) {
                return descriptor;
            }
            Properties properties = new Properties();
            BufferedInputStream bis = new BufferedInputStream(is);
            properties.load(bis);
            bis.close();
            is.close();
            descriptor.init(properties);
        }
        catch (IOException ex) {
            System.out.println("Failed to load properties from /WEB-INF/Help.properties;\n" + ex.toString());
        }
        return descriptor;
    }
}

