/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.servlet;

import com.ibm.storage.console.ActionItem;
import com.ibm.storage.console.Application;
import com.ibm.storage.console.ConsoleContext;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.User;
import com.ibm.storage.console.servlet.ConsoleHttpServlet;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AppServlet
extends ConsoleHttpServlet {
    public void render(HttpServletRequest request, HttpServletResponse response, User user) {
        SsgLogUtilities.logEntrySSG((Object)this, "render(HttpServletRequest,HttpServletResponse)", null);
        Application app = user.getApplication();
        if (app != null) {
            try {
                app.render(new ConsoleContext(request, response, this.getServletConfig().getServletContext()));
            }
            catch (Exception ex) {
                SsgConsoleException cex = null;
                if (ex instanceof SsgConsoleException) {
                    cex = (SsgConsoleException)ex;
                } else {
                    cex = new SsgConsoleException("COMMON_UNKNOWN_ERROR", ex);
                    SsgLogUtilities.logUnexpectedError((Object)this, "render(HttpServletRequest,HttpServletResponse)", "Could not render the application.", (Throwable)ex);
                }
                String id = app.getCurrentActionItemId();
                if (id == null || id.length() == 0) {
                    id = "temporary_error_task";
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("PsAdaptor.pageClassname", "com.ibm.storage.console.adaptor.PsErrorPage");
                params.put("PsErrorPage.exception", cex);
                ActionItem errorAI = new ActionItem(id, "com.ibm.storage.console.adaptor.PsAdaptor", params);
                errorAI.setUser(user);
                if (errorAI != null) {
                    errorAI.render(new ConsoleContext(request, response, this.getServletConfig().getServletContext()));
                }
                SsgLogUtilities.throwUnexpectedError((Object)this, "render", "Could not launch the error page", null);
            }
        }
        SsgLogUtilities.logExitSSG((Object)this, "render(HttpServletRequest,HttpServletRespones)", null);
    }
}

