/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.servlet;

import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.trigger.IResult;
import com.ibm.storage.console.ApplicationTemplate;
import com.ibm.storage.console.CimomManager;
import com.ibm.storage.console.ConsoleManager;
import com.ibm.storage.console.FileResource;
import com.ibm.storage.console.HttpdManager;
import com.ibm.storage.console.RedirectManager;
import com.ibm.storage.console.RoleManager;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.User;
import com.ibm.storage.console.UserManager;
import com.ibm.storage.console.gui.MainPage;
import com.ibm.storage.console.servlet.ConsoleHttpServlet;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Console
extends ConsoleHttpServlet
implements ServletContextListener {
    private static Properties s_appAttrs = null;
    private static String s_webInfPath = null;
    private static HashMap s_data = new HashMap();
    private static UserManager s_userMgr = null;
    private static HttpdManager s_httpdMgr = null;
    private static CimomManager s_cimomMgr = null;
    private static RedirectManager s_redirectMgr = null;
    private static RoleManager s_roleMgr = null;
    private static Properties s_helpMappings = null;
    private static String s_helpPluginName = null;

    public static final String getAppAttributeValue(String attrname) {
        return s_appAttrs.getProperty(attrname);
    }

    public static final CimomManager getCimomManager() {
        return s_cimomMgr;
    }

    public static final HttpdManager getHttpdManager() {
        return s_httpdMgr;
    }

    public static final RedirectManager getRedirectManager() {
        return s_redirectMgr;
    }

    public static final RoleManager getRoleManager() {
        return s_roleMgr;
    }

    public static final UserManager getUserManager() {
        return s_userMgr;
    }

    public static final String getWebInfPath() {
        return s_webInfPath;
    }

    public static void setDatum(String name, Object value) {
        s_data.put(name, value);
    }

    public static Object getDatum(String name) {
        return s_data.get(name);
    }

    public static Properties getHelpMappings() {
        return s_helpMappings;
    }

    public static String getHelpPluginName() {
        return s_helpPluginName;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            s_data.clear();
        }
        catch (Exception ex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextDestroyed(ServletContextEvent)", "Couldn't destroy PS WCL facade.", (Throwable)ex);
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        Class<?> rmClass;
        s_webInfPath = sce.getServletContext().getRealPath(File.separator + "WEB-INF");
        ApplicationTemplate appTemplate = new ApplicationTemplate(new FileResource("application.xml", Locale.getDefault(), 0));
        s_appAttrs = new Properties(appTemplate.getAppAttributes());
        try {
            s_roleMgr = null;
            String rolemgr = Console.getAppAttributeValue("role_class");
            if (rolemgr == null || rolemgr.trim().length() == 0) {
                rolemgr = "com.ibm.storage.console.DefaultRoleManager";
            }
            rmClass = Class.forName(rolemgr);
            s_roleMgr = (RoleManager)rmClass.newInstance();
        }
        catch (ClassNotFoundException cex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "could not find the role manager " + Console.getAppAttributeValue("role_class"), (Throwable)cex);
        }
        catch (Exception ex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "Couldn't create role manager.", (Throwable)ex);
        }
        try {
            s_userMgr = null;
            Class<?> umClass = Class.forName(Console.getAppAttributeValue("authenticate_class"));
            s_userMgr = (UserManager)umClass.newInstance();
        }
        catch (ClassNotFoundException cex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "could not find the user manager " + Console.getAppAttributeValue("authenticate_class"), (Throwable)cex);
        }
        catch (Exception ex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "Couldn't create user manager.", (Throwable)ex);
        }
        try {
            String redirectMgr = Console.getAppAttributeValue("redirect_class");
            if (redirectMgr != null && redirectMgr.trim().length() > 0) {
                rmClass = Class.forName(redirectMgr);
                s_redirectMgr = (RedirectManager)rmClass.newInstance();
            }
        }
        catch (ClassNotFoundException cex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "could not find the redirect manager " + Console.getAppAttributeValue("redirect_class"), (Throwable)cex);
        }
        catch (Exception ex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "Couldn't create redirect manager.", (Throwable)ex);
        }
        String cimomMgr = "";
        try {
            cimomMgr = Console.getAppAttributeValue("cimom_class");
            if (cimomMgr == null || cimomMgr.trim().length() == 0) {
                cimomMgr = "com.ibm.storage.console.CimomManager";
            }
            Class<?> cmClass = Class.forName(cimomMgr);
            s_cimomMgr = (CimomManager)cmClass.newInstance();
        }
        catch (ClassNotFoundException cex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "could not find the cimom manager. " + cimomMgr, (Throwable)cex);
        }
        catch (Exception ex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "Couldn't create cimom manager.", (Throwable)ex);
        }
        String httpdMgr = "";
        try {
            httpdMgr = Console.getAppAttributeValue("httpd_class");
            if (httpdMgr == null || httpdMgr.trim().length() == 0) {
                httpdMgr = "com.ibm.storage.console.HttpdManager";
            }
            Class<?> hmClass = Class.forName(httpdMgr);
            s_httpdMgr = (HttpdManager)hmClass.newInstance();
        }
        catch (ClassNotFoundException cex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "could not find the httpd manager. " + httpdMgr, (Throwable)cex);
        }
        catch (Exception ex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "Couldn't create httpd manager.", (Throwable)ex);
        }
        Console.initHelpMappings();
    }

    public void destroy() {
        SsgLogUtilities.logEntrySSG((Object)this, "destroy()", null);
        SsgLogUtilities.logExitSSG((Object)this, "destroy()", null);
    }

    public void init() throws ServletException {
        SsgLogUtilities.logEntrySSG((Object)this, "init()", null);
        SsgLogUtilities.logExitSSG((Object)this, "init()", null);
    }

    public void render(HttpServletRequest req, HttpServletResponse resp, User user) {
        WclFacade cur_facade = null;
        try {
            String taskid = req.getParameter("Console.taskId");
            if (taskid == null && user.getApplication().getCurrentActionItemId() == null) {
                taskid = "welcome";
            }
            if (user.getApplication().getCurrentActionItemId() == null) {
                Enumeration pnames = req.getParameterNames();
                while (pnames.hasMoreElements()) {
                    String pname = (String)pnames.nextElement();
                    if (!pname.startsWith("Console.")) continue;
                    user.addConsoleParameter(pname, req.getParameter(pname));
                }
            }
            String baseUrl = user.getConsoleWclUrlBase();
            cur_facade = user.getConsoleWclFacade();
            RenderingContext rc = cur_facade.createRenderingContext(req, resp, this.getServletContext());
            TriggerContext tc = cur_facade.createTriggerContext(req, this.getServletContext());
            SsgPsUtilities.setWclFacadeSkin(cur_facade, rc);
            if (!req.getRequestURI().startsWith(baseUrl)) {
                MainPage consolePage = user.getConsolePage();
                if (consolePage == null) {
                    this.attachConsoleManager(user);
                    consolePage = new MainPage(cur_facade, rc, user);
                    user.setConsolePage(consolePage);
                }
                if (taskid != null) {
                    consolePage.getWorkAreaPage().launchTask(taskid);
                }
                SsgPsUtilities.sendPageToResponse(rc, consolePage, cur_facade);
            } else if (cur_facade.canHandleRequest(tc)) {
                IResult result = cur_facade.handleRequest(tc, rc);
                SsgPsUtilities.sendResultToResponse(tc, rc, result, cur_facade);
            }
        }
        catch (Exception ex) {
            SsgConsoleException cex = null;
            if (ex instanceof SsgConsoleException) {
                cex = (SsgConsoleException)ex;
            } else {
                cex = new SsgConsoleException("COMMON_UNKNOWN_ERROR", ex);
                SsgLogUtilities.logUnexpectedError((Object)this, "render(HttpServletRequest,HttpServletResponse)", "Could not render the console.", (Throwable)ex);
            }
            try {
                RenderingContext rc = cur_facade.createRenderingContext(req, resp, this.getServletContext());
                SsgPsUtilities.sendPageToResponse(rc, SsgPsUtilities.getErrorPage(cex, rc.getLocale()), null);
            }
            catch (Exception exx) {
                SsgLogUtilities.logUnexpectedError((Object)this, "render(HttpServletRequest,HttpServletResponse)", "Could not render the console error page.", (Throwable)exx);
            }
            return;
        }
    }

    private static final void initHelpMappings() {
        s_helpMappings = new Properties();
        try {
            s_helpMappings.load(new FileInputStream(new FileResource("help_mappings.properties").getFilename()));
        }
        catch (IOException ioex) {
            SsgLogUtilities.throwUnexpectedError("HelpUtilities", "initHelp", "Could not read help_mappings.properties", (Exception)ioex);
        }
        s_helpPluginName = s_helpMappings.getProperty("help.plugin.root");
    }

    private void attachConsoleManager(User user) {
        block4: {
            if (user.getConsoleManager() != null) break block4;
            String consoleMgr = "";
            try {
                consoleMgr = Console.getAppAttributeValue("console_class");
                if (consoleMgr == null || consoleMgr.trim().length() == 0) {
                    consoleMgr = "com.ibm.storage.console.ConsoleManager";
                }
                Class<?> cmClass = Class.forName(consoleMgr);
                ConsoleManager cm = (ConsoleManager)cmClass.newInstance();
                cm.setUser(user);
                user.setConsoleManager(cm);
            }
            catch (ClassNotFoundException cex) {
                SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "could not find the console manager. " + consoleMgr, (Throwable)cex);
            }
            catch (Exception ex) {
                SsgLogUtilities.logUnexpectedError((Object)this, "contextInitialized(ServletContextEvent)", "Couldn't create console manager.", (Throwable)ex);
            }
        }
    }
}

