/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.servlet;

import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.storage.console.LocalUrlResource;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.User;
import com.ibm.storage.console.UserMap;
import com.ibm.storage.console.gui.LogoutPage;
import com.ibm.storage.console.servlet.TokenManager;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class ConsoleHttpServlet
extends HttpServlet {
    public final void doGet(HttpServletRequest req, HttpServletResponse resp) {
        SsgLogUtilities.logEntrySSG((Object)this, "doGet()", "Wait for syncro");
        this.doPost(req, resp);
        SsgLogUtilities.logExitSSG((Object)this, "doGet()", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doPost(HttpServletRequest req, HttpServletResponse resp) {
        String loginToken;
        SsgLogUtilities.logEntrySSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "");
        try {
            req.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "Could not convert request params to UTF-8", (Throwable)ex);
        }
        HttpSession sess = null;
        ConsoleHttpServlet consoleHttpServlet = this;
        synchronized (consoleHttpServlet) {
            sess = req.getSession(false);
            if (sess == null) {
                SsgLogUtilities.logSSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "Create a new HttpSession");
                sess = req.getSession(true);
            }
        }
        if (sess == null) {
            SsgLogUtilities.logUnexpectedError((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "Could not create a new session.", null);
        }
        if ((loginToken = req.getParameter("Console.loginToken")) == null || loginToken.trim().length() == 0) {
            loginToken = "none";
        }
        SsgLogUtilities.logSSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "loginToken=" + loginToken);
        User user = null;
        ConsoleHttpServlet consoleHttpServlet2 = this;
        synchronized (consoleHttpServlet2) {
            UserMap users = (UserMap)sess.getAttribute("com.ibm.storage.console.Users");
            if (!(loginToken.equals("none") || users != null && users.containsToken(loginToken))) {
                if (TokenManager.validateLoginToken(loginToken)) {
                    user = TokenManager.getUser(loginToken);
                    user.setLocale(req.getLocale());
                    user.setHttpUserAgent(req.getHeader("User-Agent"));
                    TokenManager.invalidateLoginToken(loginToken);
                    user.bindToSession(sess);
                    sess.setMaxInactiveInterval(7200);
                    SsgLogUtilities.logSSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "Create a new user");
                }
            } else {
                SsgLogUtilities.logSSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "User has been created before");
                String userid = req.getParameter("WCLFacade.UserID");
                if (userid == null || userid.trim().length() == 0) {
                    userid = loginToken;
                }
                user = userid.equals("none") ? (User)sess.getAttribute("com.ibm.storage.console.LoginUser") : User.getUser(sess, userid);
            }
        }
        if (user != null) {
            Thread.currentThread().setName(user.getID() + " " + user.getName());
        }
        if (user == null || user.destroyed()) {
            SsgLogUtilities.logSSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "user==null|| user.destroyed()");
            String urlBase = new LocalUrlResource("/Login").getFilePart() + "/action/";
            WclFacade facade = new WclFacade(urlBase);
            RenderingContext rc = facade.createRenderingContext(req, resp, this.getServletContext());
            if (user != null) {
                user.unbindFromSession();
            }
            LogoutPage logoutPage = null;
            int reason = 1;
            if (!loginToken.equals("none")) {
                reason = 2;
            } else if (user != null) {
                reason = 0;
            }
            logoutPage = new LogoutPage(reason, req.getLocale());
            SsgLogUtilities.logSSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "Create LogoutPage reason=" + reason);
            try {
                SsgPsUtilities.sendPageToResponse(rc, logoutPage, null);
            }
            catch (Exception ex) {
                SsgConsoleException cex = null;
                if (ex instanceof SsgConsoleException) {
                    cex = (SsgConsoleException)ex;
                } else {
                    cex = new SsgConsoleException("COMMON_UNKNOWN_ERROR", ex);
                    SsgLogUtilities.logUnexpectedError((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "Could not render the logout page.", (Throwable)ex);
                }
                try {
                    SsgPsUtilities.sendPageToResponse(rc, SsgPsUtilities.getErrorPage(cex, rc.getLocale()), null);
                }
                catch (Exception exx) {
                    SsgLogUtilities.logUnexpectedError((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "Could not render the logout error page.", (Throwable)exx);
                }
            }
            finally {
                if (reason == 0) {
                    sess.invalidate();
                    SsgLogUtilities.logSSG((Object)this, "doPost", "Session (" + sess.getId() + ") has been invalidated.");
                }
            }
            SsgLogUtilities.logExitSSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "");
            return;
        }
        this.render(req, resp, user);
        SsgLogUtilities.logExitSSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "");
    }

    public abstract void render(HttpServletRequest var1, HttpServletResponse var2, User var3);
}

