/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.servlet;

import com.ibm.storage.console.User;
import com.ibm.storage.console.servlet.ConsoleHttpServlet;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Download
extends ConsoleHttpServlet {
    public static final String FILENAME_PARAMETER = "filename";
    public static final String INCLUDE_EXTENSION_PARAMETER = "extension";

    public void render(HttpServletRequest req, HttpServletResponse resp, User user) {
        String fileName = req.getParameter(FILENAME_PARAMETER);
        String includeExtensionParam = req.getParameter(INCLUDE_EXTENSION_PARAMETER);
        boolean includeExtension = false;
        if (includeExtensionParam != null && includeExtensionParam.equals("yes")) {
            includeExtension = true;
        }
        ServletOutputStream out = null;
        try {
            out = resp.getOutputStream();
            if (null != fileName && !"".equals(fileName.trim())) {
                File sourcefile = new File(fileName);
                byte[] content = null;
                boolean i = false;
                if (sourcefile.isFile() && sourcefile.canRead()) {
                    try {
                        int bytesRead;
                        BufferedInputStream source = new BufferedInputStream(new FileInputStream(sourcefile));
                        resp.setContentType("application/download");
                        if (includeExtension) {
                            resp.setHeader("Content-disposition", "=attachment; filename=" + sourcefile.getName());
                        } else {
                            resp.setHeader("Content-disposition", "=attachment; filename=" + sourcefile.getName().substring(0, sourcefile.getName().length() - 4));
                        }
                        content = new byte[0x100000];
                        resp.setHeader("Content-Length", "" + source.available());
                        while ((bytesRead = source.read(content, 0, content.length)) >= 0) {
                            out.write(content, 0, bytesRead);
                        }
                        source.close();
                    }
                    catch (FileNotFoundException e) {
                        SsgLogUtilities.log((Object)this, "DownloadServlet.render()", "The file " + fileName + " was not found!");
                        out.println("DownloadServlet.render() - non existent file " + fileName);
                    }
                    catch (IOException e) {
                        SsgLogUtilities.log((Object)this, "DownloadServlet.render()", "IOException occurs when reading the file " + fileName);
                        out.println("DownloadServlet.render() - IOException occurs when reading the file " + fileName);
                    }
                } else {
                    SsgLogUtilities.log((Object)this, "DownloadServlet.render()", "The file " + fileName + " was not found!");
                    out.println("DownloadServlet.render() - non existent file or cannot read the file " + fileName);
                }
            } else {
                SsgLogUtilities.log((Object)this, "DownloadServlet.render()", "The parameter 'filename' was not found!");
                out.println("DownloadServlet.render() - The parameter 'filename' was not found!");
            }
            out.flush();
            out.close();
        }
        catch (IOException e1) {
            SsgLogUtilities.log((Object)this, "DownloadServlet.render()", "IO Exception : " + e1.getMessage());
            return;
        }
    }
}

