/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.servlet;

import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.config.WclConfig;
import com.ibm.psw.wcl.core.config.WclFacadeConfig;
import com.ibm.psw.wcl.core.trigger.IResult;
import com.ibm.storage.console.FileResource;
import com.ibm.storage.console.LocalUrlResource;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.gui.HomeFrame;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Login
extends HttpServlet {
    private WPage m_homePage = null;
    private WclFacade m_loginWclFacade = null;

    public void destroy() {
        SsgLogUtilities.logEntrySSG((Object)this, "destroy()", null);
        this.destroyWclFacade();
        SsgLogUtilities.logExitSSG((Object)this, "destroy()", null);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        Thread.currentThread().setName(req.getRemoteHost());
        SsgLogUtilities.logEntrySSG((Object)this, "doGet(HttpServletRequest,HttpServletResponse)", null);
        this.doPost(req, resp);
        SsgLogUtilities.logExitSSG((Object)this, "doGet(HttpServletRequest,HttpServletResponse)", null);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        Thread.currentThread().setName(req.getRemoteHost());
        SsgLogUtilities.logEntrySSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", req.getAttributeNames().toString());
        try {
            req.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            SsgLogUtilities.logUnexpectedError((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "Cannot convert request params to UTF-8", (Throwable)ex);
        }
        try {
            String baseUrl = new LocalUrlResource("/Login").getFilePart();
            if (this.m_loginWclFacade == null) {
                WclConfig wclConfig = new WclConfig(new FileResource("wcl-config.xml").getFilename());
                WclFacadeConfig facadeConfig = wclConfig.getWclFacadeConfig("ssg-facade");
                SsgPsUtilities.fixWclFacadeConfig(facadeConfig, "-Login", "/Login/action/");
                this.m_loginWclFacade = new WclFacade(facadeConfig);
            }
            RenderingContext rc = this.m_loginWclFacade.createRenderingContext(req, resp, this.getServletContext());
            TriggerContext tc = this.m_loginWclFacade.createTriggerContext(req, this.getServletContext());
            SsgPsUtilities.setWclFacadeSkin(this.m_loginWclFacade, rc);
            if (req.getRequestURI().equals(baseUrl)) {
                this.m_homePage = new HomeFrame(rc, this.m_loginWclFacade);
                SsgPsUtilities.sendPageToResponse(rc, this.m_homePage, this.m_loginWclFacade);
            } else if (this.m_loginWclFacade.canHandleRequest(tc)) {
                IResult result = this.m_loginWclFacade.handleRequest(tc, rc);
                SsgPsUtilities.sendResultToResponse(tc, rc, result, this.m_loginWclFacade);
            }
        }
        catch (Exception ex) {
            SsgConsoleException cex = null;
            if (ex instanceof SsgConsoleException) {
                cex = (SsgConsoleException)ex;
            } else {
                cex = new SsgConsoleException("COMMON_UNKNOWN_ERROR", ex);
                SsgLogUtilities.logUnexpectedError((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "Could not render the login page.", (Throwable)ex);
            }
            try {
                RenderingContext rc = this.m_loginWclFacade.createRenderingContext(req, resp, this.getServletContext());
                SsgPsUtilities.sendPageToResponse(rc, SsgPsUtilities.getErrorPage(cex, rc.getLocale()), null);
            }
            catch (Exception exx) {
                SsgLogUtilities.logUnexpectedError((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "Could not render the login error page.", (Throwable)exx);
            }
            return;
        }
        SsgLogUtilities.logExitSSG((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", null);
    }

    private void destroyWclFacade() {
        SsgLogUtilities.logEntrySSG((Object)this, "destroyWclFacade()", null);
        if (this.m_loginWclFacade != null) {
            this.m_loginWclFacade.destroy();
            this.m_loginWclFacade = null;
        }
        SsgLogUtilities.logExitSSG((Object)this, "destroyWclFacade()", null);
    }
}

