/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.servlet;

import com.ibm.jsse.IBMJSSEProvider;
import com.ibm.net.ssl.internal.www.protocol.https.HttpsURLConnection;
import com.ibm.storage.console.User;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.server.UID;
import java.security.Provider;
import java.security.Security;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TokenManager
extends HttpServlet {
    private static final String DATUM_KEY = "LOGIN_TOKENS";
    private static final String INVALID_TOKEN = "NULL";
    private static final int TOKEN_TIMEOUT_SEC = 15;

    public static String getLoginToken(String username, String password) {
        SsgLogUtilities.logEntry("TokenManager", "getLoginToken", "User=" + username);
        try {
            User user = Console.getUserManager().authenticateUser(username, password);
            String token = new UID().toString();
            TokenManager.saveToken(token, user);
            SsgLogUtilities.logExit("TokenManager", "getLoginToken", token);
            return token;
        }
        catch (Exception ce) {
            SsgLogUtilities.logUnexpectedError("TokenManager", "getLoginToken", "User authentication failed: " + username + ", " + password, (Throwable)ce);
            SsgLogUtilities.logExit("TokenManager", "getLoginToken", null);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getRemoteLoginToken(String protocol, String host, String port, String appname, String username, String password) {
        SsgLogUtilities.logEntry("TokenManager", "getRemoteLoginToken", "Protocol=" + protocol + ", Host=" + host + ", Port=" + port + ", App=" + appname + ", User=" + username);
        try {
            int c;
            if (protocol.equals("https")) {
                System.setProperty("java.protocol.handler.pkgs", "com.ibm.net.ssl.internal.www.protocol");
                Security.addProvider((Provider)new IBMJSSEProvider());
            }
            URL url = new URL(protocol + "://" + host + ":" + port + "/" + appname + "/TokenManager" + "?user=" + username + "&passwd=" + password);
            InputStream input = null;
            if (protocol.equals("https")) {
                System.setProperty("javax.net.ssl.trustStore", Console.getHttpdManager().getTrustStore());
                System.setProperty("javax.net.ssl.trustStorePassword", Console.getHttpdManager().getTrustStorePassword());
                HttpsURLConnection hpsCon = (HttpsURLConnection)url.openConnection();
                hpsCon.setDoInput(true);
                input = hpsCon.getInputStream();
            } else {
                HttpURLConnection hpCon = (HttpURLConnection)url.openConnection();
                hpCon.setDoInput(true);
                input = hpCon.getInputStream();
            }
            StringBuffer buf = new StringBuffer();
            while ((c = input.read()) >= 0) {
                void var9_10;
                buf.append((char)var9_10);
            }
            input.close();
            String token = buf.toString().trim();
            SsgLogUtilities.logExit("TokenManager", "getRemoteLoginToken", token);
            return token;
        }
        catch (Exception ce) {
            SsgLogUtilities.logUnexpectedError("TokenManager", "getRemoteLoginToken", "Retrieving remote login token failed: " + username + ", " + password, (Throwable)ce);
            SsgLogUtilities.logExit("TokenManager", "getRemoteLoginToken", null);
            return null;
        }
    }

    public static User getUser(String token) {
        User user = null;
        HashMap tokens = (HashMap)Console.getDatum(DATUM_KEY);
        if (tokens != null) {
            user = (User)tokens.get(token);
        }
        return user;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SsgLogUtilities.logEntry((Object)this, "doGet", null);
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        String token = TokenManager.getLoginToken(request.getParameter("user"), request.getParameter("passwd"));
        if (token == null) {
            token = INVALID_TOKEN;
        }
        out.println(token);
        out.close();
        SsgLogUtilities.logExit((Object)this, "doGet", null);
    }

    public static void invalidateLoginToken(String token) {
        SsgLogUtilities.logEntry("TokenManager", "invalidateLoginToken", "token=" + token);
        HashMap tokens = TokenManager.getTokens();
        tokens.remove(token);
        TokenManager.saveTokens(tokens);
        SsgLogUtilities.logExit("TokenManager", "invalidateLoginToken", null);
    }

    public static void main(String[] args) {
        String logintok = TokenManager.getRemoteLoginToken("https", "whiteeagle.beaverton.ibm.com", "7979", "tank", "test", "test");
        System.out.println("Remote login token=" + logintok);
    }

    public static boolean validateLoginToken(String token) {
        SsgLogUtilities.logEntry("TokenManager", "validateLoginToken", "token=" + token);
        boolean bValid = false;
        Date date_now = new Date();
        HashMap tokens = TokenManager.getTokens();
        Object[] keys = tokens.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String key = (String)keys[i];
            User user = (User)tokens.get(key);
            Date date = user.getLoginTime();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(13, 15);
            Date date_after = cal.getTime();
            if (date_after.before(date_now)) {
                tokens.remove(key);
            }
            ++i;
        }
        TokenManager.saveTokens(tokens);
        if (tokens.get(token) != null) {
            bValid = true;
        }
        SsgLogUtilities.logExit("TokenManager", "validateLoginToken", String.valueOf(bValid));
        return bValid;
    }

    private static HashMap getTokens() {
        HashMap tokens = (HashMap)Console.getDatum(DATUM_KEY);
        if (tokens == null) {
            tokens = new HashMap();
        }
        return tokens;
    }

    private static void saveToken(String token, User user) {
        HashMap<String, User> tokens = (HashMap<String, User>)Console.getDatum(DATUM_KEY);
        if (tokens == null) {
            tokens = new HashMap<String, User>();
        }
        user.setLoginTime(new Date());
        user.setLoginToken(token);
        tokens.put(token, user);
        TokenManager.saveTokens(tokens);
    }

    private static void saveTokens(HashMap tokens) {
        Console.setDatum(DATUM_KEY, tokens);
    }
}

