/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.util;

import com.ibm.psw.wcl.components.message.MessageInfo;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.form.WImageButton;
import com.ibm.psw.wcl.core.frame.WFrame;
import com.ibm.psw.wcl.core.layout.WFramesetLayout;
import com.ibm.psw.wcl.core.markup.WHeadMarkup;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.psw.wcl.core.renderer.RendererInfo;
import com.ibm.storage.console.adaptor.SsgPsPage;
import com.ibm.storage.console.help.eclipse.webclient.HelpDescriptor;
import com.ibm.storage.console.help.ps.wcl.WEAssistant;
import com.ibm.storage.console.help.ps.wcl.WEController;
import com.ibm.storage.console.help.ps.wcl.WERequestor;
import com.ibm.storage.console.help.ps.wcl.WEToolbarUtil;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;

public class HelpUtilities {
    public static final String HELP_ASSISTANT_FRAMEID = "assistant";
    private static final HelpDescriptor des = new HelpDescriptor();
    private static WEController controller;
    private static WEAssistant assistant;
    private static WEToolbarUtil toolbarUtil;

    public static final String getAssistantFrameId() {
        return HELP_ASSISTANT_FRAMEID;
    }

    public static WFrame getAssistantFrame(String frametitle, String titleframetitle, String contentframetitle, String closealt, ICommandListener closelistener, String closetarget) {
        return assistant.getAssistantFrame(frametitle, titleframetitle, contentframetitle, closealt, closelistener, closetarget);
    }

    public static String getCloseButtonName() {
        return "closeTA";
    }

    public static void setHelp(WPage page, String helppath, String helpid) {
        SsgLogUtilities.logEntry("HelpUtilities", "setHelp(WPage,String,String)", page.getID() + ": " + helppath + ", " + helpid);
        WERequestor helpRequestor = new WERequestor(des);
        helpRequestor.setHelp(helppath, helpid);
        if (page instanceof SsgPsPage) {
            ((SsgPsPage)page).setHelpHeader(helpRequestor);
        } else {
            page.add((WComponent)helpRequestor);
        }
        SsgLogUtilities.logExit("HelpUtilities", "setHelp(WPage,String,String)", null);
    }

    public static void setHelpLauncher(WPage page, WImageButton button) {
        page.add((WComponent)toolbarUtil.getToolbarHeader());
        button.setOnClick(toolbarUtil.getShowCallJS());
    }

    public static void setLinkHelp(WHyperlink link, String topic) {
        String plugin = Console.getHelpPluginName();
        link.setOnClick("window.showHelp(\"" + plugin + "\", \"" + topic + ".html\");");
    }

    public static void setMessageHelp(WPage page, String msgid) {
        String plugin = Console.getHelpPluginName();
        HelpUtilities.setHelp(page, plugin, "msg_" + msgid.toLowerCase() + ".html");
    }

    public static void setPanelHelp(WPage page, String classname) {
        int delim;
        String plugin = Console.getHelpPluginName();
        String helpid = Console.getHelpMappings().getProperty(classname);
        if (helpid != null && (delim = helpid.indexOf(58)) != -1) {
            plugin = helpid.substring(0, delim);
            helpid = helpid.substring(delim + 1);
        }
        HelpUtilities.setHelp(page, plugin, helpid);
    }

    public static void setShowHelpScript(MessageInfo info) {
        String msgTopic = "msg_" + info.getMsgID().toLowerCase();
        String plugin = Console.getHelpPluginName();
        String script = "window.showHelp('" + plugin + "', '" + msgTopic + ".html');";
        info.setIDLinkScript(script);
    }

    public static void initHelpRootPage(WPage helproot, WFramesetLayout frameset) {
        SsgLogUtilities.logEntry("HelpUtilities", "initHelpRootPage(WPage,WFramesetLayout)", null);
        helproot.add((WComponent)controller.getControllerHeader());
        StringBuffer buf = new StringBuffer();
        buf.append("<script language=\"JavaScript\">\n");
        buf.append("function doLoad() {\n");
        buf.append(controller.getControllerLoadCallJS());
        buf.append("}\n");
        buf.append("function doUnload() {\n");
        buf.append(controller.getControllerUnloadCallJS());
        buf.append("}\n");
        buf.append("</script>\n");
        WHeadMarkup headmarkup = new WHeadMarkup();
        headmarkup.setMarkup(buf.toString(), RendererInfo.HTML_ALL);
        helproot.add((WComponent)headmarkup);
        frameset.setOnLoad("doLoad();");
        frameset.setOnUnload("doUnload();");
        SsgLogUtilities.logExit("HelpUtilities", "initHelpRootPage(WPage,WFramesetLayout)", null);
    }

    static {
        des.setEclipsePath("/help/");
        controller = new WEController(des);
        assistant = new WEAssistant(des);
        toolbarUtil = new WEToolbarUtil(des);
    }
}

