/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.util;

import com.ibm.ras.RASITraceLogger;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.websphere.ras.Manager;

public class LogUtilitiesOld {
    public static final String ORG = "IBM";
    public static final String PRODUCT = "STORAGE";
    private static RASITraceLogger m_consoleTraceLogger = null;
    private static boolean m_consoleTraceLoggerErrorFound = false;

    public static void log(Object originObject, String originMethod, String text) {
        if (LogUtilitiesOld.getTraceLogger() != null) {
            RASITraceLogger trace = LogUtilitiesOld.getTraceLogger();
            if (trace.isLoggable(16L)) {
                trace.trace(16L, originObject, originMethod, text);
            }
        } else {
            System.err.println("* Origin: " + originObject.getClass().getName() + ":" + originMethod);
            System.err.println(text);
        }
    }

    public static void log(String originClass, String originMethod, String text) {
        if (LogUtilitiesOld.getTraceLogger() != null) {
            RASITraceLogger trace = LogUtilitiesOld.getTraceLogger();
            if (trace.isLoggable(16L)) {
                trace.trace(16L, originClass, originMethod, text);
            }
        } else {
            System.out.println("* Origin: " + originClass + ":" + originMethod);
            System.out.println(text);
        }
    }

    public static void logEntry(Object originObject, String originMethod, String params) {
        if (LogUtilitiesOld.getTraceLogger() != null) {
            RASITraceLogger trace = LogUtilitiesOld.getTraceLogger();
            if (trace.isLoggable(4L)) {
                if (params != null) {
                    trace.entry(4L, originObject, originMethod, (Object)("Params: " + params));
                } else {
                    trace.entry(4L, originObject, originMethod);
                }
            }
        } else {
            System.out.println("[ Enter ]");
            System.out.println("* Origin: " + originObject.getClass().getName() + ":" + originMethod);
            if (params != null) {
                System.out.println("* Params: " + params);
            }
        }
    }

    public static void logEntry(String originClass, String originMethod, String params) {
        if (LogUtilitiesOld.getTraceLogger() != null) {
            RASITraceLogger trace = LogUtilitiesOld.getTraceLogger();
            if (trace.isLoggable(4L)) {
                if (params != null) {
                    trace.entry(4L, originClass, originMethod, (Object)("Params: " + params));
                } else {
                    trace.entry(4L, originClass, originMethod);
                }
            }
        } else {
            System.err.println("[ Enter ]");
            System.out.println("* Origin: " + originClass + ":" + originMethod);
            if (params != null) {
                System.out.println("* Params: " + params);
            }
        }
    }

    public static void logError(Object originObject, String originMethod, SsgConsoleException cause) {
        if (LogUtilitiesOld.getTraceLogger() != null) {
            RASITraceLogger trace = LogUtilitiesOld.getTraceLogger();
            if (trace.isLoggable(8L)) {
                trace.exception(8L, originObject, originMethod, (Exception)cause);
                Exception rootcause = cause.getRootCause();
                if (rootcause != null) {
                    trace.trace(8L, originObject, originMethod, "Root cause of the error: ");
                    trace.exception(8L, originObject, originMethod, rootcause);
                }
            }
        } else {
            System.err.println("[ Error ] ");
            System.err.println("* Origin: " + originObject.getClass().getName() + ":" + originMethod);
            cause.printStackTrace();
            Exception rootcause = cause.getRootCause();
            if (rootcause != null) {
                System.err.println("[ Root cause of the error ] ");
                rootcause.printStackTrace();
            }
        }
    }

    public static void logError(String originClass, String originMethod, SsgConsoleException cause) {
        if (LogUtilitiesOld.getTraceLogger() != null) {
            RASITraceLogger trace = LogUtilitiesOld.getTraceLogger();
            if (trace.isLoggable(8L)) {
                trace.exception(8L, originClass, originMethod, (Exception)cause);
                Exception rootcause = cause.getRootCause();
                if (rootcause != null) {
                    trace.trace(8L, originClass, originMethod, "Root cause of the error: ");
                    trace.exception(8L, originClass, originMethod, rootcause);
                }
            }
        } else {
            System.err.println("[ Error ] ");
            System.err.println("* Origin: " + originClass + ":" + originMethod);
            cause.printStackTrace();
            Exception rootcause = cause.getRootCause();
            if (rootcause != null) {
                System.err.println("[ Root cause of the error ] ");
                rootcause.printStackTrace();
            }
        }
    }

    public static void logExit(Object originObject, String originMethod, String retval) {
        if (LogUtilitiesOld.getTraceLogger() != null) {
            RASITraceLogger trace = LogUtilitiesOld.getTraceLogger();
            if (trace.isLoggable(4L)) {
                if (retval != null) {
                    trace.exit(4L, originObject, originMethod, (Object)("Return value: " + retval));
                } else {
                    trace.exit(4L, originObject, originMethod);
                }
            }
        } else {
            System.out.println("[ Exit ]");
            System.out.println("* Origin: " + originObject.getClass().getName() + ":" + originMethod);
            if (retval != null) {
                System.out.println("* Return value: " + retval);
            }
        }
    }

    public static void logExit(String originClass, String originMethod, String retval) {
        if (LogUtilitiesOld.getTraceLogger() != null) {
            RASITraceLogger trace = LogUtilitiesOld.getTraceLogger();
            if (trace.isLoggable(4L)) {
                if (retval != null) {
                    trace.exit(4L, originClass, originMethod, (Object)("Return value: " + retval));
                } else {
                    trace.exit(4L, originClass, originMethod);
                }
            }
        } else {
            System.out.println("[ Exit ]");
            System.out.println("* Origin: " + originClass + ":" + originMethod);
            if (retval != null) {
                System.out.println("* Return value: " + retval);
            }
        }
    }

    public static void logUnexpectedError(Object originObject, String originMethod, String errormsg, Exception cause) {
        if (LogUtilitiesOld.getTraceLogger() != null) {
            RASITraceLogger trace = LogUtilitiesOld.getTraceLogger();
            if (trace.isLoggable(8L)) {
                trace.trace(8L, originObject, originMethod, "Unexpected error:  " + errormsg);
                if (cause != null) {
                    trace.exception(8L, originObject, originMethod, cause);
                }
            }
        } else {
            System.err.println("Unexpected error:  " + errormsg);
            System.err.println("Origin: " + originObject.getClass().getName() + ":" + originMethod);
            if (cause != null) {
                cause.printStackTrace();
            }
        }
    }

    public static void logUnexpectedError(String originClass, String originMethod, String errormsg, Exception cause) {
        if (LogUtilitiesOld.getTraceLogger() != null) {
            RASITraceLogger trace = LogUtilitiesOld.getTraceLogger();
            if (trace.isLoggable(8L)) {
                trace.trace(8L, originClass, originMethod, "Unexpected error:  " + errormsg);
                if (cause != null) {
                    trace.exception(8L, originClass, originMethod, cause);
                }
            }
        } else {
            System.err.println("Unexpected error:  " + errormsg);
            System.err.println("Origin: " + originClass + ":" + originMethod);
            if (cause != null) {
                cause.printStackTrace();
            }
        }
    }

    public static void throwError(Object originObject, String originMethod, SsgConsoleException cause) throws SsgConsoleException {
        LogUtilitiesOld.logError(originObject, originMethod, cause);
        throw cause;
    }

    public static void throwError(String originClass, String originMethod, SsgConsoleException cause) throws SsgConsoleException {
        LogUtilitiesOld.logError(originClass, originMethod, cause);
        throw cause;
    }

    public static void throwUnexpectedError(Object originObject, String originMethod, String errormsg, Exception cause) {
        LogUtilitiesOld.logUnexpectedError(originObject, originMethod, errormsg, cause);
        throw new RuntimeException(errormsg);
    }

    public static void throwUnexpectedError(String originClass, String originMethod, String errormsg, Exception cause) {
        LogUtilitiesOld.logUnexpectedError(originClass, originMethod, errormsg, cause);
        throw new RuntimeException(errormsg);
    }

    protected static RASITraceLogger getTraceLogger() {
        block2: {
            if (m_consoleTraceLogger != null || m_consoleTraceLoggerErrorFound) break block2;
            try {
                Manager logMgr = Manager.getManager();
                m_consoleTraceLogger = logMgr.createRASTraceLogger(ORG, PRODUCT, "console", "ConsoleTrace");
            }
            catch (Throwable ex) {
                m_consoleTraceLogger = null;
                System.err.println("Failed to create the trace logger.  Use STDERR to log information.");
                ex.printStackTrace();
                m_consoleTraceLoggerErrorFound = true;
            }
        }
        return m_consoleTraceLogger;
    }
}

