/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class SsgLogFormatter
extends Formatter {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:S");
    Date dat = new Date();
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private Object[] args = new Object[1];

    public synchronized String format(LogRecord record) {
        StringBuffer sb;
        block9: {
            sb = new StringBuffer();
            String user = null;
            String methodName = null;
            StringTokenizer tokenizer = new StringTokenizer(record.getSourceMethodName(), "&");
            if (tokenizer.countTokens() == 2) {
                user = tokenizer.nextToken();
                methodName = tokenizer.nextToken();
            }
            if (record.getSourceMethodName().endsWith("&")) {
                user = record.getSourceMethodName().substring(0, record.getSourceMethodName().length() - 1);
                methodName = "";
            }
            if (record.getSourceMethodName().startsWith("&")) {
                user = "";
                methodName = record.getSourceMethodName().substring(1, record.getSourceMethodName().length());
            }
            this.dat.setTime(record.getMillis());
            sb.append("[").append(sdf.format(this.dat)).append("] ");
            if (null != user) {
                sb.append(" " + user + " ");
            }
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
            } else {
                sb.append(record.getLoggerName());
            }
            if (record.getSourceMethodName() != null) {
                sb.append(" ");
                sb.append(methodName);
            }
            sb.append(this.lineSeparator);
            String message = this.formatMessage(record);
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            sb.append(message);
            sb.append(this.lineSeparator);
            if (record.getThrown() == null) break block9;
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {}
        }
        return sb.toString();
    }
}

