/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.util;

import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SsgLogUtilities {
    private static final String LOGGER_NAME = "com.ibm.storage.console";
    private static Logger m_logger;
    private static Logger error_logger;
    private static Logger ssg_logger;
    private static String defaultLevel;
    private static String defautLocation;
    private static String defaultCount;
    private static String delaultLimit;
    private static String errorLogLimit;
    private static String ssgLogLimit;
    private static String systemProperty;

    public static void log(Object originObject, String originMethod, String text) {
        SsgLogUtilities.log(originObject.getClass().getName(), originMethod, text);
    }

    public static void log(String originClass, String originMethod, String text) {
        originMethod = Thread.currentThread().getName() + "&" + originMethod;
        if (SsgLogUtilities.getLogger() != null) {
            SsgLogUtilities.getLogger().logp(Level.FINER, originClass, originMethod, text);
        } else {
            System.err.println("* Origin: " + originClass + ":" + originMethod);
            System.err.println(text);
        }
    }

    public static void logEntry(Object originObject, String originMethod, String params) {
        SsgLogUtilities.logEntry(originObject.getClass().getName(), originMethod, params);
    }

    public static void logEntry(String originClass, String originMethod, String params) {
        originMethod = Thread.currentThread().getName() + "&" + originMethod;
        if (SsgLogUtilities.getLogger() != null) {
            SsgLogUtilities.getLogger().entering(originClass, originMethod, params);
        } else {
            System.out.println("[ Enter ]");
            System.out.println("* Origin: " + originClass + ":" + originMethod);
            if (params != null) {
                System.out.println("* Params: " + params);
            }
        }
    }

    public static void logEntrySSG(Object originObject, String originMethod, String params) {
        SsgLogUtilities.logEntrySSG(originObject.getClass().getName(), originMethod, params);
    }

    public static void logEntrySSG(String originClass, String originMethod, String params) {
        originMethod = Thread.currentThread().getName() + "&" + originMethod;
        if (SsgLogUtilities.getSSGLoger() != null) {
            SsgLogUtilities.getSSGLoger().entering(originClass, originMethod, params);
        } else {
            System.out.println("[ Enter ]");
            System.out.println("* Origin: " + originClass + ":" + originMethod);
            if (params != null) {
                System.out.println("* Params: " + params);
            }
        }
    }

    public static void logError(Object originObject, String originMethod, SsgConsoleException cause) {
        SsgLogUtilities.logError(originObject.getClass().getName(), originMethod, cause);
    }

    public static void logError(String originClass, String originMethod, SsgConsoleException cause) {
        Exception rootcause;
        originMethod = Thread.currentThread().getName() + "&" + originMethod;
        if (SsgLogUtilities.getLogger() != null) {
            SsgLogUtilities.getLogger().throwing(originClass, originMethod, cause);
            rootcause = cause.getRootCause();
            if (rootcause != null) {
                SsgLogUtilities.getLogger().throwing(originClass, originMethod, rootcause);
            }
        } else {
            System.err.println("[ Error ] ");
            System.err.println("* Origin: " + originClass + ":" + originMethod);
            cause.printStackTrace();
            rootcause = cause.getRootCause();
            if (rootcause != null) {
                System.err.println("[ Root cause of the error ] ");
                rootcause.printStackTrace();
            }
        }
        if (SsgLogUtilities.getErrorLoger() != null) {
            rootcause = cause.getRootCause();
            if (rootcause != null) {
                LogRecord lrRoot = new LogRecord(Level.SEVERE, "THROW");
                lrRoot.setSourceClassName(originClass);
                lrRoot.setSourceMethodName(originMethod);
                lrRoot.setThrown(rootcause);
                SsgLogUtilities.getErrorLoger().log(lrRoot);
            }
        } else {
            System.err.println("[ Error ] ");
            System.err.println("* Origin: " + originClass + ":" + originMethod);
            cause.printStackTrace();
            rootcause = cause.getRootCause();
            if (rootcause != null) {
                System.err.println("[ Root cause of the error ] ");
                rootcause.printStackTrace();
            }
        }
    }

    public static void logExit(Object originObject, String originMethod, String retval) {
        SsgLogUtilities.logExit(originObject.getClass().getName(), originMethod, retval);
    }

    public static void logExit(String originClass, String originMethod, String retval) {
        originMethod = Thread.currentThread().getName() + "&" + originMethod;
        if (SsgLogUtilities.getLogger() != null) {
            SsgLogUtilities.getLogger().exiting(originClass, originMethod, retval);
        } else {
            System.out.println("[ Exit ]");
            System.out.println("* Origin: " + originClass + ":" + originMethod);
            if (retval != null) {
                System.out.println("* Return value: " + retval);
            }
        }
    }

    public static void logExitSSG(Object originObject, String originMethod, String retval) {
        SsgLogUtilities.logExitSSG(originObject.getClass().getName(), originMethod, retval);
    }

    public static void logExitSSG(String originClass, String originMethod, String retval) {
        originMethod = Thread.currentThread().getName() + "&" + originMethod;
        if (SsgLogUtilities.getSSGLoger() != null) {
            SsgLogUtilities.getSSGLoger().exiting(originClass, originMethod, retval);
        } else {
            System.out.println("[ Exit ]");
            System.out.println("* Origin: " + originClass + ":" + originMethod);
            if (retval != null) {
                System.out.println("* Return value: " + retval);
            }
        }
    }

    public static void logSSG(Object originObject, String originMethod, String text) {
        SsgLogUtilities.logSSG(originObject.getClass().getName(), originMethod, text);
    }

    public static void logSSG(String originClass, String originMethod, String text) {
        originMethod = Thread.currentThread().getName() + "&" + originMethod;
        if (SsgLogUtilities.getSSGLoger() != null) {
            SsgLogUtilities.getSSGLoger().logp(Level.FINER, originClass, originMethod, text);
        } else {
            System.err.println("* Origin: " + originClass + ":" + originMethod);
            System.err.println(text);
        }
    }

    public static void logUnexpectedError(Object originObject, String originMethod, String errormsg, Throwable cause) {
        SsgLogUtilities.logUnexpectedError(originObject.getClass().getName(), originMethod, errormsg, cause);
    }

    public static void logUnexpectedError(String originClass, String originMethod, String errormsg, Throwable cause) {
        originMethod = Thread.currentThread().getName() + "&" + originMethod;
        if (SsgLogUtilities.getLogger() != null) {
            SsgLogUtilities.getLogger().logp(Level.FINER, originClass, originMethod, "Unexpected error:  " + errormsg);
            SsgLogUtilities.getLogger().throwing(originClass, originMethod, cause);
        } else {
            System.err.println("Unexpected error:  " + errormsg);
            System.err.println("Origin: " + originClass + ":" + originMethod);
            if (cause != null) {
                cause.printStackTrace();
            }
        }
        if (SsgLogUtilities.getErrorLoger() != null) {
            LogRecord lr = new LogRecord(Level.SEVERE, "THROW");
            lr.setMessage(errormsg);
            lr.setSourceClassName(originClass);
            lr.setSourceMethodName(originMethod);
            lr.setThrown(cause);
            SsgLogUtilities.getErrorLoger().logp(Level.FINER, originClass, originMethod, "Unexpected error:  " + errormsg);
            SsgLogUtilities.getErrorLoger().log(lr);
        } else {
            System.err.println("Unexpected error:  " + errormsg);
            System.err.println("Origin: " + originClass + ":" + originMethod);
            if (cause != null) {
                cause.printStackTrace();
            }
        }
    }

    public static void throwError(Object originObject, String originMethod, SsgConsoleException cause) throws SsgConsoleException {
        SsgLogUtilities.logError(originObject, Thread.currentThread().getName() + "&" + originMethod, cause);
        throw cause;
    }

    public static void throwError(String originClass, String originMethod, SsgConsoleException cause) throws SsgConsoleException {
        SsgLogUtilities.logError(originClass, Thread.currentThread().getName() + "&" + originMethod, cause);
        throw cause;
    }

    public static void throwUnexpectedError(Object originObject, String originMethod, String errormsg, Exception cause) {
        SsgLogUtilities.logUnexpectedError(originObject, Thread.currentThread().getName() + "&" + originMethod, errormsg, (Throwable)cause);
        throw new RuntimeException(errormsg);
    }

    public static void throwUnexpectedError(String originClass, String originMethod, String errormsg, Exception cause) {
        SsgLogUtilities.logUnexpectedError(originClass, Thread.currentThread().getName() + "&" + originMethod, errormsg, (Throwable)cause);
        throw new RuntimeException(errormsg);
    }

    protected static Logger getLogger() {
        return m_logger;
    }

    private static Logger getErrorLoger() {
        return error_logger;
    }

    private static Logger getSSGLoger() {
        return ssg_logger;
    }

    static {
        block22: {
            String version;
            boolean targetCreated;
            File targetLocation;
            m_logger = null;
            error_logger = null;
            ssg_logger = null;
            defaultLevel = "ALL";
            defautLocation = "logs";
            defaultCount = "3";
            delaultLimit = "50000000";
            errorLogLimit = "10000000";
            ssgLogLimit = "5000000";
            systemProperty = "com.ibm.storage.ess.gui.logging";
            LogManager logManager = LogManager.getLogManager();
            String levelString = defaultLevel;
            String location = defautLocation;
            String count = defaultCount;
            String limit = delaultLimit;
            String property = System.getProperty(systemProperty);
            if (property != null) {
                File file = new File(property);
                FileInputStream is = null;
                try {
                    if (file.exists()) {
                        is = new FileInputStream(file);
                        Properties logProperties = new Properties();
                        logProperties.load(is);
                        levelString = logProperties.getProperty("level", levelString);
                        location = logProperties.getProperty("location", location);
                        count = logProperties.getProperty("count", count);
                        limit = logProperties.getProperty("limit", limit);
                    }
                }
                catch (Exception ex) {
                    levelString = defaultLevel;
                    location = defautLocation;
                    count = defaultCount;
                    limit = delaultLimit;
                }
            }
            if (!(targetLocation = new File(location)).exists() && !(targetCreated = targetLocation.mkdirs())) {
                levelString = defaultLevel;
                location = defautLocation;
                count = defaultCount;
                limit = delaultLimit;
            }
            Integer intLimit = null;
            try {
                intLimit = new Integer(limit);
            }
            catch (Exception ex) {
                intLimit = new Integer(delaultLimit);
            }
            Integer intCount = null;
            try {
                intCount = new Integer(count);
            }
            catch (Exception ex) {
                intCount = new Integer(defaultCount);
            }
            Level level = null;
            try {
                level = Level.parse(levelString);
            }
            catch (Exception ex) {
                level = Level.ALL;
            }
            String appName = Console.getAppAttributeValue("name");
            String logger_name = "com.ibm.storage.console." + appName;
            m_logger = Logger.getLogger(logger_name);
            m_logger.setLevel(level);
            error_logger = Logger.getLogger("com.ibm.storage.console.GuiError");
            ssg_logger = Logger.getLogger("com.ibm.storage.console.SSG");
            ssg_logger.setLevel(Level.FINER);
            try {
                FileHandler fileHendler = new FileHandler(location + "/" + appName + "%g.log", intLimit, intCount);
                fileHendler.setFormatter(new SsgLogFormatter());
                m_logger.addHandler(fileHendler);
                System.out.println("Logging mechanism initialized");
                String version2 = Console.getAppAttributeValue("version_tag");
                if (version2 != null) {
                    SsgLogUtilities.log("", "", "Application version: " + version2);
                } else {
                    SsgLogUtilities.log("", "", "Application version: unknown");
                }
            }
            catch (Exception ex) {
                System.out.println("Logging mechanism failed to initialized");
            }
            try {
                Integer intErrorLogLimit = new Integer(errorLogLimit);
                FileHandler fileHendlerTrigger = new FileHandler(location + "/" + "GuiError.log", intErrorLogLimit, 1);
                fileHendlerTrigger.setFormatter(new SsgLogFormatter());
                error_logger.addHandler(fileHendlerTrigger);
                System.out.println("Logging mechanism initialized for GuiError log");
                version = Console.getAppAttributeValue("version_tag");
                if (version != null) {
                    SsgLogUtilities.log("", "", "Application version: " + version);
                } else {
                    SsgLogUtilities.log("", "", "Application version: unknown");
                }
            }
            catch (Exception ex) {
                System.out.println("Logging mechanism failed to initialized");
            }
            try {
                Integer intSSGLogLimit = new Integer(ssgLogLimit);
                FileHandler fileHendlerSSG = new FileHandler(location + "/" + "SSG.log", intSSGLogLimit, 1);
                fileHendlerSSG.setLevel(Level.FINER);
                fileHendlerSSG.setFormatter(new SsgLogFormatter());
                ssg_logger.addHandler(fileHendlerSSG);
                System.out.println("Logging mechanism initialized for SSG log");
                version = Console.getAppAttributeValue("version_tag");
                if (version != null) {
                    SsgLogUtilities.log("", "", "Application version: " + version);
                    break block22;
                }
                SsgLogUtilities.log("", "", "Application version: unknown");
            }
            catch (Exception ex) {
                System.out.println("Logging mechanism failed to initialized");
            }
        }
    }
}

