/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.util;

import com.ibm.storage.console.FileResource;
import com.ibm.storage.console.LocalUrlResource;
import com.ibm.storage.console.RemoteUrlResource;
import com.ibm.storage.console.Resource;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlUtilities {
    private static DocumentBuilder m_xmlParser = null;

    protected XmlUtilities() {
    }

    public static final Document createXml(String name) throws SsgConsoleException {
        if (!name.startsWith("itpc:")) {
            SsgLogUtilities.throwError("XmlUtilities", "createXml(String)", new SsgConsoleException("INVALID_XML_REQUESTED"));
        }
        Document doc = null;
        DOMImplementation domImplementation = m_xmlParser.getDOMImplementation();
        try {
            doc = domImplementation.createDocument("http://www.ibm.com/storage/itpc", name, null);
            if (!doc.getDocumentElement().hasAttribute("xmlns:itpc")) {
                doc.getDocumentElement().setAttribute("xmlns:itpc", "http://www.ibm.com/storage/itpc");
            }
        }
        catch (DOMException de) {
            SsgLogUtilities.throwError("XmlUtilities", "createXml(String)", new SsgConsoleException("INVALID_XML_REQUESTED", de));
        }
        return doc;
    }

    public static final Document parseXml(Resource resource) {
        Document doc = null;
        if (resource instanceof FileResource) {
            doc = XmlUtilities.parseXmlFile(((FileResource)resource).getFile());
        } else if (resource instanceof LocalUrlResource) {
            doc = XmlUtilities.parseXmlUri(((LocalUrlResource)resource).getFilePart(1));
        } else if (resource instanceof RemoteUrlResource) {
            doc = XmlUtilities.parseXmlUri(((RemoteUrlResource)resource).getUrl().toString());
        } else {
            SsgLogUtilities.throwUnexpectedError("XmlUtilities", "parseXml(Resource)", "Unknown resource type!", null);
        }
        return doc;
    }

    public static final void serializeXml(Document doc, FileResource resource) throws SsgConsoleException {
        XMLSerializer serializer = null;
        try {
            OutputFormat format = new OutputFormat(doc, "UTF-8", true);
            serializer = new XMLSerializer((OutputStream)new FileOutputStream(resource.getFile()), format);
        }
        catch (FileNotFoundException fnfe) {
            SsgLogUtilities.throwError("XmlUtilities", "serializeXml(Document,FileResource)", new SsgConsoleException("FILE_NOT_WRITABLE", fnfe));
        }
        try {
            serializer.serialize(doc);
        }
        catch (IOException ioe) {
            SsgLogUtilities.throwError("XmlUtilities", "serializeXml(Document,FileResource)", new SsgConsoleException("FILE_WRITE_IO_ERROR", ioe));
        }
    }

    public static void translateDocument(Document document, SsgConsoleResource resbundle) {
        Element docElement = document.getDocumentElement();
        XmlUtilities.translateChildren(docElement, resbundle);
    }

    private static final Document parseXmlFile(File f) {
        Document doc = null;
        try {
            doc = m_xmlParser.parse(f);
        }
        catch (SAXException se) {
            SsgLogUtilities.throwUnexpectedError("XmlUtilities", "parseXmlFile(File)", "Invalid XML file!", (Exception)se);
        }
        catch (IOException ioe) {
            SsgLogUtilities.throwUnexpectedError("XmlUtilities", "parseXmlFile(File)", "Could not read the file!", (Exception)ioe);
        }
        return doc;
    }

    private static final Document parseXmlUri(String uri) {
        Document doc = null;
        try {
            doc = m_xmlParser.parse(uri);
        }
        catch (SAXException se) {
            SsgLogUtilities.throwUnexpectedError("XmlUtilities", "parseXmlUri(String)", "Invalid XML file!", (Exception)se);
        }
        catch (IOException ioe) {
            SsgLogUtilities.throwUnexpectedError("XmlUtilities", "parseXmlUri(String)", "Could access the uri!", (Exception)ioe);
        }
        return doc;
    }

    private static void translateChildren(Element element, SsgConsoleResource resbundle) {
        String strMsgID;
        if (element.hasAttribute("msg_id") && (strMsgID = element.getAttribute("msg_id")) != null) {
            String strRes = resbundle.getMessage(strMsgID);
            if (strRes == null || strRes.trim().length() == 0) {
                SsgLogUtilities.throwUnexpectedError("XmlUtilities", "translateChildren", "Invalid msg for msgid:" + strMsgID, null);
            }
            element.getFirstChild().setNodeValue(strRes);
        }
        if (element.hasChildNodes()) {
            if (element.getFirstChild() instanceof Element) {
                XmlUtilities.translateChildren((Element)element.getFirstChild(), resbundle);
            }
            Node nodeSibling = element.getFirstChild().getNextSibling();
            while (nodeSibling != null) {
                if (nodeSibling instanceof Element) {
                    XmlUtilities.translateChildren((Element)nodeSibling, resbundle);
                }
                nodeSibling = nodeSibling.getNextSibling();
            }
        }
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            m_xmlParser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            SsgLogUtilities.logError("XmlUtilities", "(static block)", new SsgConsoleException("CANT_CREATE_XML_PARSER"));
        }
    }
}

