/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.tomcat.internal.TomcatPlugin;
import org.eclipse.tomcat.internal.TomcatResources;

public class LocalConnectionTest
extends Thread {
    private static final int CLIENT_TIMEOUT = 1000;
    private String host;
    private int port;
    private boolean success;

    private LocalConnectionTest(String host, int port) {
        this.host = host;
        this.port = port;
        this.success = false;
        this.setDaemon(true);
        this.setName("ServerInterfaceTest");
    }

    public void run() {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
            this.success = true;
        }
        catch (IOException iOException) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException2) {}
        }
    }

    public static String getLocalInterface(int port) {
        try {
            if (LocalConnectionTest.testInterface("127.0.0.1", port)) {
                return "127.0.0.1";
            }
            String hostname = InetAddress.getLocalHost().getHostName();
            InetAddress[] addr = InetAddress.getAllByName(hostname);
            int i = 0;
            while (i < addr.length) {
                if (LocalConnectionTest.testInterface(addr[i].getHostAddress(), port)) {
                    return addr[i].getHostAddress();
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            TomcatPlugin.logError(TomcatResources.getString("LocalConnectionTest.cannotGetLocalhostName"), ioe);
        }
        return "localhost";
    }

    private static boolean testInterface(String host, int port) {
        LocalConnectionTest test = new LocalConnectionTest(host, port);
        test.start();
        try {
            test.join(1000L);
            return test.success;
        }
        catch (InterruptedException interruptedException) {
            test.interrupt();
            return test.success;
        }
    }
}

