/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import org.apache.catalina.net.ServerSocketFactory;

public class PortTrackingServerSocketFactory
implements ServerSocketFactory {
    private int assignedPort;

    public ServerSocket createSocket(int port) throws IOException {
        ServerSocket socket = new ServerSocket(port);
        this.listen(socket);
        this.assignedPort = socket.getLocalPort();
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        ServerSocket socket = new ServerSocket(port, backlog);
        this.listen(socket);
        this.assignedPort = socket.getLocalPort();
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        ServerSocket socket = new ServerSocket(port, backlog, ifAddress);
        this.listen(socket);
        this.assignedPort = socket.getLocalPort();
        return socket;
    }

    public int getAssignedPort() {
        return this.assignedPort;
    }

    private void listen(ServerSocket ssocket) {
        try {
            ssocket.setSoTimeout(1);
            try {
                ssocket.accept();
            }
            catch (IOException iOException) {}
            ssocket.setSoTimeout(0);
        }
        catch (SocketException socketException) {}
    }
}

