/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.filetransfer.client;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse.IBMJSSEProvider;
import com.ibm.net.ssl.internal.www.protocol.https.HttpsURLConnection;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminDataHolder;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.filetransfer.FileTransferUtils;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.ws.util.ImplFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;

public class FileTransferClientImpl
implements FileTransferClient,
NotificationListener {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$management$filetransfer$client$FileTransferClientImpl == null ? (class$com$ibm$ws$management$filetransfer$client$FileTransferClientImpl = FileTransferClientImpl.class$("com.ibm.ws.management.filetransfer.client.FileTransferClientImpl")) : class$com$ibm$ws$management$filetransfer$client$FileTransferClientImpl, "Admin", "com.ibm.ws.management.resources.fileservice");
    private static String UTF_ENCODING = "UTF-8";
    String transferHost = null;
    int transferPort = 0;
    int transferSecurePort = 0;
    boolean securityEnabled = false;
    boolean setAuthHeader = false;
    String protocolToUse = "http";
    int portToUse = 0;
    String serverStagingLocation = null;
    FileTransferConfig ftConfig = null;
    VariableMap vmap = null;
    int defaultBufferSize = 8192;
    private Properties jmxConnProps = null;
    private AdminClient adminClient = null;
    private ObjectName ftServerObjName = null;
    private int retryLimit = FileTransferConfigImpl.DEFAULT_RETRIES;
    private int retryWaitTime = FileTransferConfigImpl.DEFAULT_TIMEOUT;
    private RoleBasedAuthorizer roleBasedAuth = null;
    static /* synthetic */ Class class$com$ibm$ws$management$filetransfer$client$FileTransferClientImpl;
    static /* synthetic */ Class class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions;
    static /* synthetic */ Class class$com$ibm$websphere$management$AdminClient;
    static /* synthetic */ Class class$java$lang$String;

    public void uploadFile(InputStream inputStream, String string) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
        this.uploadFile(inputStream, string, fileTransferOptions);
    }

    public void uploadFile(File file, String string) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
        this.uploadFile(file, string, fileTransferOptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void uploadFile(InputStream inputStream, String string, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        int n = 0;
        try {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "uploadFile (3) from InputStream, destPath=" + string + "options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
                }
                if (fileTransferOptions == null) {
                    fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
                }
                if (string.startsWith("\\") || string.startsWith("/")) {
                    string = string.substring(1);
                }
                this.checkAccessPermission(string);
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append("/FileTransfer/transfer/");
                stringBuffer.append(this.encode(string));
                stringBuffer.append("?");
                stringBuffer.append("overwrite");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isOverwrite()));
                stringBuffer.append("&");
                stringBuffer.append("compress");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
                uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "upload url=" + uRL);
                }
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("PUT");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestProperty("file-transfer-uri-encoding", UTF_ENCODING);
                this.addAuthHeader(httpURLConnection);
                this.connectToServer(httpURLConnection);
                FilterOutputStream filterOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                if (fileTransferOptions.isCompress()) {
                    filterOutputStream = new GZIPOutputStream(filterOutputStream);
                }
                byte[] byArray = new byte[this.defaultBufferSize];
                int n2 = inputStream.read(byArray);
                while (n2 != -1) {
                    ((OutputStream)filterOutputStream).write(byArray, 0, n2);
                    n2 = inputStream.read(byArray);
                }
                inputStream.close();
                ((OutputStream)filterOutputStream).flush();
                ((OutputStream)filterOutputStream).close();
                n = httpURLConnection.getResponseCode();
                if (n != 200) {
                    throw new TransferFailedException("File upload failed [" + n + "]");
                }
                Object var12_14 = null;
            }
            catch (TransferFailedException transferFailedException) {
                if (!tc.isDebugEnabled()) throw transferFailedException;
                Tr.debug(tc, string, transferFailedException);
                throw transferFailedException;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, iOException);
                }
                Tr.service(tc, "ADFS0124", new Object[]{string, iOException});
                throw new TransferFailedException("Error occurred during upload.", iOException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.uploadFile", (String)"245", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, throwable);
                }
                Tr.service(tc, "ADFS0124", new Object[]{string, throwable});
                throw new TransferFailedException("Error occurred during upload.", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "uploadFile (3) rc=" + n);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "uploadFile (3) rc=" + n);
    }

    public void uploadFile(File file, String string, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        file = this.mapVariables(file);
        this.uploadFile(file, string, 0L, file.length(), fileTransferOptions);
    }

    public void uploadFile(File file, String string, long l) throws TransferFailedException, IndexOutOfBoundsException {
        file = this.mapVariables(file);
        this.uploadFile(file, string, l, file.length());
    }

    public void uploadFile(File file, String string, long l, FileTransferOptions fileTransferOptions) throws TransferFailedException, IndexOutOfBoundsException {
        file = this.mapVariables(file);
        this.uploadFile(file, string, l, file.length(), fileTransferOptions);
    }

    public void uploadFile(File file, String string, long l, long l2) throws TransferFailedException, IndexOutOfBoundsException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
        this.uploadFile(file, string, l, l2, fileTransferOptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void uploadFile(File file, String string, long l, long l2, FileTransferOptions fileTransferOptions) throws TransferFailedException, IndexOutOfBoundsException {
        URL uRL = null;
        try {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "uploadFile (3) from srcFile=" + file + ", destPath=" + string + "options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
                }
                if (fileTransferOptions == null) {
                    fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
                }
                if (l > l2 || l < 0L) {
                    throw new IndexOutOfBoundsException("The [rangeStart, rangeEnd] values are not valid [" + l + ", " + l2 + "].");
                }
                if (string.startsWith("\\") || string.startsWith("/")) {
                    string = string.substring(1);
                }
                this.checkAccessPermission(string);
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append("/FileTransfer/transfer/");
                stringBuffer.append(this.encode(string));
                stringBuffer.append("?");
                stringBuffer.append("overwrite");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isOverwrite()));
                stringBuffer.append("&");
                stringBuffer.append("compress");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
                uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "upload url=" + uRL);
                }
                this.uploadFileInternal(uRL, file, l, l2, fileTransferOptions);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!tc.isDebugEnabled()) throw indexOutOfBoundsException;
                Tr.debug(tc, string, indexOutOfBoundsException);
                throw indexOutOfBoundsException;
            }
            catch (TransferFailedException transferFailedException) {
                if (!tc.isDebugEnabled()) throw transferFailedException;
                Tr.debug(tc, string, transferFailedException);
                throw transferFailedException;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, iOException);
                }
                Tr.service(tc, "ADFS0124", new Object[]{string, iOException});
                throw new TransferFailedException("Error occurred during upload.", iOException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.uploadFile", (String)"415", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, throwable);
                }
                Tr.service(tc, "ADFS0124", new Object[]{string, throwable});
                throw new TransferFailedException("Error occurred during upload.", throwable);
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "uploadFile (3)");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "uploadFile (3)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadFileInternal(URL uRL, File file, long l, long l2, FileTransferOptions fileTransferOptions) throws TransferFailedException, IOException {
        RandomAccessFile randomAccessFile;
        block35: {
            randomAccessFile = null;
            OutputStream outputStream = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uploadInternal");
            }
            try {
                try {
                    String string = this.mapVariables(file.toString());
                    file = new File(string);
                    randomAccessFile = new RandomAccessFile(file, "r");
                    boolean bl = false;
                    if (l >= randomAccessFile.length()) {
                        randomAccessFile.close();
                        throw new IndexOutOfBoundsException("The rangeStart goes past the end of the file. Nothing will be transferred.  rangeStart=[" + l + "].");
                    }
                    long l3 = 0x100000L;
                    long l4 = 0L;
                    long l5 = 0L;
                    int n = (int)Math.min((long)this.defaultBufferSize, l3);
                    int n2 = 0;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    while (n2 <= this.retryLimit) {
                        try {
                            randomAccessFile.seek(l);
                            l4 = l;
                            l5 = l2 > l && l2 - l < l3 ? l2 : l4 + l3;
                            bl3 = false;
                            while (!bl2) {
                                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                                httpURLConnection.setRequestMethod("PUT");
                                httpURLConnection.setDoOutput(true);
                                httpURLConnection.setRequestProperty("file-append", bl3 ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                                httpURLConnection.setRequestProperty("file-timestamp", Long.toString(file.lastModified()));
                                httpURLConnection.setRequestProperty("file-transfer-uri-encoding", UTF_ENCODING);
                                this.addAuthHeader(httpURLConnection);
                                this.connectToServer(httpURLConnection);
                                outputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                                if (fileTransferOptions.isCompress()) {
                                    outputStream = new GZIPOutputStream(outputStream);
                                }
                                byte[] byArray = new byte[n];
                                int n3 = randomAccessFile.read(byArray);
                                boolean bl4 = false;
                                while (n3 != -1) {
                                    outputStream.write(byArray, 0, (int)Math.min((long)n3, l5 - l4));
                                    if (randomAccessFile.getFilePointer() < l5) {
                                        if (randomAccessFile.getFilePointer() + (long)this.defaultBufferSize > l5) {
                                            n3 = randomAccessFile.read(byArray, 0, (int)(l5 - randomAccessFile.getFilePointer()));
                                            continue;
                                        }
                                        n3 = randomAccessFile.read(byArray);
                                        continue;
                                    }
                                    n3 = -1;
                                }
                                if (outputStream instanceof GZIPOutputStream) {
                                    ((GZIPOutputStream)outputStream).finish();
                                }
                                outputStream.flush();
                                outputStream.close();
                                String string2 = httpURLConnection.getHeaderField(0);
                                if (string2 != null) {
                                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                                    String string3 = stringTokenizer.nextToken();
                                    String string4 = stringTokenizer.nextToken();
                                    int n4 = Integer.parseInt(string4);
                                    if (n4 != 200) {
                                        String string5 = string2.substring(string2.indexOf(string4));
                                        throw new TransferFailedException(string5);
                                    }
                                } else {
                                    int n5 = httpURLConnection.getResponseCode();
                                    if (n5 != 200) {
                                        throw new TransferFailedException(httpURLConnection.getResponseMessage());
                                    }
                                }
                                if (l5 >= l2) {
                                    bl2 = true;
                                    continue;
                                }
                                bl3 = true;
                                l4 = l5;
                                if (l2 == 0L || (l5 += l3) <= l2) continue;
                                l5 = l2;
                            }
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                            if (!fileTransferOptions.isDeleteSourceOnCompletion()) break;
                            file.delete();
                            break;
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.uploadFileInternal", (String)"566", (Object)this);
                            if (outputStream != null) {
                                outputStream.close();
                            }
                            if (++n2 > this.retryLimit) {
                                String string6 = "Upload retry limit exceeded for file " + file.toString() + ".";
                                Tr.error(tc, "ADFS0112", string6);
                                throw new TransferFailedException("Upload transfer failed. Retry limit exceeded.", iOException);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Wait " + this.retryWaitTime + " seconds and retry file upload for: " + file.toString());
                            }
                            try {
                                Thread.sleep(this.retryWaitTime * 1000);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    Object var33_35 = null;
                    if (outputStream == null) break block35;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (!tc.isDebugEnabled()) throw indexOutOfBoundsException;
                    Tr.debug(tc, uRL.toString(), indexOutOfBoundsException);
                    throw indexOutOfBoundsException;
                }
                catch (TransferFailedException transferFailedException) {
                    if (!tc.isDebugEnabled()) throw transferFailedException;
                    Tr.debug(tc, uRL.toString(), transferFailedException);
                    throw transferFailedException;
                }
                catch (IOException iOException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, uRL.toString(), iOException);
                    }
                    Tr.service(tc, "ADFS0124", new Object[]{uRL, iOException});
                    throw new TransferFailedException("Error occurred during upload.", iOException);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.uploadFileInternal", (String)"601", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, uRL.toString(), throwable);
                    }
                    Tr.service(tc, "ADFS0124", new Object[]{uRL, throwable});
                    throw new TransferFailedException("Error occurred during upload.", throwable);
                }
            }
            catch (Throwable throwable) {
                Object var33_36 = null;
                if (outputStream != null) {
                    outputStream.close();
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "uploadInternal");
                throw throwable;
            }
            outputStream.close();
        }
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "uploadInternal");
    }

    public InputStream downloadFile(String string, long l, long l2) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
        return this.downloadFile(string, l, l2, fileTransferOptions);
    }

    public void downloadFile(String string, File file, long l, long l2) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
        this.downloadFile(string, file, l, l2, fileTransferOptions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream downloadFile(String string, long l, long l2, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        InputStream inputStream;
        URL uRL = null;
        try {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "downloadFile (1) to InputStream. srcPath=" + string + ", rangeStart=" + l + "rangeEnd=" + l2);
                }
                if (l > l2) throw new IndexOutOfBoundsException("The [rangeStart, rangeEnd] values are not valid [" + l + ", " + l2 + "].");
                if (l < 0L) {
                    throw new IndexOutOfBoundsException("The [rangeStart, rangeEnd] values are not valid [" + l + ", " + l2 + "].");
                }
                if (fileTransferOptions == null) {
                    fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
                }
                if (string.startsWith("\\") || string.startsWith("/")) {
                    string = string.substring(1);
                }
                this.checkAccessPermission(string);
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append("/FileTransfer/transfer/");
                stringBuffer.append(this.encode(string));
                stringBuffer.append("?");
                stringBuffer.append("rangeStart");
                stringBuffer.append("=");
                stringBuffer.append(l);
                stringBuffer.append("&");
                stringBuffer.append("rangeEnd");
                stringBuffer.append("=");
                stringBuffer.append(l2);
                stringBuffer.append("&");
                stringBuffer.append("compress");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
                stringBuffer.append("&");
                stringBuffer.append("deleteOnCompletion");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
                uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
                inputStream = this.download(uRL, fileTransferOptions.isCompress(), null);
                Object var11_12 = null;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!tc.isDebugEnabled()) throw indexOutOfBoundsException;
                Tr.debug(tc, string, indexOutOfBoundsException);
                throw indexOutOfBoundsException;
            }
            catch (TransferFailedException transferFailedException) {
                if (!tc.isDebugEnabled()) throw transferFailedException;
                Tr.debug(tc, string, transferFailedException);
                throw transferFailedException;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, iOException);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
                throw new TransferFailedException("Error occurred during download.", iOException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"725", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, throwable);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
                throw new TransferFailedException("Error occurred during download.", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "downloadFile (1)");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return inputStream;
        Tr.exit(tc, "downloadFile (1)");
        return inputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void downloadFile(String string, File file, long l, long l2, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        try {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "downloadFile (2) to file. srcPath=" + string + ", destFile=" + file.toString() + ", rangeStart=" + l + "rangeEnd=" + l2 + ", options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
                }
                if (l > l2 || l < 0L) {
                    throw new IndexOutOfBoundsException("The [rangeStart, rangeEnd] values are not valid [" + l + ", " + l2 + "].");
                }
                if (fileTransferOptions == null) {
                    fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
                }
                if (string.startsWith("\\") || string.startsWith("/")) {
                    string = string.substring(1);
                }
                this.checkAccessPermission(string);
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append("/FileTransfer/transfer/");
                stringBuffer.append(this.encode(string));
                stringBuffer.append("?");
                stringBuffer.append("rangeStart");
                stringBuffer.append("=");
                stringBuffer.append(l);
                stringBuffer.append("&");
                stringBuffer.append("rangeEnd");
                stringBuffer.append("=");
                stringBuffer.append(l2);
                stringBuffer.append("&");
                stringBuffer.append("compress");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
                stringBuffer.append("&");
                stringBuffer.append("deleteOnCompletion");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
                uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
                this.download(uRL, file, fileTransferOptions.isCompress(), l, l2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!tc.isDebugEnabled()) throw indexOutOfBoundsException;
                Tr.debug(tc, string, indexOutOfBoundsException);
                throw indexOutOfBoundsException;
            }
            catch (TransferFailedException transferFailedException) {
                if (!tc.isDebugEnabled()) throw transferFailedException;
                Tr.debug(tc, string, transferFailedException);
                throw transferFailedException;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, iOException);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
                throw new TransferFailedException("Error occurred during download.", iOException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"826", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, throwable);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
                throw new TransferFailedException("Error occurred during download.", throwable);
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "downloadFile (2)");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "downloadFile (2)");
    }

    public InputStream downloadFile(String string, long l) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
        return this.downloadFile(string, l, fileTransferOptions);
    }

    public void downloadFile(String string, File file, long l) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
        this.downloadFile(string, file, l, fileTransferOptions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream downloadFile(String string, long l, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        InputStream inputStream;
        URL uRL = null;
        try {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "downloadFile (3) to InputStream. srcPath=" + string + ", rangeStart=" + l + ", options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
                }
                if (l < 0L) {
                    throw new IndexOutOfBoundsException("The rangeStart value is not valid [" + l + "].");
                }
                if (fileTransferOptions == null) {
                    fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
                }
                if (string.startsWith("\\") || string.startsWith("/")) {
                    string = string.substring(1);
                }
                this.checkAccessPermission(string);
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append("/FileTransfer/transfer/");
                stringBuffer.append(this.encode(string));
                stringBuffer.append("?");
                stringBuffer.append("rangeStart");
                stringBuffer.append("=");
                stringBuffer.append(l);
                stringBuffer.append("&");
                stringBuffer.append("compress");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
                stringBuffer.append("&");
                stringBuffer.append("deleteOnCompletion");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
                uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
                inputStream = this.download(uRL, fileTransferOptions.isCompress(), null);
                Object var9_11 = null;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!tc.isDebugEnabled()) throw indexOutOfBoundsException;
                Tr.debug(tc, string, indexOutOfBoundsException);
                throw indexOutOfBoundsException;
            }
            catch (TransferFailedException transferFailedException) {
                if (!tc.isDebugEnabled()) throw transferFailedException;
                Tr.debug(tc, string, transferFailedException);
                throw transferFailedException;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, iOException);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
                throw new TransferFailedException("Error occurred during download.", iOException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"940", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, throwable);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
                throw new TransferFailedException("Error occurred during download.", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "downloadFile (3)");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return inputStream;
        Tr.exit(tc, "downloadFile (3)");
        return inputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void downloadFile(String string, File file, long l, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        try {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "downloadFile (4) to file. srcPath=" + string + ", destFile=" + file.toString() + ", options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
                }
                if (l < 0L) {
                    throw new IndexOutOfBoundsException("The rangeStart value is not valid [" + l + "].");
                }
                if (fileTransferOptions == null) {
                    fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
                }
                if (string.startsWith("\\") || string.startsWith("/")) {
                    string = string.substring(1);
                }
                this.checkAccessPermission(string);
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append("/FileTransfer/transfer/");
                stringBuffer.append(this.encode(string));
                stringBuffer.append("?");
                stringBuffer.append("rangeStart");
                stringBuffer.append("=");
                stringBuffer.append(l);
                stringBuffer.append("&");
                stringBuffer.append("compress");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
                stringBuffer.append("&");
                stringBuffer.append("deleteOnCompletion");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
                uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
                this.download(uRL, file, fileTransferOptions.isCompress(), l, 0L);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!tc.isDebugEnabled()) throw indexOutOfBoundsException;
                Tr.debug(tc, string, indexOutOfBoundsException);
                throw indexOutOfBoundsException;
            }
            catch (TransferFailedException transferFailedException) {
                if (!tc.isDebugEnabled()) throw transferFailedException;
                Tr.debug(tc, string, transferFailedException);
                throw transferFailedException;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, iOException);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
                throw new TransferFailedException("Error occurred during download.", iOException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"1026", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, throwable);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
                throw new TransferFailedException("Error occurred during download.", throwable);
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "downloadFile (4)");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "downloadFile (4)");
    }

    public InputStream downloadFile(String string) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
        return this.downloadFile(string, fileTransferOptions);
    }

    public void downloadFile(String string, File file) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
        this.downloadFile(string, file, fileTransferOptions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream downloadFile(String string, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        InputStream inputStream;
        URL uRL = null;
        try {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "downloadFile (5) to InputStream. srcPath=" + string + ", options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
                }
                if (fileTransferOptions == null) {
                    fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
                }
                if (string.startsWith("\\")) {
                    string = string.substring(1);
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                this.checkAccessPermission(string);
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append("/FileTransfer/transfer/");
                stringBuffer.append(this.encode(string));
                stringBuffer.append("?");
                stringBuffer.append("compress");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
                stringBuffer.append("&");
                stringBuffer.append("deleteOnCompletion");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
                uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
                inputStream = this.download(uRL, fileTransferOptions.isCompress(), null);
                Object var7_9 = null;
            }
            catch (TransferFailedException transferFailedException) {
                if (!tc.isDebugEnabled()) throw transferFailedException;
                Tr.debug(tc, string, transferFailedException);
                throw transferFailedException;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, iOException);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
                throw new TransferFailedException("Error occurred during download.", iOException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"1121", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, throwable);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
                throw new TransferFailedException("Error occurred during download.", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "downloadFile (5)");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return inputStream;
        Tr.exit(tc, "downloadFile (5)");
        return inputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void downloadFile(String string, File file, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        try {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "downloadFile (6) to file. srcPath=" + string + ", destFile=" + file.toString() + ", options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
                }
                if (fileTransferOptions == null) {
                    fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions == null ? (class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions = FileTransferClientImpl.class$("com.ibm.websphere.management.filetransfer.client.FileTransferOptions")) : class$com$ibm$websphere$management$filetransfer$client$FileTransferOptions);
                }
                this.checkAccessPermission(string);
                if (string.startsWith("\\") || string.startsWith("/")) {
                    string = string.substring(1);
                }
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append("/FileTransfer/transfer/");
                stringBuffer.append(this.encode(string));
                stringBuffer.append("?");
                stringBuffer.append("compress");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
                stringBuffer.append("&");
                stringBuffer.append("deleteOnCompletion");
                stringBuffer.append("=");
                stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
                uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
                this.download(uRL, file, fileTransferOptions.isCompress(), 0L, 0L);
            }
            catch (TransferFailedException transferFailedException) {
                if (!tc.isDebugEnabled()) throw transferFailedException;
                Tr.debug(tc, string, transferFailedException);
                throw transferFailedException;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, iOException);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
                throw new TransferFailedException("Error occurred during download.", iOException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", (String)"1195", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, throwable);
                }
                Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
                throw new TransferFailedException("Error occurred during download.", throwable);
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "downloadFile (6)");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "downloadFile (6)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream download(URL uRL, boolean bl, ResultsObject resultsObject) throws TransferFailedException, IOException {
        try {
            HttpURLConnection httpURLConnection;
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "download (7) url=" + uRL + ", compress=" + bl);
                }
                int n = 0;
                while (n <= this.retryLimit) {
                    String string;
                    block32: {
                        Object object;
                        try {
                            httpURLConnection = (HttpURLConnection)uRL.openConnection();
                            httpURLConnection.setRequestMethod("GET");
                            httpURLConnection.setRequestProperty("file-transfer-uri-encoding", UTF_ENCODING);
                            httpURLConnection.setDoOutput(false);
                            httpURLConnection.setDoInput(true);
                            this.addAuthHeader(httpURLConnection);
                            this.connectToServer(httpURLConnection);
                            try {
                                Object object2;
                                int n2 = 0;
                                object = null;
                                string = httpURLConnection.getHeaderField(0);
                                if (string != null) {
                                    object2 = new StringTokenizer(string, " ");
                                    String string2 = ((StringTokenizer)object2).nextToken();
                                    String string3 = ((StringTokenizer)object2).nextToken();
                                    n2 = Integer.parseInt(string3);
                                    try {
                                        object = string.substring(string.indexOf(string3));
                                    }
                                    catch (NoSuchElementException noSuchElementException) {
                                        object = null;
                                    }
                                }
                                if (n2 == 401) {
                                    if (!this.securityEnabled) {
                                        throw new TransferFailedException("Received HTTP_UNAUTHORIZED but security is not enabled");
                                    }
                                    if (!this.isRealmOK(httpURLConnection)) {
                                        throw new TransferFailedException("Received HTTP_UNAUTHORIZED but the realm is not correct.");
                                    }
                                    this.setAuthHeader = true;
                                    if (++n <= this.retryLimit) continue;
                                    object2 = "Can not authorize " + uRL.toString() + ".";
                                    Tr.error(tc, "ADFS0112", object2);
                                    throw new TransferFailedException((String)object2);
                                }
                                object2 = null;
                                try {
                                    object2 = httpURLConnection.getHeaderField("file-at-end");
                                    if (object2 == null) {
                                        object2 = Boolean.FALSE.toString();
                                    }
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    object2 = Boolean.FALSE.toString();
                                }
                                long l = 0L;
                                try {
                                    String string4 = httpURLConnection.getHeaderField("file-timestamp");
                                    if (string4 != null) {
                                        l = Long.parseLong(string4);
                                    }
                                }
                                catch (Exception exception) {
                                    l = 0L;
                                }
                                if (resultsObject != null) {
                                    resultsObject.eof = ((String)object2).equals(Boolean.TRUE.toString());
                                    resultsObject.statusCode = n2;
                                    resultsObject.msg = object;
                                    resultsObject.lastModified = l;
                                }
                                if (n2 > 401) {
                                    throw new TransferFailedException("File download failed [" + n2 + "]." + "Message: " + (String)object);
                                }
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                // empty catch block
                            }
                            InputStream inputStream = httpURLConnection.getInputStream();
                            if (inputStream == null) break block32;
                            inputStream = new DataInputStream(inputStream);
                            if (bl) {
                                inputStream = new GZIPInputStream(inputStream, this.defaultBufferSize);
                            }
                            object = inputStream;
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.download", (String)"1330", (Object)this);
                            if (++n > this.retryLimit) {
                                String string5 = "Download retry limit exceeded for retrieving url " + uRL.toString() + ".";
                                Tr.error(tc, "ADFS0112", string5);
                                throw iOException;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Wait " + this.retryWaitTime + " seconds and retry file download for: " + uRL.toString());
                            }
                            try {
                                Thread.sleep(this.retryWaitTime * 1000);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        Object var14_25 = null;
                        if (!tc.isEntryEnabled()) return object;
                        Tr.exit(tc, "download (7)");
                        return object;
                    }
                    int n3 = httpURLConnection.getResponseCode();
                    string = httpURLConnection.getResponseMessage();
                    throw new TransferFailedException("File download failed [" + n3 + "]." + "Message: " + string);
                }
                httpURLConnection = null;
                Object var14_26 = null;
            }
            catch (TransferFailedException transferFailedException) {
                if (!tc.isDebugEnabled()) throw transferFailedException;
                Tr.debug(tc, uRL.toString(), transferFailedException);
                throw transferFailedException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, uRL.toString(), fileNotFoundException);
                }
                Tr.service(tc, "ADFS0125", new Object[]{uRL, fileNotFoundException});
                throw new TransferFailedException("The file to download was not found on the server or the start range is too large =" + uRL, fileNotFoundException);
            }
            if (!tc.isEntryEnabled()) return httpURLConnection;
            Tr.exit(tc, "download (7)");
            return httpURLConnection;
        }
        catch (Throwable throwable) {
            Object var14_27 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "download (7)");
            throw throwable;
        }
    }

    protected void download(URL uRL, File file, boolean bl, long l, long l2) throws TransferFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "download (8) to file. url=" + uRL + ", destFile=" + file.toString() + ", compress=" + bl);
        }
        int n = 0;
        boolean bl2 = false;
        URL uRL2 = uRL;
        String string = file.toString();
        if (string.startsWith("${REPROOT}")) {
            string = string.substring("${REPROOT}".length());
            string = this.getRepositoryTempDir() + string.substring(1);
        } else {
            string = this.mapVariables(string);
        }
        string = string.replace('/', File.separatorChar);
        string = string.replace('\\', File.separatorChar);
        if (!string.equals(file.toString())) {
            file = new File(string);
        }
        long l3 = l;
        while (n <= this.retryLimit) {
            try {
                this.downloadInternal(uRL, file, bl, bl2, l3, l2);
                break;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.download", (String)"1422", (Object)this);
                if (++n > this.retryLimit) {
                    if (file.exists()) {
                        file.delete();
                    }
                    String string2 = "Download retry limit exceeded for file " + file.toString() + ".";
                    Tr.error(tc, "ADFS0112", string2);
                    throw new TransferFailedException("Transfer failed. Retry limit exceeded.", iOException);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Wait " + this.retryWaitTime + " seconds and retry file download for: " + file.toString());
                }
                try {
                    Thread.sleep(this.retryWaitTime * 1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long l4 = 0L;
                if (!file.exists()) continue;
                bl2 = true;
                l4 = file.length();
                l3 = l + l4;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "download (8)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void downloadInternal(URL uRL, File file, boolean bl, boolean bl2, long l, long l2) throws TransferFailedException, IOException {
        InputStream inputStream;
        block16: {
            inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "downloadInternal to file. url=" + uRL + ", destFile=" + file.toString() + ", compress=" + bl);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "destFile = " + file.toString());
                    }
                    long l3 = 0x100000L;
                    long l4 = l;
                    long l5 = 0L;
                    l5 = l2 > l && l2 - l < l3 ? l2 : l4 + l3;
                    long l6 = 0L;
                    boolean bl3 = false;
                    while (!bl3) {
                        URL uRL2 = this.adjustStartEndRange(uRL, l4, l5);
                        ResultsObject resultsObject = new ResultsObject();
                        inputStream = this.download(uRL2, bl, resultsObject);
                        l6 = 0L;
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        fileOutputStream = new FileOutputStream(file.getCanonicalPath(), bl2);
                        byte[] byArray = new byte[this.defaultBufferSize];
                        int n = inputStream.read(byArray);
                        while (n != -1) {
                            l6 += (long)n;
                            fileOutputStream.write(byArray, 0, n);
                            n = inputStream.read(byArray);
                        }
                        inputStream.close();
                        fileOutputStream.flush();
                        fileOutputStream.close();
                        inputStream = null;
                        fileOutputStream = null;
                        if (resultsObject.lastModified != 0L) {
                            file.setLastModified(resultsObject.lastModified);
                        }
                        if (resultsObject.eof || l2 != 0L && l5 == l2) {
                            bl3 = true;
                            continue;
                        }
                        bl2 = true;
                        l4 = l5;
                        if (l2 == 0L || (l5 += l3) <= l2) continue;
                        l5 = l2;
                    }
                    Object var25_19 = null;
                    if (fileOutputStream == null) break block16;
                }
                catch (IOException iOException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, uRL.toString(), iOException);
                    }
                    Tr.service(tc, "ADFS0125", new Object[]{uRL, iOException});
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var25_20 = null;
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "downloadInternal");
                throw throwable;
            }
            fileOutputStream.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "downloadInternal");
    }

    public String getServerStagingLocation() {
        return this.serverStagingLocation;
    }

    public void setServerStagingLocation(String string) {
        this.serverStagingLocation = string;
    }

    public String getTransferHost() {
        return this.transferHost;
    }

    public void setTransferHost(String string) {
        this.transferHost = string;
    }

    public int getTransferPort() {
        return this.transferPort;
    }

    public void setTransferPort(int n) {
        this.transferPort = n;
        if (!this.isSecurityEnabled()) {
            this.portToUse = n;
        }
    }

    public int getTransferSecurePort() {
        return this.transferSecurePort;
    }

    public void setTransferSecurePort(int n) {
        this.transferSecurePort = n;
        if (this.isSecurityEnabled() && n != 0) {
            this.portToUse = this.transferSecurePort;
        }
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    private void setSecurityEnabled(boolean bl) {
        this.securityEnabled = bl;
        if (bl && this.transferSecurePort != 0) {
            try {
                String string;
                String string2;
                String string3;
                Object object;
                if (Security.getProvider("com.ibm.jsse.IBMJSSEProvider") == null) {
                    Security.addProvider((Provider)new IBMJSSEProvider());
                }
                Properties properties = System.getProperties();
                String string4 = System.getProperty("java.protocol.handler.pkgs");
                if (string4 == null) {
                    properties.put("java.protocol.handler.pkgs", "com.ibm.net.ssl.internal.www.protocol");
                } else if (string4.indexOf("com.ibm.net.ssl.internal.www.protocol") == -1) {
                    properties.put("java.protocol.handler.pkgs", "com.ibm.net.ssl.internal.www.protocol|".concat(string4));
                }
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = System.getProperty("com.ibm.CORBA.ConfigURL");
                InputStream inputStream = null;
                try {
                    if (string9 != null) {
                        object = new URL(string9);
                        inputStream = ((URL)object).openStream();
                    } else {
                        object = Thread.currentThread().getContextClassLoader().getResourceAsStream("sas.client.props");
                        inputStream = new DataInputStream((InputStream)object);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configURL is: \"" + string9 + "\"");
                    }
                    if (inputStream != null) {
                        object = new Properties();
                        ((Properties)object).load(inputStream);
                        string5 = ((Properties)object).getProperty("com.ibm.ssl.keyStore");
                        string6 = ((Properties)object).getProperty("com.ibm.ssl.keyStorePassword");
                        string7 = ((Properties)object).getProperty("com.ibm.ssl.trustStore");
                        string8 = ((Properties)object).getProperty("com.ibm.ssl.trustStorePassword");
                        inputStream.close();
                    } else {
                        Tr.service(tc, "ADFS0129", new Object[]{string9, "null"});
                    }
                }
                catch (IOException iOException) {
                    Tr.service(tc, "ADFS0129", new Object[]{string9, iOException});
                }
                object = System.getProperty("javax.net.ssl.keyStore");
                if (object == null) {
                    properties.put("javax.net.ssl.keyStore", string5);
                }
                if ((string3 = System.getProperty("javax.net.ssl.keyStorePassword")) == null) {
                    string3 = this.decriptPassword(string6);
                    properties.put("javax.net.ssl.keyStorePassword", string3);
                }
                if ((string2 = System.getProperty("javax.net.ssl.trustStore")) == null) {
                    properties.put("javax.net.ssl.trustStore", string7);
                }
                if ((string = System.getProperty("javax.net.ssl.trustStorePassword")) == null) {
                    string = this.decriptPassword(string8);
                    properties.put("javax.net.ssl.trustStorePassword", string);
                }
                System.setProperties(properties);
                this.protocolToUse = "https";
                this.portToUse = this.transferSecurePort;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.download", (String)"1757", (Object)this);
                Tr.service(tc, "ADFS0128", exception);
            }
        } else {
            this.protocolToUse = "http";
            this.portToUse = this.transferPort;
        }
    }

    private String decriptPassword(String string) {
        String string2 = null;
        try {
            string2 = PasswordUtil.decode((String)string);
        }
        catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
            string2 = string;
        }
        catch (Exception exception) {
            string2 = string;
            Tr.service(tc, "ADFS0130", new Object[]{string});
        }
        return string2;
    }

    public void initialize(FileTransferConfig fileTransferConfig) {
        block10: {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            if (fileTransferConfig.getTransferRequestTimeout() != null && fileTransferConfig.getTransferRetryCount() != null) {
                this.retryWaitTime = fileTransferConfig.getTransferRequestTimeout();
                this.retryLimit = fileTransferConfig.getTransferRetryCount();
            }
            if (fileTransferConfig.getVariableMap() != null) {
                this.vmap = (VariableMap)fileTransferConfig.getVariableMap();
            }
            String string = null;
            String string2 = null;
            String string3 = null;
            if (fileTransferConfig != null && fileTransferConfig.getProperties() != null) {
                object = fileTransferConfig.getProperties();
                string = ((Properties)object).getProperty("jmx.conn.type");
                string2 = ((Properties)object).getProperty("cellmgr.host");
                string3 = ((Properties)object).getProperty("jmx.port");
            }
            if (string != null && string2 != null && string3 != null) {
                this.jmxConnProps = new Properties();
                this.jmxConnProps.setProperty("type", string);
                this.jmxConnProps.setProperty("host", string2);
                this.jmxConnProps.setProperty("port", string3);
                this.sendGetServerConfigRequest();
            } else if (this.jmxConnProps == null) {
                try {
                    object = AdminServiceFactory.getAdminService();
                    String string4 = "WebSphere:type=Discovery,process=" + object.getProcessName() + ",*";
                    ObjectName objectName = new ObjectName(string4);
                    Set set = object.queryNames(objectName, null);
                    Iterator iterator = set.iterator();
                    objectName = (ObjectName)iterator.next();
                    object.addNotificationListener(objectName, this, null, null);
                }
                catch (JMException jMException) {
                    FFDCFilter.processException((Throwable)jMException, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.initialize", (String)"1851", (Object)this);
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "can not register as a listener to DiscoveryMBean", jMException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this.jmxConnProps);
        }
    }

    public void initialize(AdminClient adminClient) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(AdminClient)");
        }
        this.adminClient = adminClient;
        this.sendGetServerConfigRequest();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(AdminClient)");
        }
    }

    public void setVariableMap(Object object) {
        if (object instanceof VariableMap) {
            this.vmap = (VariableMap)object;
        }
    }

    public Object getVariableMap() {
        return this.vmap;
    }

    private String mapVariables(String string) {
        if (this.vmap != null && string != null) {
            string = this.vmap.expand(string);
        }
        return string;
    }

    private File mapVariables(File file) {
        String string;
        String string2;
        if (this.vmap != null && file != null && (string2 = file.toString()) != (string = this.mapVariables(string2))) {
            file = new File(string);
        }
        return file;
    }

    public void handleNotification(Notification notification, Object object) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        if ((string = notification.getType()).equals("websphere.discovery.agent.found")) {
            ServerInfo serverInfo = (ServerInfo)notification.getUserData();
            this.dmgrAdded(serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public void dmgrAdded(ServerInfo serverInfo) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "dmgrAdded");
            }
            try {
                this.adminClient = serverInfo.getAdminClient();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.dmgrAdded", (String)"1951", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "unable to obtain the admin client to netmgr", exception);
            }
        }
        this.sendGetServerConfigRequest();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dmgrAdded");
        }
    }

    private void sendGetServerConfigRequest() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendGetServerConfigRequest");
        }
        boolean bl = false;
        try {
            final AdminClient adminClient = this.getAdminClient();
            final ObjectName objectName = this.getFTServerObjectName();
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return adminClient.invoke(objectName, "getServerConfig", null, null);
                }
            };
            FileTransferConfig fileTransferConfig = (FileTransferConfig)ContextManagerFactory.getInstance().runAsSystem(privilegedExceptionAction);
            if (fileTransferConfig != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "FileTransferConfig from CellMgr: " + fileTransferConfig.toString());
                }
                this.setFileTransferConfig(fileTransferConfig);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not retrieve file transfer server config.");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.sendGetServerConfigRequest", (String)"1995", (Object)this);
            Tr.service(tc, "ADFS0109", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendGetServerConfigRequest", new Boolean(bl));
        }
    }

    public FileTransferConfig getFileTransferConfig() {
        return this.ftConfig;
    }

    public void setFileTransferConfig(FileTransferConfig fileTransferConfig) {
        this.ftConfig = fileTransferConfig;
        this.setTransferHost((String)fileTransferConfig.getProperties().get("host"));
        if (fileTransferConfig.getProperties().get("port") != null) {
            this.setTransferPort(Integer.parseInt((String)fileTransferConfig.getProperties().get("port")));
        } else {
            this.setTransferPort(9090);
        }
        if (fileTransferConfig.getProperties().get("secure_port") != null) {
            this.setTransferSecurePort(Integer.parseInt((String)fileTransferConfig.getProperties().get("secure_port")));
        }
        this.setSecurityEnabled(fileTransferConfig.isSecurityEnabled());
        this.setServerStagingLocation(fileTransferConfig.getStagingLocation());
        if (fileTransferConfig.getTransferRequestTimeout() != null && fileTransferConfig.getTransferRetryCount() != null && this.retryWaitTime == FileTransferConfigImpl.DEFAULT_TIMEOUT && this.retryLimit == FileTransferConfigImpl.DEFAULT_RETRIES) {
            this.retryWaitTime = fileTransferConfig.getTransferRequestTimeout();
            this.retryLimit = fileTransferConfig.getTransferRetryCount();
        }
        if (fileTransferConfig.getVariableMap() != null) {
            this.vmap = (VariableMap)fileTransferConfig.getVariableMap();
        }
        Tr.service(tc, "ADFS0134", new Object[]{this.getTransferHost(), Integer.toString(this.portToUse), this.securityEnabled ? "true" : "false"});
    }

    private AdminClient getAdminClient() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient");
        }
        if (this.adminClient == null) {
            try {
                this.adminClient = AdminClientFactory.createAdminClient(this.jmxConnProps);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.getAdminClient", (String)"2072", (Object)this);
                Tr.service(tc, "ADFS0113", exception);
                throw new AdminException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return this.adminClient;
    }

    private ObjectName getFTServerObjectName() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFTServerObjectName");
        }
        if (this.ftServerObjName == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.management.util.Utils");
                AdminClient adminClient = this.getAdminClient();
                Class<?> clazz2 = adminClient.getClass();
                Method method = clazz.getMethod("getNetmgrName", class$com$ibm$websphere$management$AdminClient == null ? (class$com$ibm$websphere$management$AdminClient = FileTransferClientImpl.class$("com.ibm.websphere.management.AdminClient")) : class$com$ibm$websphere$management$AdminClient);
                String string = (String)method.invoke(clazz, adminClient);
                ObjectName objectName = new ObjectName("WebSphere:*,type=FileTransferServer,process=" + string);
                Set set = adminClient.queryNames(objectName, null);
                if (set != null && set.size() != 0) {
                    if (set.size() != 1 && tc.isDebugEnabled()) {
                        Tr.debug(tc, "There are " + set.size() + " FileTransferServer objects.");
                    }
                    Object[] objectArray = set.toArray();
                    this.ftServerObjName = (ObjectName)objectArray[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ftServer name is " + this.ftServerObjName.getCanonicalName());
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.getFTServerObjectName", (String)"2110", (Object)this);
                Tr.service(tc, "ADFS0111", exception);
                throw new AdminException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFTServerObjectName");
        }
        return this.ftServerObjName;
    }

    private String getRepositoryTempDir() {
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        Properties properties = configRepository.getConfig();
        return properties.getProperty("was.repository.temp");
    }

    private URL adjustStartEndRange(URL uRL, long l, long l2) {
        String string = uRL.getFile();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&?", true);
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.startsWith("rangeStart")) {
                stringBuffer.append("rangeStart");
                stringBuffer.append("=");
                stringBuffer.append(new Long(l).toString());
                bl = true;
                continue;
            }
            if (l2 > 0L && string2.startsWith("rangeEnd")) {
                stringBuffer.append("rangeEnd");
                stringBuffer.append("=");
                stringBuffer.append(new Long(l2).toString());
                bl2 = true;
                continue;
            }
            stringBuffer.append(string2);
        }
        if (!bl && l > 0L) {
            stringBuffer.append("&");
            stringBuffer.append("rangeStart");
            stringBuffer.append("=");
            stringBuffer.append(new Long(l).toString());
        }
        if (!bl2 && l2 > 0L) {
            stringBuffer.append("&");
            stringBuffer.append("rangeEnd");
            stringBuffer.append("=");
            stringBuffer.append(new Long(l2).toString());
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL2;
    }

    private void connectToServer(HttpURLConnection httpURLConnection) throws IOException {
        httpURLConnection.connect();
        if (this.protocolToUse.equals("https")) {
            try {
                ((HttpsURLConnection)httpURLConnection).getCipherSuite();
            }
            catch (IllegalStateException illegalStateException) {
                httpURLConnection.connect();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private String encode(String string) {
        String string2 = FileTransferUtils.urlEncodePlus(string);
        try {
            string2 = URLEncoder.encode(string2, UTF_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.encode", (String)"2234", (Object)this);
            Tr.service(tc, "ADFS0119", unsupportedEncodingException);
        }
        return string2;
    }

    private boolean isRealmOK(HttpURLConnection httpURLConnection) throws TransferFailedException {
        return true;
    }

    private void addAuthHeader(HttpURLConnection httpURLConnection) throws TransferFailedException {
        if (this.securityEnabled) {
            if (SecurityContext.isServerProcess()) {
                try {
                    Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                    Cookie cookie = this.createCookie(subject);
                    httpURLConnection.setRequestProperty("Cookie", cookie.getName() + "=" + cookie.getValue());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.addAuthHeader", (String)"2278", (Object)this);
                    throw new TransferFailedException("An error occurred trying to create the FileTransfer cookie.", exception);
                }
            }
            try {
                Subject subject = this.getSubject();
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                String string = wSCredential.getSecurityName();
                byte[] byArray = wSCredential.getCredentialToken();
                String string2 = StringBytesConversion.getConvertedString((byte[])byArray);
                String string3 = Base64Coder.base64Encode((String)(string + ":" + string2));
                httpURLConnection.setRequestProperty("Authorization", "Basic " + string3);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.addAuthHeader", (String)"2295", (Object)this);
                throw new TransferFailedException("There is a problem with the client credential.", exception);
            }
        }
    }

    private Cookie createCookie(Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCookie");
        }
        String string = null;
        Cookie cookie = null;
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
        try {
            Boolean bl;
            Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
            Method method = clazz.getMethod("getConfig", null);
            Method method2 = clazz.getMethod("getValue", class$java$lang$String == null ? (class$java$lang$String = FileTransferClientImpl.class$("java.lang.String")) : class$java$lang$String);
            Object object = method.invoke(null, new Object[0]);
            String string2 = "security.ltpa.sso.domain";
            string = (String)method2.invoke(object, string2);
            if (string == null) {
                string = "";
            }
            if (string != null && string.length() > 0 && (string = string.trim()).charAt(0) != '.') {
                string = "." + string;
            }
            string2 = "security.ltpa.sso.ssl";
            Boolean bl2 = (Boolean)method2.invoke(object, string2);
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl2 != null) {
                bl4 = bl2;
            }
            if ((bl = (Boolean)method2.invoke(object, string2 = "security.ltpa.setSSODomain")) != null) {
                bl3 = bl;
            }
            if (string.length() < 1) {
                bl3 = false;
            }
            String string3 = "LtpaToken";
            String string4 = "/";
            String string5 = StringUtil.toString((byte[])wSCredential.getCredentialToken());
            String string6 = Base64Coder.base64Encode((String)string5);
            cookie = new Cookie(string3, string6);
            if (bl3) {
                cookie.setDomain(string);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No domain set for " + string3 + " cookie");
            }
            cookie.setPath(string4);
            cookie.setMaxAge(-1);
            cookie.setSecure(bl4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie", (String)"2366", (Object)this);
            classNotFoundException.printStackTrace();
            throw classNotFoundException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie", (String)"2370", (Object)this);
            throw noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie", (String)"2373", (Object)this);
            throw illegalAccessException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie", (String)"2376", (Object)this);
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCookie");
        }
        return cookie;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Subject getSubject() throws TransferFailedException, WSSecurityException {
        Object object = AdminDataHolder.getData("wsSubject");
        Subject subject = null;
        if (object instanceof Subject) {
            subject = (Subject)object;
        }
        if (subject != null) return subject;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The subject is not set up in AdminDataHolder");
        }
        if (SecurityContext.isServerProcess()) throw new TransferFailedException("There is no Subject available from AdminDataHolder");
        subject = ContextManagerFactory.getInstance().getInvocationSubject();
        if (subject == null) throw new TransferFailedException("There is no Subject available from AdminDataHolder");
        AdminDataHolder.setData("wsSubject", subject);
        return subject;
    }

    private void checkAccessPermission(String string) throws TransferFailedException {
        boolean bl;
        if (this.securityEnabled && SecurityContext.isServerProcess() && (bl = RestrictedAccess.isRestricted((String)string))) {
            RoleBasedAuthorizer roleBasedAuthorizer;
            try {
                roleBasedAuthorizer = this.getAuthorizer();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.fileTransfer.FileTransferClientImpl.checkAccessPermission", (String)"2401", (Object)this);
                throw new TransferFailedException("Unable to get caller's security role", throwable);
            }
            if (!roleBasedAuthorizer.isCallerInRole("administrator")) {
                throw new TransferFailedException("Caller is not in the required role to access restricted document: " + string);
            }
        }
    }

    private RoleBasedAuthorizer getAuthorizer() throws TransferFailedException {
        if (this.roleBasedAuth == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.management.util.SecurityHelper");
                Method method = clazz.getMethod("getHelper", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Method method2 = clazz.getMethod("getConfigurator", new Class[0]);
                Object object2 = method2.invoke(object, new Object[0]);
                this.roleBasedAuth = ((RoleBasedConfigurator)object2).getRoleBasedAuthorizer("admin-authz", "scope");
            }
            catch (Exception exception) {
                throw new TransferFailedException("The security Authorizer can not be resolved.", exception);
            }
        }
        return this.roleBasedAuth;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ResultsObject {
        boolean eof = false;
        int statusCode = 0;
        String msg = null;
        long lastModified = 0L;

        ResultsObject() {
        }
    }
}

