/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.poa;

import java.util.ArrayList;
import java.util.List;

public class RequestTracker {
    private List activeIds = new ArrayList();
    private List deactivatedIds = new ArrayList();

    protected synchronized void beginRequest(byte[] byArray) {
        this.waitForDeactivation(byArray);
        this.activeIds.add(new Id(byArray));
    }

    protected synchronized void waitForDeactivation(byte[] byArray) {
        if (this.deactivatedIds.isEmpty()) {
            return;
        }
        while (this.deactivatedIds.contains(new Id(byArray))) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void endRequest(byte[] byArray) {
        this.activeIds.remove(new Id(byArray));
        if (!this.deactivatedIds.isEmpty()) {
            this.notifyAll();
        }
    }

    protected synchronized void waitForRequests(byte[] byArray) {
        while (this.activeIds.contains(new Id(byArray))) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized boolean hasRequests(byte[] byArray) {
        return this.activeIds.contains(new Id(byArray));
    }

    protected synchronized void beginDeactivation(byte[] byArray) {
        this.deactivatedIds.add(new Id(byArray));
    }

    protected synchronized boolean inDeactivation(byte[] byArray) {
        return this.deactivatedIds.contains(new Id(byArray));
    }

    protected synchronized void endDeactivation(byte[] byArray) {
        this.deactivatedIds.remove(new Id(byArray));
        this.notifyAll();
    }

    class Id {
        byte[] id;

        Id(byte[] byArray) {
            this.id = byArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.id.length; ++i) {
                stringBuffer.append(Integer.toString(this.id[i], 16));
                if (i == this.id.length - 1) continue;
                stringBuffer.append(":");
            }
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Id) {
                Id id = (Id)object;
                if (id.id.length != this.id.length) {
                    return false;
                }
                int n = this.id.length;
                for (int i = 0; i < n; ++i) {
                    if (this.id[i] == id.id[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.id.length; ++i) {
                n = 31 * n + this.id[i];
            }
            return n;
        }
    }
}

