/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.CBuff;
import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceEventListener;
import com.ibm.ejs.ras.TraceLogger;
import java.io.FileOutputStream;
import java.util.Enumeration;

class CBuffLogger
implements TraceEventListener {
    private CBuff ivCBuff;

    CBuffLogger(int n) {
        if (n < 1) {
            n = 8;
        }
        int n2 = n * 1024;
        this.ivCBuff = new CBuff(n2);
    }

    synchronized void setSize(int n) {
        if (n < 1) {
            return;
        }
        int n2 = n * 1024;
        this.ivCBuff.setSize(n2);
    }

    synchronized int getSize() {
        int n = this.ivCBuff.getSize() / 1024;
        return n;
    }

    synchronized void clear() {
        int n = this.ivCBuff.getSize();
        this.ivCBuff = new CBuff(n);
    }

    public synchronized void auditEvent(MessageEvent messageEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(messageEvent);
        }
    }

    public synchronized void debugEvent(TraceEvent traceEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(traceEvent);
        }
    }

    public synchronized void dumpEvent(TraceEvent traceEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(traceEvent);
        }
    }

    public synchronized void errorEvent(MessageEvent messageEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(messageEvent);
        }
    }

    public synchronized void eventEvent(TraceEvent traceEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(traceEvent);
        }
    }

    public synchronized void entryEvent(TraceEvent traceEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(traceEvent);
        }
    }

    public synchronized void exitEvent(TraceEvent traceEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(traceEvent);
        }
    }

    public synchronized void fatalEvent(MessageEvent messageEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(messageEvent);
        }
    }

    public synchronized void infoEvent(MessageEvent messageEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(messageEvent);
        }
    }

    public synchronized void serviceEvent(MessageEvent messageEvent) {
    }

    public synchronized void systemErrEvent(StreamEvent streamEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(streamEvent);
        }
    }

    public synchronized void systemOutEvent(StreamEvent streamEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(streamEvent);
        }
    }

    public synchronized void uncondTraceEvent(TraceEvent traceEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(traceEvent);
        }
    }

    public synchronized void warningEvent(MessageEvent messageEvent) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(messageEvent);
        }
    }

    synchronized void dump(String string) throws RasException {
        FileOutputStream fileOutputStream = null;
        try {
            RasHelper.validateFileName(string.trim());
            fileOutputStream = RasHelper.createFileOutputStream(string, false);
            TraceLogger traceLogger = null;
            traceLogger = RasProperties.svTraceFormat.equals("loganalyzer") ? new ExtendedTraceLogger(fileOutputStream) : (RasProperties.svTraceFormat.equals("advanced") ? new TraceLogger(fileOutputStream, false) : new TraceLogger(fileOutputStream, true));
            traceLogger.printHeader();
            Enumeration enumeration = this.ivCBuff.elements();
            while (enumeration.hasMoreElements()) {
                RasEvent rasEvent;
                RasEvent rasEvent2 = (RasEvent)enumeration.nextElement();
                if (rasEvent2 instanceof MessageEvent) {
                    rasEvent = (MessageEvent)rasEvent2;
                    traceLogger.logMessage((MessageEvent)rasEvent);
                    continue;
                }
                rasEvent = (TraceEvent)rasEvent2;
                traceLogger.logTrace((TraceEvent)rasEvent);
            }
        }
        catch (RasException rasException) {
            throw new RasException("Failed to open file " + string, rasException);
        }
        catch (Throwable throwable) {
            throw new RasException("Failure dumping the ring buffer " + string, throwable);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

