/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Group;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceElement;
import com.ibm.ejs.ras.TraceEnableEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ComponentManager {
    static boolean svTraceEnabled = false;
    private static Hashtable traceTypeMap = new Hashtable();
    private Hashtable components = new Hashtable();
    private Hashtable groups = new Hashtable();
    private Hashtable dumpables;
    private Vector traceEnableEvents = new Vector();
    private int eventsThatEnableTrace = 0;

    ComponentManager() {
        this.dumpables = new Hashtable();
    }

    synchronized String[] getGroups() {
        String[] stringArray = null;
        stringArray = new String[this.groups.size()];
        Enumeration enumeration = this.groups.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    synchronized String[] getGroupComponents(String string) {
        Group group;
        String[] stringArray = new String[]{};
        if (string != null && (group = (Group)this.groups.get(string)) != null) {
            stringArray = group.getComponents();
        }
        return stringArray;
    }

    synchronized String getTraceSpecification(String string) {
        String string2 = null;
        if (string != null) {
            TraceElement traceElement = (TraceElement)this.groups.get(string);
            if (traceElement == null) {
                traceElement = (TraceElement)this.components.get(string);
            }
            if (traceElement != null) {
                string2 = traceElement.getTraceSpecification();
            }
        }
        return string2;
    }

    synchronized String getTraceSpecification() {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = this.traceEnableEvents.size();
        if (n == 0) {
            return "*=all=disabled";
        }
        for (int i = 0; i < n; ++i) {
            TraceEnableEvent traceEnableEvent = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (i != 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(traceEnableEvent.getComponentName());
            switch (traceEnableEvent.getType()) {
                case 0: {
                    stringBuffer.append("=all=");
                    break;
                }
                case 1: {
                    stringBuffer.append("=debug=");
                    break;
                }
                case 2: {
                    stringBuffer.append("=entryExit=");
                    break;
                }
                case 3: {
                    stringBuffer.append("=event=");
                    break;
                }
                case 4: {
                    stringBuffer.append("=dump=");
                }
            }
            if (traceEnableEvent.enabled()) {
                stringBuffer.append("enabled");
                continue;
            }
            stringBuffer.append("disabled");
        }
        return new String(stringBuffer);
    }

    synchronized void processTraceString(String string, boolean bl) {
        if (bl) {
            this.fireTraceEnableEvent(new TraceEnableEvent(false, 0, "*"));
        }
        if ((string = RasHelper.peelQuotes(string)) == null) {
            return;
        }
        String[] stringArray = RasHelper.split(string, 58);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            int n = stringArray[i].indexOf(61);
            if (n == -1) {
                return;
            }
            String string2 = stringArray[i].substring(0, n);
            if ((stringArray2 = RasHelper.split(stringArray[i].substring(++n), 44)).length == 0) {
                return;
            }
            for (int j = 0; j < stringArray2.length; ++j) {
                String[] stringArray3 = RasHelper.split(stringArray2[j], 61);
                if (stringArray3.length != 2 || stringArray3[0] == null) {
                    return;
                }
                Integer n2 = (Integer)traceTypeMap.get(stringArray3[0]);
                if (n2 == null) {
                    return;
                }
                try {
                    TraceEnableEvent traceEnableEvent = new TraceEnableEvent(stringArray3[1], (int)n2, string2);
                    this.fireTraceEnableEvent(traceEnableEvent);
                    continue;
                }
                catch (RasException rasException) {
                    return;
                }
            }
        }
    }

    synchronized void processDumpString(String string) {
        Object object;
        Object object2;
        int n;
        if (string == null) {
            this.processNullDumpString();
            return;
        }
        if ((string = RasHelper.peelQuotes(string)) == null) {
            return;
        }
        String[] stringArray = RasHelper.split(string, 58);
        Object var3_3 = null;
        Vector<TraceComponent> vector = new Vector<TraceComponent>();
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            TraceComponent traceComponent = (TraceComponent)enumeration.nextElement();
            if (!traceComponent.ivDebugEnabled) continue;
            traceComponent.ivDebugEnabled = false;
            vector.addElement(traceComponent);
        }
        for (n = 0; n < stringArray.length; ++n) {
            boolean bl = true;
            object2 = stringArray[n];
            if (((String)object2).endsWith("=disabled")) {
                bl = false;
                object2 = RasHelper.split((String)object2, 61)[0];
            }
            object = new TraceEnableEvent(bl, 4, (String)object2);
            this.fireTraceEnableEvent((TraceEnableEvent)object);
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = RasHelper.split(stringArray[n], 61)[0];
            object2 = this.dumpables.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (!this.componentEnabled(string2, (String)object)) continue;
                Vector vector2 = (Vector)this.dumpables.get(object);
                for (int i = 0; i < vector2.size(); ++i) {
                    Dumpable dumpable = (Dumpable)vector2.elementAt(i);
                    dumpable.dump();
                }
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string3 = RasHelper.split(stringArray[n], 61)[0];
            object2 = new TraceEnableEvent(false, 4, string3);
            this.fireTraceEnableEvent((TraceEnableEvent)object2);
        }
        for (n = 0; n < vector.size(); ++n) {
            TraceComponent traceComponent = (TraceComponent)vector.elementAt(n);
            traceComponent.ivDebugEnabled = true;
        }
        Enumeration enumeration2 = this.dumpables.elements();
        while (enumeration2.hasMoreElements()) {
            Vector vector3 = (Vector)enumeration2.nextElement();
            for (int i = 0; i < vector3.size(); ++i) {
                object = (Dumpable)vector3.elementAt(i);
                object.resetDump();
            }
        }
    }

    synchronized TraceComponent register(String string) {
        TraceComponent traceComponent = (TraceComponent)this.components.get(string);
        if (traceComponent != null) {
            return traceComponent;
        }
        traceComponent = new TraceComponent(string);
        this.components.put(string, traceComponent);
        int n = this.traceEnableEvents.size();
        for (int i = 0; i < n; ++i) {
            TraceEnableEvent traceEnableEvent = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (!this.componentEnabled(traceEnableEvent.getComponentName(), traceComponent.getName())) continue;
            traceComponent.applyTraceEnableEvent(traceEnableEvent);
        }
        return traceComponent;
    }

    synchronized TraceComponent register(String string, String string2) {
        TraceComponent traceComponent = this.register(string);
        Group group = (Group)this.groups.get(string2);
        if (group == null) {
            group = new Group(string2);
            this.groups.put(string2, group);
        }
        group.addComponent(traceComponent);
        int n = this.traceEnableEvents.size();
        for (int i = 0; i < n; ++i) {
            TraceEnableEvent traceEnableEvent = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (!this.componentEnabled(traceEnableEvent.getComponentName(), group.getName())) continue;
            group.applyTraceEnableEvent(traceEnableEvent);
        }
        return traceComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void registerDumpable(TraceComponent traceComponent, Dumpable dumpable) {
        String string = traceComponent.getName();
        Hashtable hashtable = this.dumpables;
        synchronized (hashtable) {
            Vector<Dumpable> vector = (Vector<Dumpable>)this.dumpables.get(string);
            if (vector == null) {
                vector = new Vector<Dumpable>();
                this.dumpables.put(string, vector);
            }
            if (!vector.contains(dumpable)) {
                vector.addElement(dumpable);
            }
        }
    }

    synchronized String[] getComponents() {
        String[] stringArray = new String[this.components.size()];
        Enumeration enumeration = this.components.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    synchronized Vector getTracedGroups() {
        Vector<Group> vector = new Vector<Group>();
        Enumeration enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)this.groups.get(enumeration.nextElement());
            if (!group.isDebugEnabled() && !group.isEventEnabled() && !group.isEntryEnabled()) continue;
            vector.addElement(group);
        }
        return vector;
    }

    synchronized Vector getTracedComponents() {
        Vector<TraceComponent> vector = new Vector<TraceComponent>();
        Enumeration enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            TraceComponent traceComponent = (TraceComponent)this.components.get(enumeration.nextElement());
            if (!traceComponent.isDebugEnabled() && !traceComponent.isEventEnabled() && !traceComponent.isEntryEnabled()) continue;
            vector.addElement(traceComponent);
        }
        return vector;
    }

    private void fireTraceEnableEvent(TraceEnableEvent traceEnableEvent) {
        Object object;
        if (!traceEnableEvent.enabled() && this.eventsThatEnableTrace == 0) {
            return;
        }
        String string = traceEnableEvent.getComponentName();
        Enumeration enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            object = (Group)this.groups.get(enumeration.nextElement());
            if (!this.componentEnabled(string, ((TraceElement)object).getName())) continue;
            ((Group)object).applyTraceEnableEvent(traceEnableEvent);
        }
        object = this.components.keys();
        while (object.hasMoreElements()) {
            TraceComponent traceComponent = (TraceComponent)this.components.get(object.nextElement());
            if (!this.componentEnabled(string, traceComponent.getName())) continue;
            traceComponent.applyTraceEnableEvent(traceEnableEvent);
        }
        if (traceEnableEvent.enabled()) {
            ++this.eventsThatEnableTrace;
        }
        int n = this.traceEnableEvents.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            boolean bl = false;
            TraceEnableEvent traceEnableEvent2 = (TraceEnableEvent)this.traceEnableEvents.elementAt(n2);
            if (this.componentEnabled(string, traceEnableEvent2.getComponentName()) && ((n3 = traceEnableEvent.getType()) == 0 || n3 == traceEnableEvent2.getType())) {
                if (traceEnableEvent2.enabled()) {
                    --this.eventsThatEnableTrace;
                }
                bl = true;
            }
            if (bl) {
                this.traceEnableEvents.removeElementAt(n2);
                continue;
            }
            ++n2;
        }
        if (this.eventsThatEnableTrace > 0) {
            this.traceEnableEvents.addElement(traceEnableEvent);
            svTraceEnabled = true;
        } else {
            if (this.traceEnableEvents.size() > 0) {
                this.traceEnableEvents.removeAllElements();
            }
            svTraceEnabled = false;
        }
    }

    private boolean componentEnabled(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        int n = string.length();
        if (string.lastIndexOf(42) == n - 1) {
            return string.regionMatches(0, string2, 0, n - 1);
        }
        return false;
    }

    private void processNullDumpString() {
        Dumpable dumpable;
        int n;
        Vector vector;
        Enumeration enumeration = this.dumpables.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            for (n = 0; n < vector.size(); ++n) {
                dumpable = (Dumpable)vector.elementAt(n);
                dumpable.dump();
            }
        }
        enumeration = this.dumpables.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            for (n = 0; n < vector.size(); ++n) {
                dumpable = (Dumpable)vector.elementAt(n);
                dumpable.resetDump();
            }
        }
    }

    static {
        traceTypeMap.put("all", new Integer(0));
        traceTypeMap.put("debug", new Integer(1));
        traceTypeMap.put("entryExit", new Integer(2));
        traceTypeMap.put("event", new Integer(3));
        traceTypeMap.put("dump", new Integer(4));
    }
}

