/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.TraceNLS;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

class ExtendedTraceLogger
extends TraceLogger {
    private static final String svSpace = " ";
    private static final String svEquals = "=";
    private static final String svEqualsQuote = "=\"";
    private static final String svQuote = "\"";
    private static final String svQuoteSpace = "\" ";
    private static final String svXmlStart = "<";
    private static final String svXmlEnd = "/>";
    private static final String emptyString = "";
    private static final String svBundle = "com.ibm.ejs.resources.RasMessages";
    private String manufacturerLabel;
    private String productLabel;
    private String versionLabel;
    private String compIDLabel;
    private String processIDLabel;
    private String threadIDLabel;
    private String sourceIDLabel;
    private String classNameLabel;
    private String methodNameLabel;
    private String serverNameLabel;
    private String timeStampLabel;
    private String uowLabel;
    private String severityLabel;
    private String categoryLabel;
    private String primMessageLabel;
    private String extMessageLabel;
    private NumberFormat numberFormat;
    private int paddingCounter = 0;
    private long previousTimestamp = -1L;
    private String ivLineSep;
    private StringBuffer ivTimeBuffer = new StringBuffer();
    private StringBuffer ivNormalizeBuffer = new StringBuffer();
    ByteArrayOutputStream ivBaos = null;
    PrintStream ivPs = null;
    private boolean ivOutputXML = false;
    private Locale ivLocale;

    ExtendedTraceLogger(OutputStream outputStream) {
        this(outputStream, false, Locale.getDefault());
    }

    ExtendedTraceLogger(OutputStream outputStream, boolean bl, Locale locale) {
        super(outputStream);
        this.ivOutputXML = bl;
        this.ivLocale = locale;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMaximumIntegerDigits(6);
        this.numberFormat.setMinimumIntegerDigits(6);
        this.ivFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.ivBaos = new ByteArrayOutputStream();
        this.ivPs = new PrintStream(this.ivBaos);
        this.ivLineSep = RasHelper.getSystemProperty("line.separator");
        if (this.ivOutputXML) {
            this.manufacturerLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_MANUFAC", this.ivLocale, "Manufacturer");
            this.productLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRODUCT", this.ivLocale, "Product");
            this.versionLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_VERSION", this.ivLocale, "Version");
            this.compIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_COMPID", this.ivLocale, "ComponentId");
            this.processIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PROCESSID", this.ivLocale, "ProcessId");
            this.threadIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADID", this.ivLocale, "ThreadId");
            this.sourceIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SOURCEID", this.ivLocale, "SourceId");
            this.classNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CLASSNAME", this.ivLocale, "ClassName");
            this.methodNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_METHODNAME", this.ivLocale, "MethodName");
            this.serverNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SERVNAME", this.ivLocale, "ServerName");
            this.timeStampLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_TIMESTMP", this.ivLocale, "TimeStamp");
            this.uowLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_UOW", this.ivLocale, "UnitOfWork");
            this.severityLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SEVERITY", this.ivLocale, "Severity");
            this.categoryLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CATEGORY", this.ivLocale, "Category");
            this.primMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRIMMSG", this.ivLocale, "PrimaryMessage");
            this.extMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_EXTMSG", this.ivLocale, "ExtendedMessage");
        } else {
            this.manufacturerLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_MANUFAC", this.ivLocale, "Manufacturer") + ":\t ";
            this.productLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRODUCT", this.ivLocale, "Product") + ":\t ";
            this.versionLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_VERSION", this.ivLocale, "Version") + ":\t ";
            this.compIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_COMPID", this.ivLocale, "ComponentId") + ":\t ";
            this.processIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PROCESSID", this.ivLocale, "ProcessId") + ":\t ";
            this.threadIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADID", this.ivLocale, "ThreadId") + ":\t ";
            this.sourceIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SOURCEID", this.ivLocale, "SourceId") + ":\t ";
            this.classNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CLASSNAME", this.ivLocale, "ClassName") + ":\t ";
            this.methodNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_METHODNAME", this.ivLocale, "MethodName") + ":\t ";
            this.serverNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SERVNAME", this.ivLocale, "ServerName") + ":\t ";
            this.timeStampLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_TIMESTMP", this.ivLocale, "TimeStamp") + ":\t ";
            this.uowLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_UOW", this.ivLocale, "UnitOfWork") + ":\t ";
            this.severityLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SEVERITY", this.ivLocale, "Severity") + ":\t ";
            this.categoryLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CATEGORY", this.ivLocale, "Category") + ":\t ";
            this.primMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRIMMSG", this.ivLocale, "PrimaryMessage") + ":\t ";
            this.extMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_EXTMSG", this.ivLocale, "ExtendedMessage") + ": ";
        }
    }

    void printHeader() {
        String string = this.ivLocale.getLanguage();
        String string2 = this.ivLocale.getCountry();
        String string3 = RasHelper.getSystemProperty("file.encoding");
        if (this.ivOutputXML) {
            this.ivOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.ivOut.println("<WASActivityLogFile>");
            this.ivOut.println("<encoding language=\"" + string + "_" + string2 + svQuoteSpace + "codeset=\"" + string3 + svQuote + svXmlEnd);
        } else {
            this.ivOut.println("$LANG = " + string + "_" + string2);
            this.ivOut.println("$CODESET = " + string3);
        }
    }

    void printFooter(int n) {
        String string = Integer.toString(n);
        if (this.ivOutputXML) {
            this.ivOut.println("<total records=\"" + string + svQuote + svXmlEnd);
            this.ivOut.println("</WASActivityLogFile>");
        } else {
            this.ivOut.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG006", this.ivLocale, new Object[]{string}, "{0} records found and printed."));
        }
    }

    synchronized void logMessage(MessageEvent messageEvent) {
        if (messageEvent == null) {
            return;
        }
        this.ivBaos.reset();
        String string = messageEvent.getLocalizedMessage(this.ivLocale);
        if (this.ivOutputXML) {
            this.ivPs.println(this.formatMessageInXML(string, messageEvent));
        } else {
            this.ivPs.println(this.formatEntryHeader(messageEvent));
            this.ivPs.println(this.primMessageLabel + string);
            this.ivPs.println(this.formatEntryTrailer(messageEvent));
        }
        this.ivPs.flush();
        try {
            this.ivOs.write(this.ivBaos.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void logTrace(TraceEvent traceEvent) {
        if (traceEvent == null) {
            return;
        }
        String[] stringArray = traceEvent.getStrs();
        String string = stringArray[0];
        int n = stringArray.length - 1;
        for (int i = 0; i < n; ++i) {
            string = string.concat(svSpace).concat(stringArray[i]);
        }
        this.ivBaos.reset();
        if (this.ivOutputXML) {
            this.ivPs.println(this.formatMessageInXML(string, traceEvent));
        } else {
            this.ivPs.println(this.formatEntryHeader(traceEvent));
            this.ivPs.println(this.primMessageLabel + string);
            this.ivPs.println(this.formatEntryTrailer(traceEvent));
        }
        this.ivPs.flush();
        try {
            this.ivOs.write(this.ivBaos.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void logSystemStream(StreamEvent streamEvent) {
        if (streamEvent == null) {
            return;
        }
        this.ivBaos.reset();
        if (this.ivOutputXML) {
            streamEvent.writeDataToStream(this.ivPs, true);
            this.ivPs.flush();
            String string = this.ivBaos.toString();
            this.ivBaos.reset();
            this.ivPs.println(this.formatMessageInXML(string, streamEvent));
        } else {
            this.ivPs.println(this.formatEntryHeader(streamEvent));
            this.ivPs.print(this.primMessageLabel);
            streamEvent.writeDataToStream(this.ivPs, true);
            this.ivPs.println(this.formatEntryTrailer(streamEvent));
        }
        this.ivPs.flush();
        try {
            this.ivOs.write(this.ivBaos.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String formatEntryHeader(RasEvent rasEvent) {
        String string = emptyString;
        String string2 = emptyString;
        String string3 = emptyString;
        String string4 = "000000";
        String string5 = emptyString;
        String string6 = emptyString;
        String string7 = emptyString;
        String string8 = emptyString;
        String string9 = emptyString;
        if (rasEvent.ivClassName != null) {
            string9 = rasEvent.ivClassName;
        }
        if (rasEvent.ivMethodName != null) {
            string = rasEvent.ivMethodName;
        }
        if (rasEvent.ivUnitOfWork != null) {
            string2 = rasEvent.ivUnitOfWork;
        }
        if (rasEvent.ivEventSource != null) {
            string3 = rasEvent.ivEventSource;
        }
        if (rasEvent.ivComponent != null) {
            string5 = rasEvent.ivComponent;
        }
        if (rasEvent.ivOrganization != null) {
            string6 = rasEvent.ivOrganization;
        }
        if (rasEvent.ivProduct != null) {
            string7 = rasEvent.ivProduct;
        }
        if (rasEvent.ivProcessId != null) {
            string8 = rasEvent.ivProcessId;
        }
        if (rasEvent.ivTimeStamp == this.previousTimestamp) {
            ++this.paddingCounter;
            string4 = this.numberFormat.format(this.paddingCounter);
        } else {
            this.previousTimestamp = rasEvent.ivTimeStamp;
            this.paddingCounter = 0;
        }
        this.ivBuffer.setLength(0);
        this.ivBuffer.append("---------------------------------------------------------------");
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.compIDLabel);
        this.ivBuffer.append(string5);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.processIDLabel);
        this.ivBuffer.append(string8);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.threadIDLabel);
        this.ivBuffer.append(rasEvent.ivThreadId);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.sourceIDLabel);
        this.ivBuffer.append(string3);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.classNameLabel);
        this.ivBuffer.append(string9);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.methodNameLabel);
        this.ivBuffer.append(string);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.manufacturerLabel);
        this.ivBuffer.append(string6);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.productLabel);
        this.ivBuffer.append(string7);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.versionLabel);
        this.ivBuffer.append(rasEvent.ivVersion);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.serverNameLabel);
        this.ivBuffer.append(rasEvent.ivServerName);
        this.ivBuffer.append(this.ivLineSep);
        this.ivDate.setTime(rasEvent.ivTimeStamp);
        this.ivTimeBuffer.setLength(0);
        this.ivTimeBuffer = this.ivFormatter.format(this.ivDate, this.ivTimeBuffer, this.ivFieldPos);
        this.ivBuffer.append(this.timeStampLabel);
        this.ivBuffer.append(this.ivTimeBuffer.toString() + string4);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.uowLabel);
        this.ivBuffer.append(string2);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.severityLabel);
        this.ivBuffer.append(ExtendedTraceLogger.getSeverity(rasEvent.ivType));
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.categoryLabel);
        this.ivBuffer.append(RasEvent.getTypeString(rasEvent.ivType));
        return this.ivBuffer.toString();
    }

    private String formatEntryTrailer(RasEvent rasEvent) {
        String string = emptyString;
        if (rasEvent.ivExtendedMessage != null && rasEvent.ivExtendedMessage.compareTo(emptyString) != 0) {
            string = rasEvent.ivExtendedMessage;
        }
        return this.extMessageLabel + string;
    }

    private String formatMessageInXML(String string, RasEvent rasEvent) {
        String string2 = emptyString;
        String string3 = emptyString;
        String string4 = emptyString;
        String string5 = "000000";
        String string6 = emptyString;
        String string7 = emptyString;
        String string8 = emptyString;
        String string9 = emptyString;
        String string10 = emptyString;
        string = this.normalize(string);
        if (rasEvent.ivClassName != null) {
            string10 = this.normalize(rasEvent.ivClassName);
        }
        if (rasEvent.ivMethodName != null) {
            string2 = this.normalize(rasEvent.ivMethodName);
        }
        if (rasEvent.ivUnitOfWork != null) {
            string3 = this.normalize(rasEvent.ivUnitOfWork);
        }
        if (rasEvent.ivEventSource != null) {
            string4 = this.normalize(rasEvent.ivEventSource);
        }
        if (rasEvent.ivComponent != null) {
            string6 = this.normalize(rasEvent.ivComponent);
        }
        if (rasEvent.ivOrganization != null) {
            string7 = this.normalize(rasEvent.ivOrganization);
        }
        if (rasEvent.ivProduct != null) {
            string8 = this.normalize(rasEvent.ivProduct);
        }
        if (rasEvent.ivProcessId != null) {
            string9 = this.normalize(rasEvent.ivProcessId);
        }
        if (rasEvent.ivTimeStamp == this.previousTimestamp) {
            ++this.paddingCounter;
            string5 = this.numberFormat.format(this.paddingCounter);
        } else {
            this.previousTimestamp = rasEvent.ivTimeStamp;
            this.paddingCounter = 0;
        }
        String string11 = emptyString;
        if (rasEvent.ivExtendedMessage != null && rasEvent.ivExtendedMessage.compareTo(emptyString) != 0) {
            string11 = this.normalize(rasEvent.ivExtendedMessage);
        }
        this.ivBuffer.setLength(0);
        this.ivBuffer.append("<WASActivityLogEntry");
        this.ivBuffer.append(svSpace);
        this.ivBuffer.append(this.compIDLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(string6);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.processIDLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(string9);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.threadIDLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(rasEvent.ivThreadId);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.sourceIDLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(string4);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.classNameLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(string10);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.methodNameLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(string2);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.manufacturerLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(string7);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.productLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(string8);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.versionLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(this.normalize(rasEvent.ivVersion));
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.serverNameLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(this.normalize(rasEvent.ivServerName));
        this.ivBuffer.append(svQuoteSpace);
        this.ivDate.setTime(rasEvent.ivTimeStamp);
        this.ivTimeBuffer.setLength(0);
        this.ivTimeBuffer = this.ivFormatter.format(this.ivDate, this.ivTimeBuffer, this.ivFieldPos);
        this.ivBuffer.append(this.timeStampLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(this.ivTimeBuffer.toString() + string5);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.uowLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(string3);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.severityLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(ExtendedTraceLogger.getSeverity(rasEvent.ivType));
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.categoryLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(RasEvent.getTypeString(rasEvent.ivType));
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.primMessageLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(string);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.extMessageLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(string11);
        this.ivBuffer.append(svQuote);
        this.ivBuffer.append(svXmlEnd);
        return this.ivBuffer.toString();
    }

    private String normalize(String string) {
        int n = string.length();
        this.ivNormalizeBuffer.setLength(0);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                this.ivNormalizeBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                this.ivNormalizeBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                this.ivNormalizeBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                this.ivNormalizeBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                this.ivNormalizeBuffer.append("&apos;");
                continue;
            }
            if (c == '\t') {
                this.ivNormalizeBuffer.append("&#x9;");
                continue;
            }
            if (c == '\n') {
                this.ivNormalizeBuffer.append("&#xA;");
                continue;
            }
            if (c == '\r') {
                this.ivNormalizeBuffer.append("&#xD;");
                continue;
            }
            this.ivNormalizeBuffer.append(c);
        }
        return this.ivNormalizeBuffer.toString();
    }

    private static int getSeverity(int n) {
        int n2;
        switch (n) {
            case 4: 
            case 8: {
                n2 = 1;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 3;
            }
        }
        return n2;
    }
}

