/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.CBuffLogger;
import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.MalformedTraceStringException;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.SharedLogWriter;
import com.ibm.ejs.ras.SystemErrStream;
import com.ibm.ejs.ras.SystemOutStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceElement;
import com.ibm.ejs.ras.TraceEventGenerator;
import com.ibm.ejs.ras.TraceEventListener;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import com.ibm.websphere.ras.TraceElementState;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class ManagerAdmin {
    private static TraceComponent svTc = Tr.register(class$com$ibm$ejs$ras$ManagerAdmin == null ? (class$com$ibm$ejs$ras$ManagerAdmin = ManagerAdmin.class$("com.ibm.ejs.ras.ManagerAdmin")) : class$com$ibm$ejs$ras$ManagerAdmin, null, "com.ibm.ejs.resources.RasMessages");
    static final byte DUMP = 0;
    public static final byte DEBUG = 1;
    public static final byte ENTRY_EXIT = 2;
    public static final byte EVENT = 4;
    public static final byte ALL = 7;
    public static final String BASIC = "basic";
    public static final String ADVANCED = "advanced";
    public static final String LOGANALYZER = "loganalyzer";
    public static final String stdout = "stdout";
    public static final String file = "named file";
    public static final String ringBuffer = "ringbuffer";
    public static final int RING_BUFFER_MIN_SIZE = 1;
    public static final int RING_BUFFER_DEFAULT_SIZE = 8;
    public static final int SERVICE_LOG_MIN_SIZE = 2;
    public static final int SERVICE_LOG_DEFAULT_SIZE = 1024;
    public static final int SERVICE_LOG_MAX_SIZE = 0x100000;
    public static final String none = "NONE";
    public static final String audit = "AUDIT";
    public static final String service = "SERVICE";
    public static final String warning = "WARNING";
    public static final String sysOut = "SystemOut";
    public static final String sysErr = "SystemErr";
    static final String enabled = "enabled";
    static final String disabled = "disabled";
    private static final String svBundle = "com.ibm.ejs.resources.RasMessages";
    private static boolean svTracingToFile;
    private static boolean svTraceIsEnabled;
    private static CBuffLogger svCbuff;
    private static TraceLogger svTraceFileListener;
    private static String svTraceFileName;
    private static long svRolloverSize;
    private static int svMaxBackups;
    private static WrappingFileOutputStream svTraceFileStream;
    private static boolean svHeaderPrinted;
    private static boolean svTraceConfigured;
    private static boolean svLoggingConfigured;
    static /* synthetic */ Class class$com$ibm$ejs$ras$ManagerAdmin;

    private ManagerAdmin() {
    }

    public static synchronized void configureMessageLogging(boolean bl, String string, int n, String string2, boolean bl2) {
        if (!RasHelper.isServer()) {
            return;
        }
        if (svLoggingConfigured) {
            return;
        }
        svLoggingConfigured = true;
        RasProperties.setMessageFilterLevelProperty(string2);
        RasProperties.setUnitOfWorkProperty(bl2);
        if (!bl) {
            Tr.audit(svTc, "MSG_SHARED_LOG_DISABLED");
        } else {
            try {
                String string3 = RasHelper.generateOutputFileName(string, "ActivityLog", svTc);
                RasProperties.setActivityLogName(string);
                RasProperties.setActivityLogSize(n);
                try {
                    SharedLogWriter sharedLogWriter = SharedLogWriter.getInstance();
                    if (sharedLogWriter != null) {
                        Tr.addTraceEventListener(sharedLogWriter);
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (RasException rasException) {
                Tr.error(svTc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{string, rasException});
            }
        }
    }

    public static synchronized void configureServerTrace(String string, String string2, String string3, long l, int n, int n2, String string4) {
        if (!RasHelper.isServer()) {
            return;
        }
        if (svTraceConfigured) {
            return;
        }
        svTraceConfigured = true;
        SystemOutStream.initialize();
        try {
            ManagerAdmin.checkTraceString(string);
        }
        catch (MalformedTraceStringException malformedTraceStringException) {
            Tr.info(svTc, "MSG_TRACE_SYNTAXERR_WARNING", malformedTraceStringException.getMessage());
        }
        Tr.getComponentManager().processTraceString(string, true);
        string4 = RasProperties.setTraceFormatProperty(string4);
        svTraceIsEnabled = ComponentManager.svTraceEnabled;
        if (string2.equals(file)) {
            ManagerAdmin.addServerTraceFileListener(string3, l, n);
        } else {
            ManagerAdmin.addServerRingBufferListener(n2);
        }
        Tr.info(svTc, "MSG_INITIAL_TRACE_STATE", Tr.getComponentManager().getTraceSpecification());
    }

    public static synchronized void configureClientTrace(String string, String string2, String string3, boolean bl, String string4, boolean bl2) {
        block6: {
            if (RasHelper.isServer()) {
                return;
            }
            if (svTraceConfigured) {
                return;
            }
            svTraceConfigured = true;
            Tr.getComponentManager().processTraceString(string, true);
            string4 = RasProperties.setTraceFormatProperty(string4);
            RasProperties.setUnitOfWorkProperty(bl2);
            try {
                if (string2.equals(file)) {
                    ManagerAdmin.openClientTraceFile(string3, bl);
                } else {
                    TraceLogger traceLogger = ManagerAdmin.createListener(Tr.getSystemOut());
                    traceLogger.printHeader();
                    Tr.addTraceEventListener(traceLogger);
                    svTracingToFile = false;
                }
            }
            catch (Throwable throwable) {
                TraceLogger traceLogger = ManagerAdmin.createListener(Tr.getSystemOut());
                traceLogger.printHeader();
                Tr.addTraceEventListener(traceLogger);
                svTracingToFile = false;
                if (string2 == null || !string2.equals(file)) break block6;
                Tr.error(svTc, "MSG_OPEN_TRACE_FILE_FAILED", new Object[]{string3, throwable});
                Tr.info(svTc, "MSG_TRACE_TO_SYSOUT");
            }
        }
        Tr.info(svTc, "MSG_INITIAL_TRACE_STATE", Tr.getComponentManager().getTraceSpecification());
    }

    public static void addJmxListener(TraceEventListener traceEventListener) throws RasException {
        if (traceEventListener == null) {
            throw new RasException("A null JMX listener is not allowed");
        }
        Tr.addJmxListener(traceEventListener);
    }

    public static void setTraceEventGenerator(TraceEventGenerator traceEventGenerator) {
        Tr.setTraceEventGenerator(traceEventGenerator);
    }

    public static String getTraceFileName() {
        if (svTracingToFile) {
            return svTraceFileName;
        }
        return null;
    }

    public static String getTraceSpecification() {
        return Tr.getComponentManager().getTraceSpecification();
    }

    public static String getTraceSpecification(String string) {
        return Tr.getComponentManager().getTraceSpecification(string);
    }

    public static void setTraceState(String string) {
        Tr.getComponentManager().processTraceString(string, true);
        ManagerAdmin.processTraceStateChanged();
        Tr.info(svTc, "MSG_TRACE_STATE_CHANGED", Tr.getComponentManager().getTraceSpecification());
    }

    public static void appendTraceString(String string) {
        Tr.getComponentManager().processTraceString(string, false);
        ManagerAdmin.processTraceStateChanged();
        Tr.info(svTc, "MSG_TRACE_STATE_CHANGED", Tr.getComponentManager().getTraceSpecification());
    }

    public static synchronized int getRingBufferSize() {
        if (svCbuff == null) {
            return 0;
        }
        return svCbuff.getSize();
    }

    public static synchronized void setRingBufferSize(int n) {
        if (svCbuff == null) {
            return;
        }
        svCbuff.setSize(n);
    }

    public static void dumpRingBuffer(String string) {
        if (svCbuff == null) {
            return;
        }
        try {
            svCbuff.dump(string);
        }
        catch (RasException rasException) {
            // empty catch block
        }
    }

    public static void clearRingBuffer() {
        if (svCbuff != null) {
            svCbuff.clear();
        }
    }

    public static String[] listAllRegisteredComponents() {
        return Tr.getComponentManager().getComponents();
    }

    public static String[] listAllRegisteredGroups() {
        return Tr.getComponentManager().getGroups();
    }

    public static String[] listComponentsInGroup(String string) {
        return Tr.getComponentManager().getGroupComponents(string);
    }

    public static TraceElementState[] getTracedComponents() {
        Vector vector = Tr.getComponentManager().getTracedComponents();
        int n = vector.size();
        TraceElementState[] traceElementStateArray = new TraceElementState[n];
        for (int i = 0; i < n; ++i) {
            TraceElementState traceElementState;
            TraceElement traceElement = (TraceElement)vector.elementAt(i);
            traceElementStateArray[i] = traceElementState = new TraceElementState(traceElement);
        }
        return traceElementStateArray;
    }

    public static TraceElementState[] getTracedGroups() {
        Vector vector = Tr.getComponentManager().getTracedGroups();
        int n = vector.size();
        TraceElementState[] traceElementStateArray = new TraceElementState[n];
        for (int i = 0; i < n; ++i) {
            TraceElementState traceElementState;
            TraceElement traceElement = (TraceElement)vector.elementAt(i);
            traceElementStateArray[i] = traceElementState = new TraceElementState(traceElement);
        }
        return traceElementStateArray;
    }

    public static void processDumpString(String string) {
        Tr.getComponentManager().processDumpString(string);
    }

    public static synchronized void setTraceOutputToFile(String string, long l, int n, String string2) throws RasException {
        if (!svTraceConfigured) {
            throw new RasException("Trace must be configured before it can be changed");
        }
        string2 = RasProperties.setTraceFormatProperty(string2);
        if (svTracingToFile) {
            ManagerAdmin.removeServerTraceFileListener();
        } else {
            ManagerAdmin.removeServerRingBufferListener();
        }
        ManagerAdmin.addServerTraceFileListener(string, l, n);
        svHeaderPrinted = false;
    }

    public static synchronized void setTraceOutputToRingBuffer(int n, String string) throws RasException {
        if (!svTraceConfigured) {
            throw new RasException("Trace must be configured before it can be changed");
        }
        string = RasProperties.setTraceFormatProperty(string);
        if (svTracingToFile) {
            ManagerAdmin.removeServerTraceFileListener();
            ManagerAdmin.addServerRingBufferListener(n);
        } else {
            ManagerAdmin.setRingBufferSize(n);
        }
    }

    public static void checkTraceString(String string) throws MalformedTraceStringException {
        String string2 = null;
        if ((string = RasHelper.peelQuotes(string)) == null) {
            return;
        }
        if (string.equals("")) {
            string2 = TraceNLS.getStringFromBundle(svBundle, "EXCEPTION_EMPTY_STRING_TRACESTRING", "Empty string is not part of trace string grammar");
            throw new MalformedTraceStringException(string2);
        }
        String[] stringArray = RasHelper.split(string, 58);
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            if (stringArray[i].equals("")) {
                string2 = TraceNLS.getStringFromBundle(svBundle, "EXCEPTION_EMPTY_STRING_SUBTRACESTRING", "empty string encountered - remove extra colon");
                throw new MalformedTraceStringException(string2);
            }
            int n = stringArray[i].indexOf(61);
            if (n == -1) {
                string2 = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_NO_VALUE_PAIRS", new Object[]{stringArray[i]}, "No type=state value pair(s) found at ''{0}''");
                throw new MalformedTraceStringException(string2);
            }
            string3 = stringArray[i].substring(0, n);
            if (string3.equals("")) {
                string2 = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_NO_COMPONENT_NAME", new Object[]{stringArray[i]}, "No component name found at ''{0}''");
                throw new MalformedTraceStringException(string2);
            }
            if ((string4 = stringArray[i].substring(++n)).equals("")) {
                string2 = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_NO_VALUE_PAIRS", new Object[]{stringArray[i]}, "No type=state value pair(s) found at ''{0}''");
                throw new MalformedTraceStringException(string2);
            }
            String[] stringArray2 = RasHelper.split(string4, 44);
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].equals("")) {
                    string2 = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_MISSING_VALUE_PAIR", new Object[]{stringArray[i]}, "Missing type=state value pair at ''{0}'', remove extra comma");
                    throw new MalformedTraceStringException(string2);
                }
                String[] stringArray3 = RasHelper.split(stringArray2[j], 61);
                if (stringArray3.length > 2) {
                    string2 = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_INVALID_VALUE_PAIR", new Object[]{stringArray2[j], stringArray[i]}, "Invalid type=state value pair - ''{0}'' at ''{1}''");
                    throw new MalformedTraceStringException(string2);
                }
                if (stringArray3.length == 1) {
                    string2 = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_MISSING_STATE", new Object[]{stringArray[i]}, "Missing state value at ''{0}''");
                    throw new MalformedTraceStringException(string2);
                }
                String string5 = stringArray3[0];
                if (string5.equals("")) {
                    string2 = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_MISSING_TYPE", new Object[]{stringArray[i]}, "Missing type value at ''{0}''");
                    throw new MalformedTraceStringException(string2);
                }
                if (!(string5.equals("all") || string5.equals("event") || string5.equals("debug") || string5.equals("entryExit") || string5.equals("dump"))) {
                    string2 = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_INVALID_TYPE", new Object[]{string5, stringArray[i]}, "Invalid type value - ''{0}'' at ''{1}''");
                    throw new MalformedTraceStringException(string2);
                }
                String string6 = stringArray3[1];
                if (string6.equals("")) {
                    string2 = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_MISSING_STATE", new Object[]{stringArray[i]}, "Missing state value at ''{0}''");
                    throw new MalformedTraceStringException(string2);
                }
                if (string6.equalsIgnoreCase(enabled) || string6.equalsIgnoreCase(disabled)) continue;
                string2 = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_INVALID_STATE", new Object[]{string6, stringArray[i]}, "Invalid state value - ''{0}'' at ''{1}''");
                throw new MalformedTraceStringException(string2);
            }
        }
    }

    public static synchronized void setMessageFilterLevel(String string) {
        RasProperties.setMessageFilterLevelProperty(string);
    }

    public static synchronized String getMessageFilterLevel() {
        return RasProperties.getMessageFilterLevelProperty();
    }

    public static String rolloverLogFileImmediate(String string, String string2) throws RasException {
        if (string == null) {
            throw new RasException("invalid stream indicator of null specified");
        }
        if (string.equals(sysOut)) {
            return SystemOutStream.rolloverLogFileImmediate(string2);
        }
        if (string.equals(sysErr)) {
            return SystemErrStream.rolloverLogFileImmediate(string2);
        }
        throw new RasException("specified stream name of " + string + " is invalid or unsupported");
    }

    public static boolean isLogFileWriteable(String string) {
        try {
            RasHelper.validateFileName(string.trim());
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static TraceLogger createListener(OutputStream outputStream) {
        if (RasProperties.svTraceFormat.equalsIgnoreCase(LOGANALYZER)) {
            return new ExtendedTraceLogger(outputStream);
        }
        if (RasProperties.svTraceFormat.equalsIgnoreCase(ADVANCED)) {
            return new TraceLogger(outputStream, false);
        }
        return new TraceLogger(outputStream, true);
    }

    private static synchronized void addServerRingBufferListener(int n) {
        if (svCbuff != null) {
            return;
        }
        svCbuff = n < 1 ? new CBuffLogger(8) : new CBuffLogger(n);
        Tr.addTraceEventListener(svCbuff);
        svTracingToFile = false;
    }

    private static synchronized void removeServerRingBufferListener() {
        if (svCbuff == null) {
            return;
        }
        Tr.removeTraceEventListener(svCbuff);
        svCbuff = null;
    }

    private static synchronized void addServerTraceFileListener(String string, long l, int n) {
        try {
            svTraceFileName = RasHelper.generateOutputFileName(string, "TraceFile", svTc);
        }
        catch (Throwable throwable) {
            Tr.error(svTc, "MSG_OPEN_TRACE_FILE_FAILED", new Object[]{string, throwable});
            Tr.info(svTc, "MSG_TRACE_TO_RING_BUFFER");
            ManagerAdmin.addServerRingBufferListener(8);
            svTracingToFile = false;
            return;
        }
        svRolloverSize = l;
        svMaxBackups = n;
        svTracingToFile = true;
        if (svTraceIsEnabled) {
            ManagerAdmin.openServerTraceFile();
        }
    }

    private static synchronized void removeServerTraceFileListener() {
        if (svTraceFileListener != null) {
            Tr.removeTraceEventListener(svTraceFileListener);
            svTraceFileListener = null;
        }
        ManagerAdmin.closeServerTraceFile();
    }

    private static synchronized void openServerTraceFile() {
        try {
            svTraceFileStream = new WrappingFileOutputStream(svTraceFileName, svMaxBackups, svRolloverSize);
            svTraceFileListener = ManagerAdmin.createListener(svTraceFileStream);
            svTraceFileStream.addRolloverListener(svTraceFileListener);
            if (!svHeaderPrinted) {
                svTraceFileListener.printHeader();
                svHeaderPrinted = true;
            }
            Tr.addTraceEventListener(svTraceFileListener);
        }
        catch (Throwable throwable) {
            Tr.error(svTc, "MSG_OPEN_TRACE_FILE_FAILED", new Object[]{svTraceFileName, throwable});
            Tr.info(svTc, "MSG_TRACE_TO_RING_BUFFER");
            ManagerAdmin.addServerRingBufferListener(8);
            svTracingToFile = false;
            svTraceFileListener = null;
            ManagerAdmin.closeServerTraceFile();
        }
    }

    private static synchronized void closeServerTraceFile() {
        if (svTraceFileStream != null) {
            try {
                svTraceFileStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            svTraceFileStream = null;
        }
    }

    private static synchronized void openClientTraceFile(String string, boolean bl) throws RasException, IOException {
        svTraceFileName = string.trim();
        RasHelper.validateFileName(svTraceFileName);
        FileOutputStream fileOutputStream = RasHelper.createFileOutputStream(svTraceFileName, !bl);
        svTraceFileListener = ManagerAdmin.createListener(fileOutputStream);
        svTraceFileListener.printHeader();
        Tr.addTraceEventListener(svTraceFileListener);
        svTracingToFile = true;
    }

    private static synchronized void processTraceStateChanged() {
        if (svTraceIsEnabled == ComponentManager.svTraceEnabled) {
            return;
        }
        if (!svTraceConfigured) {
            return;
        }
        if (RasHelper.isServer() && svTracingToFile) {
            if (svTraceIsEnabled) {
                ManagerAdmin.removeServerTraceFileListener();
            } else {
                ManagerAdmin.openServerTraceFile();
            }
        }
        svTraceIsEnabled = ComponentManager.svTraceEnabled;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        svTraceIsEnabled = false;
        svCbuff = null;
        svTraceFileListener = null;
        svTraceFileName = null;
        svTraceFileStream = null;
        svHeaderPrinted = false;
        svTraceConfigured = false;
        svLoggingConfigured = false;
    }
}

