/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;

class RasProperties {
    private static final String svActivityLogDefaultName = "activity.log";
    private static String svActivityLogName = null;
    private static int svActivityLogSize = 0x100000;
    private static int ACTIVITY_LOG_DEFAULT_SIZE = 0x100000;
    private static int ACTIVITY_LOG_MAX_SIZE = 0x40000000;
    private static int ACTIVITY_LOG_MIN_SIZE = 8096;
    private static String svDefaultLoggingDirectory = null;
    private static final String svLogDir = "logs";
    static boolean svUowEnabled = false;
    static int svFilterMessageLevel = 3;
    static int Error = 0;
    static int Warning = 1;
    static int Service = 2;
    static int Audit = 3;
    static String svTraceFormat = "basic";
    private static String svMessageFormat = "basic";
    private static boolean svInitialized = false;
    private static String svPropertiesFileName = "logging.properties";
    static /* synthetic */ Class class$com$ibm$ejs$ras$RasProperties;

    RasProperties() {
    }

    static String setTraceFormatProperty(String string) {
        if (string == null) {
            svTraceFormat = "basic";
            return svTraceFormat;
        }
        if (string.equalsIgnoreCase("loganalyzer")) {
            svTraceFormat = "loganalyzer";
            return svTraceFormat;
        }
        if (string.equalsIgnoreCase("advanced")) {
            svTraceFormat = "advanced";
            return svTraceFormat;
        }
        svTraceFormat = "basic";
        return svTraceFormat;
    }

    static String getTraceFormatProperty() {
        return svTraceFormat;
    }

    static String setMessageFormatProperty(String string) {
        if (string == null) {
            svMessageFormat = "basic";
            return svMessageFormat;
        }
        if (string.equalsIgnoreCase("advanced")) {
            svMessageFormat = "advanced";
            return svMessageFormat;
        }
        svMessageFormat = "basic";
        return svMessageFormat;
    }

    static String getMessageFormatProperty() {
        return svMessageFormat;
    }

    static void setMessageFilterLevelProperty(String string) {
        if (string == null) {
            svFilterMessageLevel = 3;
            return;
        }
        if (string.equalsIgnoreCase("WARNING")) {
            svFilterMessageLevel = 0;
            return;
        }
        if (string.equalsIgnoreCase("SERVICE")) {
            svFilterMessageLevel = 1;
            return;
        }
        if (string.equalsIgnoreCase("AUDIT")) {
            svFilterMessageLevel = 2;
            return;
        }
        svFilterMessageLevel = 3;
    }

    static String getMessageFilterLevelProperty() {
        if (svFilterMessageLevel == 3) {
            return "NONE";
        }
        if (svFilterMessageLevel == 2) {
            return "AUDIT";
        }
        if (svFilterMessageLevel == 1) {
            return "SERVICE";
        }
        if (svFilterMessageLevel == 0) {
            return "WARNING";
        }
        return "NONE";
    }

    static void setUnitOfWorkProperty(boolean bl) {
        svUowEnabled = bl;
    }

    static boolean getUnitOfWorkProperty() {
        return svUowEnabled;
    }

    static synchronized void setActivityLogName(String string) throws RasException {
        svActivityLogName = string;
    }

    static synchronized String getActivityLogName() throws RasException {
        if (svActivityLogName == null) {
            svActivityLogName = RasProperties.getDefaultLoggingDirectory() + File.separator + svActivityLogDefaultName;
        }
        return svActivityLogName;
    }

    static synchronized void setActivityLogSize(int n) {
        svActivityLogSize = n < ACTIVITY_LOG_MIN_SIZE ? ACTIVITY_LOG_MIN_SIZE : (n > ACTIVITY_LOG_MAX_SIZE ? ACTIVITY_LOG_MAX_SIZE : n);
    }

    static synchronized int getActivityLogSize() {
        return svActivityLogSize;
    }

    static synchronized String getDefaultLoggingDirectory() throws RasException {
        if (svDefaultLoggingDirectory == null) {
            String string = RasHelper.getSystemProperty("user.install.root");
            if (string == null) {
                throw new RasException("RasProperties - unable to obtain the install directory");
            }
            File file = new File(string = string.endsWith(File.separator) ? string + svLogDir : string + File.separator + svLogDir);
            if (!RasHelper.fileExists(file) && !RasHelper.makeDirectories(file)) {
                throw new RasException("RasProperties - Unable to create directory  " + file.getPath());
            }
            svDefaultLoggingDirectory = file.getPath();
        }
        return svDefaultLoggingDirectory;
    }

    private static void createDirectoryIfNecessary(String string) throws RasException {
        File file = new File(string);
        int n = (string = file.getPath()).lastIndexOf(File.separator);
        if (n == -1) {
            throw new RasException("RasProperties File " + string + " is not a fully qualified name");
        }
        String string2 = string.substring(0, n);
        file = new File(string2);
        if (!RasHelper.fileExists(file) && !RasHelper.makeDirectories(file)) {
            throw new RasException("Unable to create directory  " + string2);
        }
    }

    static synchronized void loadProperties() {
        if (svInitialized) {
            return;
        }
        try {
            Properties properties = RasProperties.readProperties();
            svInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static synchronized void refreshRasProperties() {
        if (!svInitialized) {
            RasProperties.loadProperties();
        }
    }

    static boolean isUnitOfWorkEnabled() {
        return svUowEnabled;
    }

    static void debugDisplayProperties() {
        TraceComponent traceComponent = Tr.register(class$com$ibm$ejs$ras$RasProperties == null ? (class$com$ibm$ejs$ras$RasProperties = RasProperties.class$("com.ibm.ejs.ras.RasProperties")) : class$com$ibm$ejs$ras$RasProperties);
        Tr.uncondEvent(traceComponent, "Activity Log Size = " + svActivityLogSize);
        Tr.uncondEvent(traceComponent, "Unit of Work Enabled = " + svUowEnabled);
        Tr.uncondEvent(traceComponent, "Message Filter Level = " + svFilterMessageLevel);
        Tr.uncondEvent(traceComponent, "Trace Format = " + svTraceFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized Properties readProperties() {
        Properties properties;
        block12: {
            InputStream inputStream;
            block11: {
                properties = new Properties();
                inputStream = null;
                inputStream = RasHelper.getResourceAsStream(svPropertiesFileName);
                if (inputStream == null) break block11;
                properties.load(inputStream);
            }
            Object var4_2 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block12;
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (Exception exception) {
                    Object var4_3 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block12;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

