/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.SharedLogConstants;
import com.ibm.ejs.ras.SharedLogLockException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;

abstract class SharedLogBase
implements SharedLogConstants {
    private static TraceComponent tc = Tr.register(class$com$ibm$ejs$ras$SharedLogBase == null ? (class$com$ibm$ejs$ras$SharedLogBase = SharedLogBase.class$("com.ibm.ejs.ras.SharedLogBase")) : class$com$ibm$ejs$ras$SharedLogBase);
    static /* synthetic */ Class class$com$ibm$ejs$ras$SharedLogBase;

    SharedLogBase() throws RasException {
    }

    static synchronized void acquireHostLock(File file) throws SharedLogLockException {
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        File file2 = file;
        try {
            while (!bl) {
                bl = RasHelper.createNewFile(file2);
                if (bl) {
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Contention detected attempting to get SharedLog lock");
                }
                if (n == 600) {
                    long l;
                    long l2 = System.currentTimeMillis();
                    if (l2 - (l = RasHelper.fileLastModified(file2)) > 300000L && bl2) {
                        bl2 = false;
                        SharedLogBase.releaseHostLock(file);
                        n = 0;
                    } else {
                        SharedLogLockException sharedLogLockException = new SharedLogLockException("Unable to obtain Shared Log Lock file " + file2.getPath());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception detected attempting to get Host Lock", sharedLogLockException);
                        }
                        throw sharedLogLockException;
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            SharedLogLockException sharedLogLockException = new SharedLogLockException("Unable to obtain Shared Log Lock file " + file2.getPath(), throwable);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception detected attempting to get Host Lock", sharedLogLockException);
            }
            throw sharedLogLockException;
        }
    }

    static void releaseHostLock(File file) {
        try {
            RasHelper.deleteFile(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    File copyLogFile(String string) throws IOException {
        File file = null;
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        try {
            file = this.createTemporaryFile();
            randomAccessFile = this.createRandomAccessFile(file.getPath(), "rw");
            randomAccessFile2 = this.createRandomAccessFile(string, "r");
            this.copyFile(randomAccessFile2, randomAccessFile);
            randomAccessFile2.close();
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                if (randomAccessFile2 != null) {
                    randomAccessFile2.close();
                }
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            throw iOException;
        }
        return file;
    }

    private File createTemporaryFile() throws IOException {
        try {
            return (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return File.createTempFile("wsal", ".log");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    RandomAccessFile createRandomAccessFile(String string, String string2) throws IOException {
        final String string3 = string;
        final String string4 = string2;
        try {
            return (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new RandomAccessFile(string3, string4);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void copyFile(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException {
        int n = 4096;
        byte[] byArray = new byte[n];
        long l = randomAccessFile.length();
        boolean bl = false;
        randomAccessFile.seek(0L);
        randomAccessFile2.seek(0L);
        do {
            if (l > (long)n) {
                randomAccessFile.readFully(byArray);
                randomAccessFile2.write(byArray);
                l -= (long)n;
                continue;
            }
            byte[] byArray2 = new byte[(int)l];
            randomAccessFile.readFully(byArray2);
            randomAccessFile2.write(byArray2);
            bl = true;
        } while (!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTemporaryFile(RandomAccessFile randomAccessFile, File file) {
        try {
            randomAccessFile.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            RasHelper.deleteFile(file);
        }
    }

    Vector readCorruptedFile(RandomAccessFile randomAccessFile) {
        Vector<MessageEvent> vector = new Vector<MessageEvent>();
        try {
            int n = 4096;
            int n2 = (int)randomAccessFile.length();
            if (n2 < 1) {
                return null;
            }
            int n3 = n2 - 4100;
            if (n3 > 100000) {
                n3 = 100000;
            }
            int n4 = n2 / n;
            int n5 = n2 % n;
            if (n5 == 0) {
                --n4;
                n5 = n;
            }
            byte[] byArray = new byte[n + 3];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n6 = 0;
            int n7 = 0;
            for (int i = n4; i > 0; --i) {
                randomAccessFile.seek(n6);
                randomAccessFile.readFully(byArray);
                byteArrayInputStream.reset();
                n7 = 0;
                while (n7 != -1) {
                    if ((n7 = this.findNextHeader(dataInputStream, n + 3, n7)) == -1) continue;
                    MessageEvent messageEvent = this.getMessage(randomAccessFile, n6 + n7, n3);
                    if (messageEvent != null) {
                        vector.addElement(messageEvent);
                    }
                    n7 += 4;
                }
                n6 += n;
            }
            byArray = new byte[n5];
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            dataInputStream = new DataInputStream(byteArrayInputStream);
            n7 = 0;
            randomAccessFile.seek(n6);
            randomAccessFile.readFully(byArray);
            while (n7 != -1) {
                if ((n7 = this.findNextHeader(dataInputStream, n5, n7)) == -1) continue;
                MessageEvent messageEvent = this.getMessage(randomAccessFile, n6 + n7, n3);
                if (messageEvent != null) {
                    vector.addElement(messageEvent);
                }
                n7 += 4;
            }
            return vector;
        }
        catch (IOException iOException) {
            return vector;
        }
    }

    private int findNextHeader(DataInputStream dataInputStream, int n, int n2) {
        int n3 = -1;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = n - n2;
        try {
            for (int i = n2; i < n; ++i) {
                byte by = dataInputStream.readByte();
                if (by == SharedLogConstants.svEntryHeader[0]) {
                    n4 = 1;
                    n5 = i;
                } else {
                    switch (n4) {
                        case 1: {
                            if (by == SharedLogConstants.svEntryHeader[1]) {
                                n4 = 2;
                                break;
                            }
                            n4 = 0;
                            break;
                        }
                        case 2: {
                            if (by == SharedLogConstants.svEntryHeader[2]) {
                                n4 = 3;
                                break;
                            }
                            n4 = 0;
                            break;
                        }
                        case 3: {
                            n4 = by == SharedLogConstants.svEntryHeader[3] ? 4 : 0;
                        }
                    }
                }
                if (n4 != 4) continue;
                return n5;
            }
            return -1;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    private MessageEvent getMessage(RandomAccessFile randomAccessFile, int n, int n2) {
        try {
            byte[] byArray = new byte[4];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            randomAccessFile.seek(n + 4);
            randomAccessFile.readFully(byArray);
            int n3 = dataInputStream.readInt();
            if (n3 > n2) {
                return null;
            }
            byte[] byArray2 = new byte[n3];
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream2);
            randomAccessFile.seek(n + 8);
            randomAccessFile.readFully(byArray2);
            MessageEvent messageEvent = new MessageEvent();
            messageEvent.readFromStream(dataInputStream2);
            return messageEvent;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

