/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.SharedLogBase;
import com.ibm.ejs.ras.SharedLogConstants;
import com.ibm.ejs.ras.SharedLogHeader;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class SharedLogReader
extends SharedLogBase {
    private TraceComponent tc = Tr.register(class$com$ibm$ejs$ras$SharedLogReader == null ? (class$com$ibm$ejs$ras$SharedLogReader = SharedLogReader.class$("com.ibm.ejs.ras.SharedLogReader")) : class$com$ibm$ejs$ras$SharedLogReader, null, "com.ibm.ejs.resources.RasMessages");
    private static final int svReadBufferSize = 1000;
    private boolean ivUsable = false;
    private int ivFirstMessage = -1;
    private boolean ivWrapped = false;
    private File ivFile = null;
    private RandomAccessFile ivRandomAccessFile = null;
    private SharedLogHeader ivHeader = null;
    private int ivCurMessage = -1;
    private byte[] ivBlockSizeBuffer;
    ByteArrayInputStream ivBlockSizeBais;
    DataInputStream ivBlockSizeDis;
    private int ivTrueFileSize;
    private MessageEvent ivFileSizeMismatch = null;
    private int ivMessagesToProcess = 0;
    private boolean ivLogProcessingComplete = false;
    static /* synthetic */ Class class$com$ibm$ejs$ras$SharedLogReader;

    SharedLogReader(String string, boolean bl) throws RasException {
        String string2 = this.locateFile(string);
        this.copySharedLog(string2, bl);
        try {
            this.ivBlockSizeBuffer = new byte[4];
            this.ivBlockSizeBais = new ByteArrayInputStream(this.ivBlockSizeBuffer);
            this.ivBlockSizeDis = new DataInputStream(this.ivBlockSizeBais);
            this.ivRandomAccessFile = this.createRandomAccessFile(this.ivFile.getPath(), "r");
            this.ivHeader = new SharedLogHeader(this.ivRandomAccessFile);
            this.ivTrueFileSize = (int)this.ivRandomAccessFile.length();
            if (!this.ivHeader.ivFileWrapped) {
                if (this.ivTrueFileSize != this.ivHeader.ivFreeSpace) {
                    this.ivFileSizeMismatch = new MessageEvent(4, this.tc, null, "MSG_ACTIVITY_LOG_CORRUPTED", null);
                    if (this.tc.isEventEnabled()) {
                        Tr.event(this.tc, "Ctor the free space size of " + this.ivHeader.ivFreeSpace + " did not match the physical file size " + this.ivTrueFileSize);
                    }
                }
            } else if (this.ivTrueFileSize != this.ivHeader.ivMaxSize) {
                this.ivFileSizeMismatch = new MessageEvent(4, this.tc, null, "MSG_ACTIVITY_LOG_CORRUPTED", null);
                if (this.tc.isEventEnabled()) {
                    Tr.event(this.tc, "Ctor - the file size of " + this.ivHeader.ivMaxSize + " did not match the physical file size " + this.ivTrueFileSize);
                }
            }
            this.ivMessagesToProcess = this.countMessages(this.ivRandomAccessFile, this.ivHeader);
            this.ivFirstMessage = this.findFirstMessage(this.ivRandomAccessFile, this.ivHeader);
            if (this.tc.isEventEnabled()) {
                String string3 = Integer.toHexString(this.ivFirstMessage);
                Tr.event(this.tc, "Ctor Message processing will begin at location " + string3);
            }
            this.ivCurMessage = this.ivFirstMessage;
            this.ivUsable = true;
        }
        catch (Throwable throwable) {
            this.ivUsable = false;
            this.deleteTemporaryFile(this.ivRandomAccessFile, this.ivFile);
            throw new RasException(throwable);
        }
    }

    MessageEvent getNextMessage() throws IOException {
        if (!this.ivUsable || this.ivCurMessage == -1) {
            return null;
        }
        try {
            if (this.ivLogProcessingComplete) {
                if (this.ivFileSizeMismatch != null) {
                    MessageEvent messageEvent = this.ivFileSizeMismatch;
                    this.ivFileSizeMismatch = null;
                    return messageEvent;
                }
                if (this.ivMessagesToProcess != 0) {
                    Integer n = new Integer(this.ivMessagesToProcess);
                    this.ivMessagesToProcess = 0;
                    MessageEvent messageEvent = new MessageEvent(4, this.tc, null, "MSG_CORRUPT_MESSAGE_COUNT", n);
                    return messageEvent;
                }
                this.ivUsable = false;
                return null;
            }
            byte[] byArray = this.retrieveMessage(this.ivRandomAccessFile, this.ivHeader, this.ivCurMessage);
            if (byArray != null) {
                this.ivCurMessage = this.incrementAndWrapLocation(this.ivHeader, this.ivCurMessage, byArray.length + 12);
                if (this.ivCurMessage <= this.ivFirstMessage) {
                    this.ivWrapped = true;
                }
            } else {
                this.ivCurMessage = this.findNextMessage(this.ivRandomAccessFile, this.ivHeader, this.ivCurMessage);
                if (this.ivCurMessage != -1) {
                    if (this.ivCurMessage <= this.ivFirstMessage) {
                        this.ivWrapped = true;
                    }
                    if (!this.ivWrapped || this.ivCurMessage < this.ivFirstMessage) {
                        byArray = this.retrieveMessage(this.ivRandomAccessFile, this.ivHeader, this.ivCurMessage);
                        this.ivCurMessage = this.incrementAndWrapLocation(this.ivHeader, this.ivCurMessage, byArray.length + 12);
                        if (this.ivCurMessage <= this.ivFirstMessage) {
                            this.ivWrapped = true;
                        }
                    }
                }
            }
            if (byArray == null) {
                this.ivLogProcessingComplete = true;
                this.deleteTemporaryFile(this.ivRandomAccessFile, this.ivFile);
                if (this.ivFileSizeMismatch != null) {
                    MessageEvent messageEvent = this.ivFileSizeMismatch;
                    this.ivFileSizeMismatch = null;
                    return messageEvent;
                }
                if (this.ivMessagesToProcess != 0) {
                    Integer n = new Integer(this.ivMessagesToProcess);
                    this.ivMessagesToProcess = 0;
                    MessageEvent messageEvent = new MessageEvent(4, this.tc, null, "MSG_CORRUPT_MESSAGE_COUNT", n);
                    return messageEvent;
                }
                this.ivUsable = false;
                return null;
            }
            if (this.ivWrapped && this.ivCurMessage >= this.ivFirstMessage) {
                this.ivLogProcessingComplete = true;
                this.deleteTemporaryFile(this.ivRandomAccessFile, this.ivFile);
            }
            --this.ivMessagesToProcess;
            MessageEvent messageEvent = this.getMessageEventFromByteArray(byArray);
            return messageEvent;
        }
        catch (IOException iOException) {
            this.ivUsable = false;
            this.deleteTemporaryFile(this.ivRandomAccessFile, this.ivFile);
            throw iOException;
        }
        catch (Throwable throwable) {
            this.ivUsable = false;
            this.deleteTemporaryFile(this.ivRandomAccessFile, this.ivFile);
            throw new IOException("Throwable occurred in SharedLogReader" + RasHelper.throwableToString(throwable));
        }
    }

    private MessageEvent getMessageEventFromByteArray(byte[] byArray) throws IOException {
        MessageEvent messageEvent = new MessageEvent();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        messageEvent.readFromStream(dataInputStream);
        return messageEvent;
    }

    private byte[] retrieveMessage(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, int n) throws IOException {
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "retrieveMessage - retrieving message at location " + Integer.toHexString(n));
        }
        if (!this.checkForPattern(randomAccessFile, sharedLogHeader, n, SharedLogConstants.svEntryHeader)) {
            return null;
        }
        int n2 = this.incrementAndWrapLocation(sharedLogHeader, n, SharedLogConstants.svEntryHeader.length);
        int n3 = this.readBlockSize(randomAccessFile, sharedLogHeader, n2);
        if (n3 == 0) {
            return null;
        }
        if (!this.checkForPattern(randomAccessFile, sharedLogHeader, n2 = this.incrementAndWrapLocation(sharedLogHeader, n2, 4 + n3), SharedLogConstants.svEntryTrailer)) {
            return null;
        }
        byte[] byArray = new byte[n3];
        n = this.incrementAndWrapLocation(sharedLogHeader, n, 8);
        this.fillBuffer(randomAccessFile, sharedLogHeader, n, byArray);
        return byArray;
    }

    private int findFirstMessage(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader) throws IOException {
        if (this.ivTrueFileSize - SharedLogHeader.DATA_AREA_OFFSET <= 12) {
            return -1;
        }
        if (!sharedLogHeader.ivFileWrapped) {
            return this.findNextMessage(randomAccessFile, sharedLogHeader, SharedLogHeader.DATA_AREA_OFFSET);
        }
        return this.findNextMessage(randomAccessFile, sharedLogHeader, this.ivHeader.ivFreeSpace);
    }

    private int findNextMessage(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, int n) throws IOException {
        int n2 = this.ivTrueFileSize - SharedLogHeader.DATA_AREA_OFFSET;
        byte[] byArray = new byte[1003];
        int n3 = n2 / 1000;
        int n4 = n2 % 1000;
        if (n4 < 3) {
            n4 += 1000;
            --n3;
        }
        int n5 = n;
        for (int i = n3; i > 0; --i) {
            this.fillBuffer(randomAccessFile, sharedLogHeader, n5, byArray);
            int n6 = this.findMessageInBuffer(randomAccessFile, sharedLogHeader, byArray, n5);
            if (n6 != -1) {
                return n6;
            }
            n5 = this.incrementAndWrapLocation(sharedLogHeader, n5, 1000);
        }
        byArray = new byte[n4];
        this.fillBuffer(randomAccessFile, sharedLogHeader, n5, byArray);
        return this.findMessageInBuffer(randomAccessFile, sharedLogHeader, byArray, n5);
    }

    private int findMessageInBuffer(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, byte[] byArray, int n) throws IOException {
        boolean bl = false;
        int n2 = -1;
        while (!bl) {
            if ((n2 = this.findFirstPatternInBuffer(byArray, SharedLogConstants.svEntryHeader, n2 + 1)) == -1) {
                return -1;
            }
            int n3 = this.incrementAndWrapLocation(sharedLogHeader, n, n2);
            if (!this.checkForMessage(randomAccessFile, sharedLogHeader, n3)) continue;
            return n3;
        }
        return -1;
    }

    private int findFirstPatternInBuffer(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray2.length;
        int n3 = byArray.length - n2;
        if (n3 < n) {
            return -1;
        }
        for (int i = n; i <= n3; ++i) {
            if (byArray[i] != byArray2[0]) continue;
            boolean bl = true;
            int n4 = i + 1;
            for (int j = 1; j < n2 && bl; ++j) {
                if (byArray[n4] != byArray2[j]) {
                    bl = false;
                }
                ++n4;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    private boolean checkForMessage(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, int n) throws IOException {
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "checkForMessage checking location " + Integer.toHexString(n));
        }
        if (!this.checkForPattern(randomAccessFile, sharedLogHeader, n, SharedLogConstants.svEntryHeader)) {
            if (this.tc.isEventEnabled()) {
                String string = Integer.toHexString(n);
                Tr.event(this.tc, "checkForMessage did not find a valid header at location " + string);
            }
            return false;
        }
        int n2 = this.incrementAndWrapLocation(sharedLogHeader, n, SharedLogConstants.svEntryHeader.length);
        int n3 = this.readBlockSize(randomAccessFile, sharedLogHeader, n2);
        if (n3 == 0) {
            if (this.tc.isEventEnabled()) {
                String string = Integer.toHexString(n2);
                Tr.event(this.tc, "checkForMessage found invalid blocksize at location " + string);
            }
            return false;
        }
        if (!this.checkForPattern(randomAccessFile, sharedLogHeader, n2 = this.incrementAndWrapLocation(sharedLogHeader, n2, 4 + n3), SharedLogConstants.svEntryTrailer)) {
            if (this.tc.isEventEnabled()) {
                String string = Integer.toHexString(n);
                Tr.event(this.tc, "checkForMessage message at location " + string + " is corrupted");
            }
            return false;
        }
        return true;
    }

    private void fillBuffer(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, int n, byte[] byArray) throws IOException {
        if (this.tc.isDebugEnabled()) {
            String string = Integer.toHexString(byArray.length);
            String string2 = Integer.toHexString(n);
            Tr.debug(this.tc, "fillBuffer - reading " + string + " bytes from " + string2);
        }
        randomAccessFile.seek(n);
        int n2 = byArray.length;
        if (this.ivTrueFileSize - n >= n2) {
            randomAccessFile.readFully(byArray, 0, n2);
        } else {
            String string;
            String string3;
            int n3 = this.ivTrueFileSize - n;
            int n4 = n2 - n3;
            if (this.tc.isDebugEnabled()) {
                string3 = Integer.toHexString(n3);
                string = Integer.toHexString(n);
                Tr.debug(this.tc, "fillBuffer - firstHalf reading " + string3 + " bytes from location " + string);
            }
            randomAccessFile.readFully(byArray, 0, n3);
            randomAccessFile.seek(SharedLogHeader.DATA_AREA_OFFSET);
            if (this.tc.isDebugEnabled()) {
                string3 = Integer.toHexString(n4);
                string = Integer.toHexString(SharedLogHeader.DATA_AREA_OFFSET);
                Tr.debug(this.tc, "fillBuffer - 2nd read " + string3 + " bytes from location " + string);
            }
            randomAccessFile.readFully(byArray, n3, n4);
        }
    }

    private boolean checkForPattern(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, int n, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[byArray.length];
        this.fillBuffer(randomAccessFile, sharedLogHeader, n, byArray2);
        int n2 = byArray.length;
        for (int i = n2 - 1; i >= 0; --i) {
            if (byArray2[i] == byArray[i]) continue;
            if (this.tc.isDebugEnabled()) {
                String string = RasHelper.byteArrayToHexString(byArray);
                String string2 = Integer.toHexString(n);
                String string3 = RasHelper.byteArrayToHexString(byArray2);
                Tr.debug(this.tc, "checkForPattern - checking for pattern " + string + " at location " + string2 + " failed, found pattern " + string3);
            }
            return false;
        }
        return true;
    }

    private synchronized int readBlockSize(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, int n) throws IOException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "readBlockSize", "reading blockSize from location " + Integer.toHexString(n));
        }
        int n2 = -1;
        this.fillBuffer(randomAccessFile, sharedLogHeader, n, this.ivBlockSizeBuffer);
        this.ivBlockSizeBais.reset();
        n2 = this.ivBlockSizeDis.readInt();
        if (n2 < 1 || n2 + 12 > sharedLogHeader.ivMaxSize) {
            n2 = 0;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "readBlockSize", "returning blockSize = " + Integer.toHexString(n2));
        }
        return n2;
    }

    private final int incrementAndWrapLocation(SharedLogHeader sharedLogHeader, int n, int n2) {
        int n3 = n + n2;
        if (n3 >= this.ivTrueFileSize) {
            return n3 - this.ivTrueFileSize + SharedLogHeader.DATA_AREA_OFFSET;
        }
        return n3;
    }

    private int countMessages(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader) throws Exception {
        int n = this.countPatternOccurrencesInFile(randomAccessFile, sharedLogHeader, SharedLogConstants.svEntryHeader);
        int n2 = this.countPatternOccurrencesInFile(randomAccessFile, sharedLogHeader, SharedLogConstants.svEntryTrailer);
        if (this.tc.isEventEnabled()) {
            Tr.event(this.tc, "countMessages counted " + n + " headers in the file");
            Tr.event(this.tc, "countMessages counted " + n2 + " trailers in the file");
        }
        if (n <= n2) {
            return n;
        }
        return n2;
    }

    private int countPatternOccurrencesInFile(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, byte[] byArray) throws IOException {
        int n = this.ivTrueFileSize - SharedLogHeader.DATA_AREA_OFFSET;
        int n2 = !sharedLogHeader.ivFileWrapped ? SharedLogHeader.DATA_AREA_OFFSET : sharedLogHeader.ivFreeSpace;
        int n3 = byArray.length;
        if (n < n3) {
            return 0;
        }
        int n4 = 1000;
        if (n3 >= 1000) {
            n4 = 3 * n3;
        }
        int n5 = n / n4;
        int n6 = n % n4;
        byte[] byArray2 = new byte[n4 + n3 - 1];
        if (n6 < n3) {
            n6 += n4;
            --n5;
        }
        int n7 = 0;
        for (int i = n5; i > 0; --i) {
            this.fillBuffer(randomAccessFile, sharedLogHeader, n2, byArray2);
            n7 += this.countPatternOccurrencesInBuffer(byArray2, byArray);
            n2 = this.incrementAndWrapLocation(sharedLogHeader, n2, n4);
        }
        if (n6 != 0) {
            byArray2 = new byte[n6];
            this.fillBuffer(randomAccessFile, sharedLogHeader, n2, byArray2);
            n7 += this.countPatternOccurrencesInBuffer(byArray2, byArray);
        }
        return n7;
    }

    private int countPatternOccurrencesInBuffer(byte[] byArray, byte[] byArray2) {
        int n = byArray2.length;
        int n2 = byArray.length - n;
        int n3 = 0;
        if (n2 < n3) {
            return 0;
        }
        int n4 = 0;
        for (int i = n3; i <= n2; ++i) {
            if (byArray[i] != byArray2[0]) continue;
            boolean bl = true;
            int n5 = i + 1;
            for (int j = 1; j < n && bl; ++j) {
                if (byArray[n5] != byArray2[j]) {
                    bl = false;
                }
                ++n5;
            }
            if (!bl) continue;
            ++n4;
        }
        return n4;
    }

    private String locateFile(String string) throws RasException {
        if (string == null) {
            throw new RasException("Null passed as the file name");
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            if (!RasHelper.fileExists(file)) {
                throw new RasException("File " + string + " does not exist");
            }
            return file.getPath();
        }
        file = new File(RasProperties.getDefaultLoggingDirectory() + File.separator + string);
        if (RasHelper.fileExists(file)) {
            return file.getPath();
        }
        file = new File("." + File.separator + string);
        if (RasHelper.fileExists(file)) {
            return file.getPath();
        }
        throw new RasException("File " + string + " does not exist");
    }

    private void copySharedLog(String string, boolean bl) throws RasException {
        File file = new File(string + ".lck");
        boolean bl2 = false;
        try {
            if (bl) {
                this.ivFile = this.copyLogFile(string);
            } else {
                SharedLogReader.acquireHostLock(file);
                bl2 = true;
                this.ivFile = this.copyLogFile(string);
                SharedLogReader.releaseHostLock(file);
                bl2 = false;
            }
        }
        catch (Throwable throwable) {
            if (bl2) {
                SharedLogReader.releaseHostLock(file);
            }
            throw new RasException("Exception copying shared log file", throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

