/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.SharedLogBase;
import com.ibm.ejs.ras.SharedLogConstants;
import com.ibm.ejs.ras.SharedLogHeader;
import com.ibm.ejs.ras.SharedLogLockException;
import com.ibm.ejs.ras.SharedLogReader;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceEventListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

class SharedLogWriter
extends SharedLogBase
implements TraceEventListener {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ejs$ras$SharedLogWriter == null ? (class$com$ibm$ejs$ras$SharedLogWriter = SharedLogWriter.class$("com.ibm.ejs.ras.SharedLogWriter")) : class$com$ibm$ejs$ras$SharedLogWriter, null, "com.ibm.ejs.resources.RasMessages");
    private static String svFqFileName = null;
    private static File svFile = null;
    private static String svFqLockFileName = null;
    private static File svLockFile = null;
    static int svFileLength;
    static int svMaxMessageSize;
    private static SharedLogWriter svSharedLogWriter;
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private boolean ivUsable;
    private boolean ivVerifyCompleted;
    private boolean ivRecovered;
    private Vector ivUnwrittenEvents;
    private long ivFirstErrorTime;
    static /* synthetic */ Class class$com$ibm$ejs$ras$SharedLogWriter;

    static synchronized SharedLogWriter getInstance() {
        if (svSharedLogWriter == null) {
            try {
                svSharedLogWriter = new SharedLogWriter();
            }
            catch (Throwable throwable) {
                svSharedLogWriter = null;
            }
        }
        return svSharedLogWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SharedLogWriter() throws RasException {
        block14: {
            this.ivUsable = false;
            this.ivVerifyCompleted = false;
            this.ivRecovered = false;
            this.ivUnwrittenEvents = null;
            this.ivFirstErrorTime = 0L;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SharedLogWriter - ctor");
            }
            svFqFileName = RasProperties.getActivityLogName();
            svFileLength = RasProperties.getActivityLogSize();
            svFqLockFileName = svFqFileName + ".lck";
            svLockFile = new File(svFqLockFileName);
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
            svMaxMessageSize = svFileLength - 4100;
            if (svMaxMessageSize > 100000) {
                svMaxMessageSize = 100000;
            }
            boolean bl = false;
            try {
                try {
                    SharedLogWriter.acquireHostLock(svLockFile);
                    bl = true;
                    this.ivUsable = true;
                    this.verifyLogFile(false);
                    this.ivVerifyCompleted = true;
                }
                catch (SharedLogLockException sharedLogLockException) {
                    Object var5_3 = null;
                    if (bl) {
                        SharedLogWriter.releaseHostLock(svLockFile);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
                        Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
                        Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
                        Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
                    }
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "SharedLogWriter - ctor");
                    return;
                }
                catch (RasException rasException) {
                    this.ivUsable = false;
                    Tr.error(tc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{svFqFileName, rasException});
                    throw rasException;
                }
                catch (IOException iOException) {
                    this.ivUsable = false;
                    rasException = new RasException(iOException);
                    Tr.error(tc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{svFqFileName, rasException});
                    throw rasException;
                }
                Object var5_2 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (bl) {
                    SharedLogWriter.releaseHostLock(svLockFile);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
                    Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
                    Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
                    Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
                }
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "SharedLogWriter - ctor");
                throw throwable;
            }
            SharedLogWriter.releaseHostLock(svLockFile);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
            Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
            Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
            Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "SharedLogWriter - ctor");
    }

    public void auditEvent(MessageEvent messageEvent) {
        this.logMessage(messageEvent);
    }

    public void warningEvent(MessageEvent messageEvent) {
        this.logMessage(messageEvent);
    }

    public void errorEvent(MessageEvent messageEvent) {
        this.logMessage(messageEvent);
    }

    public void fatalEvent(MessageEvent messageEvent) {
        this.logMessage(messageEvent);
    }

    public void serviceEvent(MessageEvent messageEvent) {
        this.logMessage(messageEvent);
    }

    public void debugEvent(TraceEvent traceEvent) {
    }

    public void dumpEvent(TraceEvent traceEvent) {
    }

    public void eventEvent(TraceEvent traceEvent) {
    }

    public void entryEvent(TraceEvent traceEvent) {
    }

    public void exitEvent(TraceEvent traceEvent) {
    }

    public void infoEvent(MessageEvent messageEvent) {
    }

    public void systemErrEvent(StreamEvent streamEvent) {
    }

    public void systemOutEvent(StreamEvent streamEvent) {
    }

    public void uncondTraceEvent(TraceEvent traceEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void logMessage(MessageEvent messageEvent) {
        block33: {
            boolean bl;
            byte[] byArray;
            RandomAccessFile randomAccessFile;
            block31: {
                SharedLogHeader sharedLogHeader;
                if (messageEvent == null) {
                    return;
                }
                if (!this.ivUsable && this.ivVerifyCompleted) {
                    return;
                }
                randomAccessFile = null;
                byArray = this.prepareEntry(messageEvent);
                if (byArray == null || byArray.length > svMaxMessageSize) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - message size is invalid", byArray);
                    }
                    return;
                }
                bl = false;
                SharedLogWriter.acquireHostLock(svLockFile);
                bl = true;
                if (!this.ivVerifyCompleted) {
                    this.ivUsable = true;
                    this.verifyLogFile(true);
                    this.ivVerifyCompleted = true;
                }
                randomAccessFile = this.createRandomAccessFile(svFqFileName, "rw");
                try {
                    sharedLogHeader = new SharedLogHeader(randomAccessFile);
                }
                catch (IOException iOException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - failed reading header for file, attempting recovery", iOException);
                    }
                    this.recoverFile(randomAccessFile);
                    this.ivRecovered = true;
                    sharedLogHeader = new SharedLogHeader(randomAccessFile);
                }
                this.writeEvent(randomAccessFile, sharedLogHeader, byArray);
                Object var10_9 = null;
                if (randomAccessFile == null) break block31;
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                SharedLogWriter.releaseHostLock(svLockFile);
            }
            break block33;
            {
                catch (SharedLogLockException sharedLogLockException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - caught SharedLogLockException", sharedLogLockException);
                    }
                    if (this.ivUnwrittenEvents == null) {
                        this.ivUnwrittenEvents = new Vector(10);
                        this.ivUnwrittenEvents.addElement(byArray);
                        this.ivFirstErrorTime = System.currentTimeMillis();
                    } else {
                        long l = System.currentTimeMillis();
                        if (l - this.ivFirstErrorTime < 300000L) {
                            this.ivUnwrittenEvents.addElement(byArray);
                        } else {
                            this.ivUsable = false;
                            Tr.removeTraceEventListener(this);
                            Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", sharedLogLockException);
                        }
                    }
                    Object var10_10 = null;
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl) {
                        SharedLogWriter.releaseHostLock(svLockFile);
                    }
                    break block33;
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - caught exception", throwable);
                    }
                    this.ivUsable = false;
                    Tr.removeTraceEventListener(this);
                    Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", throwable);
                    Object var10_11 = null;
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl) {
                        SharedLogWriter.releaseHostLock(svLockFile);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl) {
                    SharedLogWriter.releaseHostLock(svLockFile);
                }
                throw throwable;
            }
        }
    }

    private void writeEvent(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, byte[] byArray) throws IOException {
        if (this.ivUnwrittenEvents != null) {
            int n = this.ivUnwrittenEvents.size();
            for (int i = 0; i < n; ++i) {
                byte[] byArray2 = (byte[])this.ivUnwrittenEvents.elementAt(i);
                this.writeDataAndHeader(randomAccessFile, sharedLogHeader, byArray2);
            }
            this.ivUnwrittenEvents = null;
        }
        this.writeDataAndHeader(randomAccessFile, sharedLogHeader, byArray);
    }

    private byte[] prepareEntry(MessageEvent messageEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare entry");
        }
        try {
            this.baos.reset();
            messageEvent.writeToStream(this.dos);
            byte[] byArray = this.baos.toByteArray();
            this.baos.reset();
            this.dos.write(SharedLogConstants.svEntryHeader, 0, SharedLogConstants.svEntryHeader.length);
            this.dos.writeInt(byArray.length);
            this.dos.write(byArray, 0, byArray.length);
            this.dos.write(SharedLogConstants.svEntryTrailer, 0, SharedLogConstants.svEntryTrailer.length);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare entry");
            }
            return this.baos.toByteArray();
        }
        catch (IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare entry", iOException);
            }
            return null;
        }
    }

    private void writeDataAndHeader(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, byte[] byArray) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeDataAndHeader");
        }
        int n2 = sharedLogHeader.ivFreeSpace;
        int n3 = byArray.length;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - writing " + n3 + " bytes to  location " + n2);
        }
        if (n2 + n3 <= sharedLogHeader.ivMaxSize) {
            randomAccessFile.seek(n2);
            randomAccessFile.write(byArray);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - data wraps");
            }
            n = sharedLogHeader.ivMaxSize - n2;
            int n4 = n3 - n;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray, n, byArray3, 0, n4);
            randomAccessFile.seek(n2);
            randomAccessFile.write(byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - firstHalf writing " + n + " bytes to  location " + n2);
            }
            sharedLogHeader.ivFileWrapped = true;
            randomAccessFile.seek(SharedLogHeader.DATA_AREA_OFFSET);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - 2ndHalf writing " + n4 + " bytes to  location " + SharedLogHeader.DATA_AREA_OFFSET);
            }
            randomAccessFile.write(byArray3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - write complete, filePointer = " + randomAccessFile.getFilePointer());
        }
        if ((n = (int)randomAccessFile.getFilePointer()) == sharedLogHeader.ivMaxSize) {
            sharedLogHeader.ivFreeSpace = SharedLogHeader.DATA_AREA_OFFSET;
            sharedLogHeader.ivFileWrapped = true;
        } else {
            sharedLogHeader.ivFreeSpace = n;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - freeSpace ptr = " + sharedLogHeader.ivFreeSpace);
        }
        sharedLogHeader.writeHeader(randomAccessFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeDataAndHeader");
        }
    }

    private void verifyLogFile(boolean bl) throws IOException, RasException {
        RandomAccessFile randomAccessFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyLogFile");
        }
        try {
            randomAccessFile = this.createRandomAccessFile(svFqFileName, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "verifyLogFile caught FileNotFound Exception", fileNotFoundException);
            }
            throw new RasException("unable to access file " + svFqFileName, fileNotFoundException);
        }
        if (randomAccessFile.length() == 0L) {
            SharedLogHeader sharedLogHeader = new SharedLogHeader(randomAccessFile, svFileLength);
        } else {
            this.processExistingFile(randomAccessFile, bl);
        }
        randomAccessFile.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyLogFile");
        }
    }

    private void processExistingFile(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processExistingFile");
        }
        SharedLogHeader sharedLogHeader = null;
        try {
            sharedLogHeader = new SharedLogHeader(randomAccessFile);
        }
        catch (IOException iOException) {
            this.recoverFile(randomAccessFile);
            this.ivRecovered = true;
            sharedLogHeader = new SharedLogHeader(randomAccessFile);
        }
        if (sharedLogHeader.ivMaxSize != svFileLength) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processExistingFile - changing size of log file");
            }
            try {
                SharedLogReader sharedLogReader = new SharedLogReader(svFqFileName, true);
                randomAccessFile.setLength(svFileLength);
                sharedLogHeader.ivMaxSize = svFileLength;
                sharedLogHeader.ivFreeSpace = SharedLogHeader.DATA_AREA_OFFSET;
                sharedLogHeader.ivFileWrapped = false;
                sharedLogHeader.writeHeader(randomAccessFile);
                boolean bl2 = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processExistingFile - rewriting existing messages");
                }
                do {
                    MessageEvent messageEvent;
                    if ((messageEvent = sharedLogReader.getNextMessage()) == null) {
                        bl2 = true;
                        continue;
                    }
                    this.logMessage(messageEvent);
                } while (!bl2);
            }
            catch (RasException rasException) {
                if (!bl) {
                    Tr.warning(tc, "MSG_SHARED_LOG_CHANGE_SIZE_FAILED", rasException);
                }
                Tr.removeTraceEventListener(this);
                Tr.warning(tc, "MSG_SHARED_LOG_CHANGE_SIZE_FAILED", rasException);
                Tr.addTraceEventListener(this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processExistingFile");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recoverFile(RandomAccessFile randomAccessFile) throws IOException {
        block13: {
            block12: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "recoverFile");
                }
                try {
                    try {
                        if (randomAccessFile.length() == 0L) {
                            SharedLogHeader sharedLogHeader = new SharedLogHeader(randomAccessFile, svFileLength);
                            Object var8_5 = null;
                            break block12;
                        }
                        if (this.ivRecovered) {
                            throw new IOException("SharedLogWriter.recoverFile - multiple attempts not allowed");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "recoverFile - recovering existing file");
                        }
                        Vector vector = this.readCorruptedFile(randomAccessFile);
                        randomAccessFile.setLength(0L);
                        SharedLogHeader sharedLogHeader = new SharedLogHeader(randomAccessFile, svFileLength);
                        if (vector != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "recoverFile - writing " + vector.size() + " messages back to the file");
                            }
                            Enumeration enumeration = vector.elements();
                            while (enumeration.hasMoreElements()) {
                                MessageEvent messageEvent = (MessageEvent)enumeration.nextElement();
                                byte[] byArray = this.prepareEntry(messageEvent);
                                if (byArray == null) continue;
                                this.writeDataAndHeader(randomAccessFile, sharedLogHeader, byArray);
                            }
                        }
                        break block13;
                    }
                    catch (IOException iOException) {
                        if (!tc.isDebugEnabled()) throw iOException;
                        Tr.debug(tc, "recoverFile - Exception occurred", iOException);
                        throw iOException;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit(tc, "recoverFile");
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "recoverFile");
            return;
        }
        Object var8_6 = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "recoverFile");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        svMaxMessageSize = 100000;
        svSharedLogWriter = null;
    }
}

