/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Vector;

abstract class SystemStream
extends PrintStream {
    private static final String svTrue = "true";
    private static final String svFalse = "false";
    PrintStream ivStream;
    private boolean ivSuppress;
    private boolean ivFormatted;
    String ivFormatType;
    private boolean ivWritePending = false;
    private StreamEvent ivEvent = null;
    private Vector ivCache;
    private int ivCacheSize = 0;
    private static final int svMaxCacheSize = 8192;
    StringBuffer ivBuffer;
    DateFormat ivFormatter;
    Date ivDate;
    FieldPosition ivFieldPos;

    SystemStream(OutputStream outputStream, PrintStream printStream, boolean bl, boolean bl2, String string) {
        super(outputStream);
        this.ivStream = printStream;
        this.ivFormatted = bl2;
        this.ivFormatType = string;
        this.ivSuppress = bl;
        this.ivBuffer = new StringBuffer();
        this.ivFormatter = RasHelper.getBasicDateFormatter();
        this.ivDate = new Date();
        this.ivFieldPos = new FieldPosition(0);
    }

    abstract StreamEvent createEvent(String var1);

    abstract StreamEvent createEvent(byte[] var1);

    abstract StreamEvent createEvent(char[] var1);

    abstract void dispatchEvent(StreamEvent var1);

    public void flush() {
        this.ivStream.flush();
    }

    public void close() {
        this.ivStream.close();
    }

    public boolean checkError() {
        return this.ivStream.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) {
        Object object;
        if (this.ivSuppress) {
            return;
        }
        byte[] byArray = new byte[]{(byte)n};
        if (ComponentManager.svTraceEnabled && (object = this.cacheTraceData(byArray)) != null) {
            this.dispatchEvent((StreamEvent)object);
        }
        if (!this.ivFormatted) {
            this.ivStream.write(n);
        } else {
            object = this;
            synchronized (object) {
                if (this.ivWritePending) {
                    this.ivStream.write(n);
                } else {
                    StreamEvent streamEvent = this.createEvent(byArray);
                    streamEvent.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                    this.ivWritePending = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) {
        block15: {
            Object object;
            if (this.ivSuppress) {
                return;
            }
            if (n2 == 0) {
                return;
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            int n3 = byArray.length;
            if (n > n3 || n2 > n3 || n + n2 > n3) {
                throw new IndexOutOfBoundsException();
            }
            if (n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (ComponentManager.svTraceEnabled && (object = this.cacheTraceData(byArray2)) != null) {
                this.dispatchEvent((StreamEvent)object);
            }
            try {
                if (!this.ivFormatted) {
                    this.ivStream.write(byArray2);
                    break block15;
                }
                object = this;
                synchronized (object) {
                    if (this.ivWritePending) {
                        this.ivStream.write(byArray2);
                    } else {
                        StreamEvent streamEvent = this.createEvent(byArray2);
                        streamEvent.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                    }
                }
                this.ivWritePending = byArray2 == null || byArray2.length <= 0 || byArray2[byArray2.length - 1] != 10;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void print(boolean bl) {
        if (this.ivSuppress) {
            return;
        }
        if (!bl) {
            this.doPrint(svFalse);
        } else {
            this.doPrint(svTrue);
        }
    }

    public void print(char c) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(c);
        this.doPrint(string);
    }

    public void print(int n) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(n);
        this.doPrint(string);
    }

    public void print(long l) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(l);
        this.doPrint(string);
    }

    public void print(float f) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(f);
        this.doPrint(string);
    }

    public void print(double d) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(d);
        this.doPrint(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(char[] cArray) {
        Object object;
        if (this.ivSuppress) {
            return;
        }
        if (ComponentManager.svTraceEnabled && (object = this.cacheTraceData(cArray)) != null) {
            this.dispatchEvent((StreamEvent)object);
        }
        if (!this.ivFormatted) {
            this.ivStream.print(cArray);
        } else {
            object = this;
            synchronized (object) {
                if (this.ivWritePending) {
                    this.ivStream.print(cArray);
                } else {
                    StreamEvent streamEvent = this.createEvent(cArray);
                    streamEvent.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = cArray == null || cArray.length <= 0 || cArray[cArray.length - 1] != '\n';
            }
        }
    }

    public void print(String string) {
        if (this.ivSuppress) {
            return;
        }
        this.doPrint(string);
    }

    public void print(Object object) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(object);
        this.doPrint(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        if (this.ivSuppress) {
            return;
        }
        String string = null;
        StreamEvent streamEvent = null;
        if (ComponentManager.svTraceEnabled) {
            streamEvent = this.getTraceData(string);
            this.dispatchEvent(streamEvent);
        }
        if (!this.ivFormatted) {
            this.ivStream.println();
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.println();
                } else {
                    streamEvent = this.createEvent(string);
                    streamEvent.writeSelfToStream(this.ivStream, this.ivFormatType, true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = false;
            }
        }
    }

    public void println(boolean bl) {
        if (this.ivSuppress) {
            return;
        }
        if (bl) {
            this.doPrintLine(svTrue);
        } else {
            this.doPrintLine(svFalse);
        }
    }

    public void println(char c) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(c);
        this.doPrintLine(string);
    }

    public void println(int n) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(n);
        this.doPrintLine(string);
    }

    public void println(long l) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(l);
        this.doPrintLine(string);
    }

    public void println(float f) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(f);
        this.doPrintLine(string);
    }

    public void println(double d) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(d);
        this.doPrintLine(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        if (this.ivSuppress) {
            return;
        }
        StreamEvent streamEvent = null;
        if (ComponentManager.svTraceEnabled) {
            streamEvent = this.getTraceData(cArray);
            this.dispatchEvent(streamEvent);
        }
        if (!this.ivFormatted) {
            this.ivStream.println(cArray);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.println(cArray);
                } else {
                    streamEvent = this.createEvent(cArray);
                    streamEvent.writeSelfToStream(this.ivStream, this.ivFormatType, true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = false;
            }
        }
    }

    public void println(String string) {
        if (this.ivSuppress) {
            return;
        }
        this.doPrintLine(string);
    }

    public void println(Object object) {
        if (this.ivSuppress) {
            return;
        }
        String string = String.valueOf(object);
        this.doPrintLine(string);
    }

    void writeWebSphereEvent(String string) {
        if (this.ivWritePending) {
            this.ivStream.println();
        }
        this.ivStream.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doPrint(String string) {
        Object object;
        if (ComponentManager.svTraceEnabled && (object = this.cacheTraceData(string)) != null) {
            this.dispatchEvent((StreamEvent)object);
        }
        if (!this.ivFormatted) {
            this.ivStream.print(string);
        } else {
            object = this;
            synchronized (object) {
                if (this.ivWritePending) {
                    this.ivStream.print(string);
                } else {
                    StreamEvent streamEvent = this.createEvent(string);
                    streamEvent.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = string == null || string.lastIndexOf(10) != string.length() - 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doPrintLine(String string) {
        Object object;
        if (ComponentManager.svTraceEnabled) {
            object = this.getTraceData(string);
            this.dispatchEvent((StreamEvent)object);
        }
        if (!this.ivFormatted) {
            this.ivStream.println(string);
        } else {
            object = this;
            synchronized (object) {
                if (this.ivWritePending) {
                    this.ivStream.println(string);
                } else {
                    StreamEvent streamEvent = this.createEvent(string);
                    streamEvent.writeSelfToStream(this.ivStream, this.ivFormatType, true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = false;
            }
        }
    }

    private synchronized StreamEvent cacheTraceData(String string) {
        int n;
        int n2 = n = string == null ? 8 : string.length() * 2;
        if (this.ivCacheSize + n > 8192) {
            return this.getTraceData(string);
        }
        if (this.ivEvent == null) {
            this.ivEvent = this.createEvent(string);
        } else {
            if (this.ivCache == null) {
                this.ivCache = new Vector();
            }
            this.ivCache.addElement(string);
        }
        this.ivCacheSize += n;
        return null;
    }

    private synchronized StreamEvent cacheTraceData(byte[] byArray) {
        int n;
        int n2 = n = byArray == null ? 0 : byArray.length;
        if (this.ivCacheSize + n > 8192) {
            return this.getTraceData(byArray);
        }
        if (this.ivEvent == null) {
            this.ivEvent = this.createEvent(byArray);
        } else {
            if (this.ivCache == null) {
                this.ivCache = new Vector();
            }
            this.ivCache.addElement(byArray);
        }
        this.ivCacheSize += n;
        return null;
    }

    private synchronized StreamEvent cacheTraceData(char[] cArray) {
        int n;
        int n2 = n = cArray == null ? 0 : cArray.length;
        if (this.ivCacheSize + n > 8192) {
            return this.getTraceData(cArray);
        }
        if (this.ivEvent == null) {
            this.ivEvent = this.createEvent(cArray);
        } else {
            if (this.ivCache == null) {
                this.ivCache = new Vector();
            }
            this.ivCache.addElement(cArray);
        }
        this.ivCacheSize += n;
        return null;
    }

    private synchronized StreamEvent getTraceData(String string) {
        if (this.ivEvent == null) {
            return this.createEvent(string);
        }
        StreamEvent streamEvent = this.ivEvent;
        if (this.ivCache == null) {
            this.ivCache = new Vector();
        }
        this.ivCache.addElement(string);
        streamEvent.addDataCache(this.ivCache);
        this.ivEvent = null;
        this.ivCache = null;
        this.ivCacheSize = 0;
        return streamEvent;
    }

    private synchronized StreamEvent getTraceData(byte[] byArray) {
        if (this.ivEvent == null) {
            return this.createEvent(byArray);
        }
        StreamEvent streamEvent = this.ivEvent;
        if (this.ivCache == null) {
            this.ivCache = new Vector();
        }
        this.ivCache.addElement(byArray);
        streamEvent.addDataCache(this.ivCache);
        this.ivEvent = null;
        this.ivCache = null;
        this.ivCacheSize = 0;
        return streamEvent;
    }

    private synchronized StreamEvent getTraceData(char[] cArray) {
        if (this.ivEvent == null) {
            return this.createEvent(cArray);
        }
        StreamEvent streamEvent = this.ivEvent;
        if (this.ivCache == null) {
            this.ivCache = new Vector();
        }
        this.ivCache.addElement(cArray);
        streamEvent.addDataCache(this.ivCache);
        this.ivEvent = null;
        this.ivCache = null;
        this.ivCacheSize = 0;
        return streamEvent;
    }
}

