/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceEnableEvent;

public class TraceElement {
    String ivName;
    boolean ivDebugEnabled;
    boolean ivEventEnabled;
    boolean ivEntryEnabled;

    TraceElement(String string) {
        this.ivName = string;
        this.ivDebugEnabled = false;
        this.ivEventEnabled = false;
        this.ivEntryEnabled = false;
    }

    public final String getName() {
        return this.ivName;
    }

    public final boolean isDebugEnabled() {
        return this.ivDebugEnabled;
    }

    public final boolean isEventEnabled() {
        return this.ivEventEnabled;
    }

    public final boolean isEntryEnabled() {
        return this.ivEntryEnabled;
    }

    String getTraceSpecification() {
        StringBuffer stringBuffer = new StringBuffer(this.ivName);
        if (this.ivDebugEnabled && this.ivEventEnabled && this.ivEntryEnabled) {
            stringBuffer.append("=all=enabled");
            return new String(stringBuffer);
        }
        if (!(this.ivDebugEnabled || this.ivEventEnabled || this.ivEntryEnabled)) {
            stringBuffer.append("=all=disabled");
            return new String(stringBuffer);
        }
        stringBuffer.append(this.ivDebugEnabled ? "=debug=enabled" : "=debug=disabled");
        stringBuffer.append(this.ivEventEnabled ? ",event=enabled" : ",event=disabled");
        stringBuffer.append(this.ivEntryEnabled ? ",entryExit=enabled" : ",entryExit=disabled");
        return new String(stringBuffer);
    }

    String getStartsWith(String string, int n) {
        int n2 = string.length();
        String string2 = "";
        if (this.ivName.startsWith(string)) {
            String string3 = this.ivName.substring(n2);
            if (string3.startsWith(".")) {
                string3 = string3.substring(1);
            }
            String[] stringArray = RasHelper.split(string3, 46);
            StringBuffer stringBuffer = new StringBuffer(string3.length());
            int n3 = stringArray.length;
            for (int i = n; i < n3 - 1; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append('.');
            }
            if (n < n3) {
                stringBuffer.append(stringArray[n3 - 1]);
            }
            string2 = new String(stringBuffer);
        }
        return string2;
    }

    void applyTraceEnableEvent(TraceEnableEvent traceEnableEvent) {
        boolean bl = traceEnableEvent.enabled();
        switch (traceEnableEvent.getType()) {
            case 0: {
                this.ivDebugEnabled = bl;
                this.ivEventEnabled = bl;
                this.ivEntryEnabled = bl;
                break;
            }
            case 1: {
                this.ivDebugEnabled = bl;
                break;
            }
            case 3: {
                this.ivEventEnabled = bl;
                break;
            }
            case 2: {
                this.ivEntryEnabled = bl;
            }
        }
    }
}

