/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceEventGenerator;
import com.ibm.ejs.ras.TraceEventListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

class TraceEventGeneratorImpl
implements TraceEventGenerator {
    private Vector listeners = new Vector();
    private TraceEventListener[] svEventListeners = null;

    TraceEventGeneratorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTraceEventListener(TraceEventListener traceEventListener, boolean bl) {
        if (traceEventListener != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                if (bl) {
                    this.listeners.insertElementAt(traceEventListener, 0);
                } else {
                    this.listeners.addElement(traceEventListener);
                }
                this.svEventListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTraceEventListener(TraceEventListener traceEventListener) {
        if (traceEventListener != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.removeElement(traceEventListener);
                this.svEventListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceTraceEventListener(TraceEventListener traceEventListener, TraceEventListener traceEventListener2) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (traceEventListener2 != null) {
                this.listeners.removeElement(traceEventListener2);
            }
            if (traceEventListener != null) {
                this.listeners.addElement(traceEventListener);
            }
            this.svEventListeners = null;
        }
    }

    public void fireMessageEvent(int n, TraceComponent traceComponent, String string, String string2, Object object) {
        MessageEvent messageEvent = new MessageEvent(n, traceComponent, null, string2, object);
        this.fireMessageEvent(messageEvent);
    }

    public void fireTraceEvent(int n, TraceComponent traceComponent, String string, String string2, Object object) {
        TraceEvent traceEvent = new TraceEvent(n, traceComponent, null, string2, object);
        this.fireTraceEvent(traceEvent);
    }

    public void fireRasEvent(RasEvent rasEvent) {
        if (rasEvent == null) {
            return;
        }
        if (rasEvent instanceof MessageEvent) {
            MessageEvent messageEvent = (MessageEvent)rasEvent;
            if (this.messageTypeEnabled(rasEvent.ivType)) {
                this.fireMessageEvent(messageEvent);
            }
        } else if (rasEvent instanceof TraceEvent) {
            TraceEvent traceEvent = (TraceEvent)rasEvent;
            this.fireTraceEvent(traceEvent);
        } else {
            StreamEvent streamEvent = (StreamEvent)rasEvent;
            this.fireStreamEvent(streamEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageEvent(MessageEvent messageEvent) {
        TraceEventListener[] traceEventListenerArray;
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.svEventListeners == null) {
                this.svEventListeners = new TraceEventListener[this.listeners.size()];
                this.listeners.copyInto(this.svEventListeners);
            }
            traceEventListenerArray = this.svEventListeners;
        }
        block13: for (int i = traceEventListenerArray.length - 1; i >= 0; --i) {
            switch (messageEvent.ivType) {
                case 11: {
                    traceEventListenerArray[i].infoEvent(messageEvent);
                    continue block13;
                }
                case 1: {
                    traceEventListenerArray[i].auditEvent(messageEvent);
                    continue block13;
                }
                case 9: {
                    traceEventListenerArray[i].serviceEvent(messageEvent);
                    continue block13;
                }
                case 10: {
                    traceEventListenerArray[i].warningEvent(messageEvent);
                    continue block13;
                }
                case 4: {
                    traceEventListenerArray[i].errorEvent(messageEvent);
                    continue block13;
                }
                case 8: {
                    traceEventListenerArray[i].fatalEvent(messageEvent);
                    if (!ComponentManager.svTraceEnabled) continue block13;
                    String string = null;
                    try {
                        string = RasProperties.getDefaultLoggingDirectory() + File.separator;
                    }
                    catch (RasException rasException) {
                        string = "." + File.separator;
                    }
                    String string2 = null;
                    int n = RasHelper.getServerName().lastIndexOf(92);
                    string2 = n != -1 ? RasHelper.getServerName().substring(n + 1) : RasHelper.getServerName();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
                    Date date = new Date(messageEvent.ivTimeStamp);
                    String string3 = simpleDateFormat.format(date);
                    String string4 = string + string2 + "FatalError" + string3 + ".log";
                    ManagerAdmin.dumpRingBuffer(string4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTraceEvent(TraceEvent traceEvent) {
        TraceEventListener[] traceEventListenerArray;
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.svEventListeners == null) {
                this.svEventListeners = new TraceEventListener[this.listeners.size()];
                this.listeners.copyInto(this.svEventListeners);
            }
            traceEventListenerArray = this.svEventListeners;
        }
        block11: for (int i = traceEventListenerArray.length - 1; i >= 0; --i) {
            switch (traceEvent.ivType) {
                case 2: {
                    traceEventListenerArray[i].debugEvent(traceEvent);
                    continue block11;
                }
                case 3: {
                    traceEventListenerArray[i].dumpEvent(traceEvent);
                    continue block11;
                }
                case 5: {
                    traceEventListenerArray[i].eventEvent(traceEvent);
                    continue block11;
                }
                case 6: {
                    traceEventListenerArray[i].entryEvent(traceEvent);
                    continue block11;
                }
                case 7: {
                    traceEventListenerArray[i].exitEvent(traceEvent);
                    continue block11;
                }
                case 12: {
                    traceEventListenerArray[i].uncondTraceEvent(traceEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStreamEvent(StreamEvent streamEvent) {
        TraceEventListener[] traceEventListenerArray;
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.svEventListeners == null) {
                this.svEventListeners = new TraceEventListener[this.listeners.size()];
                this.listeners.copyInto(this.svEventListeners);
            }
            traceEventListenerArray = this.svEventListeners;
        }
        block7: for (int i = traceEventListenerArray.length - 1; i >= 0; --i) {
            switch (streamEvent.ivType) {
                case 13: {
                    traceEventListenerArray[i].systemOutEvent(streamEvent);
                    continue block7;
                }
                case 14: {
                    traceEventListenerArray[i].systemErrEvent(streamEvent);
                }
            }
        }
    }

    private boolean messageTypeEnabled(int n) {
        if (n == 1) {
            return RasProperties.svFilterMessageLevel >= RasProperties.Audit;
        }
        if (n == 10) {
            return RasProperties.svFilterMessageLevel >= RasProperties.Warning;
        }
        return true;
    }
}

