/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceEventListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;

class TraceLogger
implements TraceEventListener,
LogRolloverListener {
    private boolean ivBasicFormat;
    OutputStream ivOs;
    PrintWriter ivOut;
    protected StringBuffer ivBuffer = new StringBuffer();
    protected DateFormat ivFormatter;
    protected Date ivDate = new Date();
    protected FieldPosition ivFieldPos = new FieldPosition(0);

    TraceLogger(OutputStream outputStream) {
        this.ivOs = outputStream;
        this.ivOut = new PrintWriter(outputStream, true);
    }

    TraceLogger(OutputStream outputStream, boolean bl) {
        this(outputStream);
        this.ivFormatter = RasHelper.getBasicDateFormatter();
        this.ivBasicFormat = bl;
    }

    public synchronized void logRolled() {
        this.printHeader();
    }

    public void auditEvent(MessageEvent messageEvent) {
        this.logMessage(messageEvent);
    }

    public void debugEvent(TraceEvent traceEvent) {
        this.logTrace(traceEvent);
    }

    public void dumpEvent(TraceEvent traceEvent) {
        this.logTrace(traceEvent);
    }

    public void errorEvent(MessageEvent messageEvent) {
        this.logMessage(messageEvent);
    }

    public void eventEvent(TraceEvent traceEvent) {
        this.logTrace(traceEvent);
    }

    public void entryEvent(TraceEvent traceEvent) {
        this.logTrace(traceEvent);
    }

    public void exitEvent(TraceEvent traceEvent) {
        this.logTrace(traceEvent);
    }

    public void fatalEvent(MessageEvent messageEvent) {
        this.logMessage(messageEvent);
        Throwable throwable = new Throwable();
        throwable.printStackTrace(this.ivOut);
    }

    public void infoEvent(MessageEvent messageEvent) {
        this.logMessage(messageEvent);
    }

    public void serviceEvent(MessageEvent messageEvent) {
    }

    public void systemErrEvent(StreamEvent streamEvent) {
        this.logSystemStream(streamEvent);
    }

    public void systemOutEvent(StreamEvent streamEvent) {
        this.logSystemStream(streamEvent);
    }

    public void uncondTraceEvent(TraceEvent traceEvent) {
        this.logTrace(traceEvent);
    }

    public void warningEvent(MessageEvent messageEvent) {
        this.logMessage(messageEvent);
    }

    synchronized void logMessage(MessageEvent messageEvent) {
        if (messageEvent == null) {
            return;
        }
        if (this.ivBasicFormat) {
            this.ivOut.println(messageEvent.formatBasic(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos));
        } else {
            this.ivOut.println(messageEvent.formatAdvanced(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos));
        }
    }

    synchronized void logTrace(TraceEvent traceEvent) {
        if (traceEvent == null) {
            return;
        }
        if (this.ivBasicFormat) {
            this.ivOut.println(traceEvent.formatBasic(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos));
        } else {
            this.ivOut.println(traceEvent.formatAdvanced(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos));
        }
    }

    synchronized void logSystemStream(StreamEvent streamEvent) {
        if (streamEvent == null) {
            return;
        }
        if (this.ivBasicFormat) {
            streamEvent.writeSelfToStream(this.ivOut, "basic", true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
        } else {
            streamEvent.writeSelfToStream(this.ivOut, "advanced", true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
        }
    }

    synchronized void printHeader() {
        String string;
        String string2 = "************ Start Display Current Environment ************";
        String string3 = "************* End Display Current Environment *************";
        String string4 = "WebSphere {0} running with process name {1} and process id {2}";
        String string5 = "Host Operating System is {0}, version {1}";
        String string6 = "Java version = {0}, Java Compiler = {1}, Java VM name = {2}";
        String string7 = "was.install.root = {0}";
        String string8 = "user.install.root = {0}";
        String string9 = "Java Home = {0}";
        String string10 = "ws.ext.dirs = {0}";
        String string11 = "Classpath = {0}";
        String string12 = "Java Library path = {0}";
        String string13 = "Current trace specification = {0}";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println(string2);
        String string14 = RasHelper.getVersionId();
        if (string14 != null && !string14.equals("")) {
            printWriter.println(MessageFormat.format(string4, string14, RasHelper.getServerName(), RasHelper.getProcessId()));
        }
        if ((string = RasHelper.getSystemProperty("java.fullversion")) == null) {
            string = RasHelper.getSystemProperty("java.version");
        }
        String string15 = RasHelper.getSystemProperty("os.name");
        String string16 = RasHelper.getSystemProperty("os.version");
        printWriter.println(MessageFormat.format(string5, string15, string16));
        string15 = RasHelper.getSystemProperty("java.compiler");
        string16 = RasHelper.getSystemProperty("java.vm.name");
        printWriter.println(MessageFormat.format(string6, string, string15, string16));
        printWriter.println(MessageFormat.format(string7, RasHelper.getSystemProperty("was.install.root")));
        printWriter.println(MessageFormat.format(string8, RasHelper.getSystemProperty("user.install.root")));
        printWriter.println(MessageFormat.format(string9, RasHelper.getSystemProperty("java.home")));
        printWriter.println(MessageFormat.format(string10, RasHelper.getSystemProperty("ws.ext.dirs")));
        printWriter.println(MessageFormat.format(string11, RasHelper.getSystemProperty("java.class.path")));
        printWriter.println(MessageFormat.format(string12, RasHelper.getSystemProperty("java.library.path")));
        printWriter.println(MessageFormat.format(string13, ManagerAdmin.getTraceSpecification()));
        printWriter.println(string3);
        printWriter.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            this.ivOs.write(byArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

