/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASMessageCatalog;
import com.ibm.ras.RASMessageEvent;
import com.ibm.ras.RASMessageFormatter;
import com.ibm.ras.RASUtil;
import java.util.MissingResourceException;

public class RASEnhancedMessageFormatter
extends RASMessageFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 4777919917975263160L;
    private static final String SPACE = "  ";
    private transient String date = null;
    private transient String className = null;
    private transient String methodName = null;
    private transient String org = null;
    private transient String product = null;
    private transient String comp = null;
    private transient String server = null;
    private transient String client = null;

    public String format(RASIEvent rASIEvent) {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (this.date == null) {
            try {
                RASMessageCatalog rASMessageCatalog = new RASMessageCatalog("com.ibm.ras.RASMsgs", this.getLocale());
                this.date = rASMessageCatalog.getMessage("DATE");
                this.className = rASMessageCatalog.getMessage("CLASS_NAME");
                this.methodName = rASMessageCatalog.getMessage("METHOD_NAME");
                this.org = rASMessageCatalog.getMessage("ORGANIZATION");
                this.product = rASMessageCatalog.getMessage("PRODUCT");
                this.comp = rASMessageCatalog.getMessage("COMPONENT");
                this.server = rASMessageCatalog.getMessage("SERVER");
                this.client = rASMessageCatalog.getMessage("CLIENT");
            }
            catch (MissingResourceException missingResourceException) {
                this.date = "Date:";
                this.className = "Class:";
                this.methodName = "Method:";
                this.org = "Organization:";
                this.product = "Product:";
                this.comp = "Component:";
                this.server = "Server:";
                this.client = "Client:";
            }
            int n = this.date.length();
            if (this.className.length() > n) {
                n = this.className.length();
            }
            if (this.methodName.length() > n) {
                n = this.methodName.length();
            }
            if (this.org.length() > n) {
                n = this.org.length();
            }
            if (this.product.length() > n) {
                n = this.product.length();
            }
            if (this.comp.length() > n) {
                n = this.comp.length();
            }
            if (this.server.length() > n) {
                n = this.server.length();
            }
            if (this.client.length() > n) {
                n = this.client.length();
            }
            this.date = RASUtil.left(this.date, n);
            this.className = RASUtil.left(this.className, n);
            this.methodName = RASUtil.left(this.methodName, n);
            this.org = RASUtil.left(this.org, n);
            this.product = RASUtil.left(this.product, n);
            this.comp = RASUtil.left(this.comp, n);
            this.server = RASUtil.left(this.server, n);
            this.client = RASUtil.left(this.client, n);
        }
        RASMessageEvent rASMessageEvent = (RASMessageEvent)rASIEvent;
        long l = rASMessageEvent.getTimeStamp();
        stringBuffer.append(this.date + SPACE + this.getDate(l) + SPACE + this.getTime(l) + this.lineSep);
        Object object = rASMessageEvent.getAttribute("loggingClass");
        if (object != null) {
            stringBuffer.append(this.className + SPACE + object + this.lineSep);
        }
        if ((object = rASMessageEvent.getAttribute("loggingMethod")) != null) {
            stringBuffer.append(this.methodName + SPACE + object + this.lineSep);
        }
        if ((object = rASMessageEvent.getAttribute("organization")) != null) {
            stringBuffer.append(this.org + SPACE + object + this.lineSep);
        }
        if ((object = rASMessageEvent.getAttribute("product")) != null) {
            stringBuffer.append(this.product + SPACE + object + this.lineSep);
        }
        if ((object = rASMessageEvent.getAttribute("component")) != null) {
            stringBuffer.append(this.comp + SPACE + object + this.lineSep);
        }
        if ((object = rASMessageEvent.getAttribute("server")) != null) {
            stringBuffer.append(this.server + SPACE + object + this.lineSep);
        }
        if ((object = rASMessageEvent.getAttribute("client")) != null) {
            stringBuffer.append(this.client + SPACE + object + this.lineSep);
        }
        stringBuffer.append(SPACE + this.getText(rASMessageEvent));
        return stringBuffer.toString();
    }
}

