/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASHandler;
import com.ibm.ras.RASUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;

public class RASFileHandler
extends RASHandler
implements RASConstants {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = -8525824951965645330L;
    private String encoding;
    protected String fileName;
    protected String orgFileName;

    public RASFileHandler() {
    }

    public RASFileHandler(String string) {
        super(string);
    }

    public RASFileHandler(String string, String string2) {
        super(string, string2);
    }

    public RASFileHandler(String string, String string2, String string3) {
        super(string, string2);
        this.setFileName(string3);
    }

    public RASFileHandler(String string, String string2, String string3, String string4) {
        this(string, string2, string3);
        this.setEncoding(string4);
    }

    protected void init() {
        super.init();
        this.fileName = null;
        this.orgFileName = null;
        this.setEncoding(null);
    }

    public Hashtable getConfig() {
        String string;
        Hashtable hashtable = super.getConfig();
        if (this.orgFileName != null) {
            hashtable.put("fileName", this.orgFileName);
        }
        if ((string = this.getEncoding()) != null) {
            hashtable.put("encoding", this.getEncoding());
        }
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        super.setConfig(hashtable);
        if (hashtable.containsKey("fileName")) {
            this.setFileName((String)hashtable.get("fileName"));
        }
        if (hashtable.containsKey("encoding")) {
            this.setEncoding((String)hashtable.get("encoding"));
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        if (string != null) {
            this.orgFileName = string;
            this.fileName = string.replace('/', File.separatorChar);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDevice() {
        this.closeDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            block5: {
                String string = this.getFileName();
                try {
                    RASUtil.makePath(string);
                    FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                    OutputStreamWriter outputStreamWriter = this.getEncoding() == null ? new OutputStreamWriter(fileOutputStream) : new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding);
                    this.pWriter = new PrintWriter((Writer)new BufferedWriter(outputStreamWriter), true);
                    this.deviceOpen = true;
                }
                catch (Exception exception) {
                    if (++this.deviceFailures > 2) break block5;
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_OPEN_FILE", string));
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLog() {
        Object object = this.deviceLock;
        synchronized (object) {
            File file;
            this.closeDevice();
            String string = this.getFileName();
            if (string != null && (file = new File(string)).exists() && !file.delete()) {
                RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_DELETE_FILE", string));
            }
        }
    }
}

