/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASEvent;
import com.ibm.ras.RASIMessageEvent;
import com.ibm.ras.RASMessageFormatter;
import com.ibm.ras.RASUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RASMessageEvent
extends RASEvent
implements RASIMessageEvent {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 2783570584026644572L;
    private String messageFile = null;

    public RASMessageEvent() {
        this.setMessageEvent(true);
    }

    protected RASMessageEvent(long l, String string, Object[] objectArray, String string2) {
        super(l, string, objectArray);
        this.setMessageFile(string2);
        this.setMessageEvent(true);
    }

    protected RASMessageEvent(long l, String string, String[] stringArray, String string2) {
        this(l, string, (Object[])stringArray, string2);
    }

    public RASMessageEvent(long l, String string, Object[] objectArray, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Throwable throwable) {
        this(l, string, objectArray, string2);
        if (string3 != null) {
            this.setAttribute("loggingClass", string3);
        }
        if (string4 != null) {
            this.setAttribute("loggingMethod", string4);
        }
        if (string5 != null) {
            this.setAttribute("organization", string5);
        }
        if (string6 != null) {
            this.setAttribute("product", string6);
        }
        if (string7 != null) {
            this.setAttribute("component", string7);
        }
        if (string8 != null) {
            this.setAttribute("server", string8);
        }
        if (string9 != null) {
            this.setAttribute("client", string9);
        }
        if (throwable != null) {
            this.setAttribute("exception", throwable);
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.setAttribute("exceptionTrace", stringWriter.toString());
        }
    }

    public RASMessageEvent(long l, String string, String[] stringArray, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Throwable throwable) {
        this(l, string, (Object[])stringArray, string2, string3, string4, string5, string6, string7, string8, string9, throwable);
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public void setMessageFile(String string) {
        this.messageFile = string;
    }

    public Hashtable getSupportedTypes() {
        Hashtable hashtable = super.getSupportedTypes();
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_INFO"), new Long(1L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_WARN"), new Long(2L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_ERR"), new Long(4L));
        return hashtable;
    }

    public long maskLongValue(String string) {
        long l = super.maskLongValue(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("TYPE_INFO") || string2.equals("TYPE_INFORMATION")) {
                l |= 1L;
                continue;
            }
            if (string2.equals("TYPE_WARN") || string2.equals("TYPE_WARNING")) {
                l |= 2L;
                continue;
            }
            if (string2.equals("TYPE_ERR") || string2.equals("TYPE_ERROR")) {
                l |= 4L;
                continue;
            }
            if (string2.equals("DEFAULT_MESSAGE_MASK")) {
                l |= 7L;
                continue;
            }
            if (!string2.equals("ALL_MESSAGE_MASK")) continue;
            l |= 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public String maskToString(long l) {
        StringBuffer stringBuffer = new StringBuffer(super.maskToString(l));
        if ((l & 1L) != 0L) {
            stringBuffer.append("TYPE_INFO ");
        }
        if ((l & 2L) != 0L) {
            stringBuffer.append("TYPE_WARN ");
        }
        if ((l & 4L) != 0L) {
            stringBuffer.append("TYPE_ERR ");
        }
        return stringBuffer.toString().trim();
    }

    public String toString() {
        RASMessageFormatter rASMessageFormatter = new RASMessageFormatter();
        return rASMessageFormatter.format(this);
    }
}

