/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASFormatter;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASMessageCatalog;
import com.ibm.ras.RASMessageEvent;
import java.util.Locale;

public class RASMessageFormatter
extends RASFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 5225655501360484531L;
    private static String[] attribs = new String[]{"loggingClass", "loggingMethod", "organization", "product", "component", "server", "client"};
    private Locale locale = Locale.getDefault();

    public RASMessageFormatter() {
        this.addEventClass("com.ibm.ras.RASMessageEvent");
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public String format(RASIEvent rASIEvent) {
        String string = this.getSeparator();
        StringBuffer stringBuffer = new StringBuffer(256);
        RASMessageEvent rASMessageEvent = (RASMessageEvent)rASIEvent;
        long l = rASMessageEvent.getTimeStamp();
        stringBuffer.append(this.getDate(l) + string);
        stringBuffer.append(this.getTime(l) + string);
        for (int i = 0; i < attribs.length; ++i) {
            String string2 = (String)rASMessageEvent.getAttribute(attribs[i]);
            if (string2 == null) continue;
            stringBuffer.append(string2 + string);
        }
        stringBuffer.append(this.lineSep);
        stringBuffer.append("  " + this.getText(rASMessageEvent));
        return stringBuffer.toString();
    }

    protected String getText(RASMessageEvent rASMessageEvent) {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = rASMessageEvent.getText();
        Object[] objectArray = rASMessageEvent.getParameters();
        String string2 = rASMessageEvent.getMessageFile();
        String string3 = (String)rASMessageEvent.getAttribute("exceptionTrace");
        if (string3 != null) {
            stringBuffer.append(string3);
        } else if (string2 == null) {
            stringBuffer.append(string);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(", p" + (i + 1) + "=" + (String)objectArray[i]);
                }
            }
        } else {
            RASMessageCatalog rASMessageCatalog = new RASMessageCatalog(string2, this.getLocale());
            stringBuffer.append(rASMessageCatalog.getMsg(string, objectArray));
        }
        if (string3 == null) {
            stringBuffer.append(this.lineSep);
        }
        return stringBuffer.toString();
    }
}

