/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASIMessageEvent;
import com.ibm.ras.RASIMessageLogger;
import com.ibm.ras.RASLogger;
import com.ibm.ras.RASMaskChangeEvent;
import com.ibm.ras.RASMessageEvent;
import com.ibm.ras.RASUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RASMessageLogger
extends RASLogger
implements RASIMessageLogger,
RASIMessageEvent {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = -774966808967971274L;
    private String component;
    private String organization;
    private String product;
    private String messageFile;
    private Vector suppressedKeys;

    public RASMessageLogger() {
    }

    public RASMessageLogger(String string) {
        super(string);
    }

    public RASMessageLogger(String string, String string2) {
        super(string, string2);
    }

    public RASMessageLogger(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(string, string2);
        this.setOrganization(string3);
        this.setProduct(string4);
        this.setComponent(string5);
        this.setServer(string6);
        this.setClient(string7);
    }

    protected void init() {
        super.init();
        this.setComponent("");
        this.setOrganization("");
        this.setProduct("");
        this.setMessageFile(null);
        this.suppressedKeys = new Vector();
        this.setLogging(true);
        this.addMessageEventClass("com.ibm.ras.RASMessageEvent");
    }

    public Hashtable getConfig() {
        Hashtable hashtable = super.getConfig();
        hashtable.put("organization", this.getOrganization());
        hashtable.put("product", this.getProduct());
        hashtable.put("component", this.getComponent());
        String string = this.getMessageFile();
        if (string != null) {
            hashtable.put("messageFile", string);
        }
        hashtable.put("suppressedKeys", RASUtil.vectorToString(this.suppressedKeys));
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        super.setConfig(hashtable);
        if (hashtable.containsKey("organization")) {
            this.setOrganization((String)hashtable.get("organization"));
        }
        if (hashtable.containsKey("product")) {
            this.setProduct((String)hashtable.get("product"));
        }
        if (hashtable.containsKey("component")) {
            this.setComponent((String)hashtable.get("component"));
        }
        if (hashtable.containsKey("messageFile")) {
            this.messageFile = (String)hashtable.get("messageFile");
        }
        if (hashtable.containsKey("suppressedKeys")) {
            this.suppressedKeys = RASUtil.stringToVector((String)hashtable.get("suppressedKeys"));
        }
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String string) {
        if (string != null) {
            this.organization = string;
        }
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String string) {
        if (string != null) {
            this.product = string;
        }
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String string) {
        if (string != null) {
            this.component = string;
        }
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public void setMessageFile(String string) {
        if (string != null) {
            this.messageFile = string;
        }
    }

    public void addSuppressedKey(String string) {
        if (string != null && !this.suppressedKeys.contains(string)) {
            this.suppressedKeys.addElement(string);
        }
    }

    public void removeSuppressedKey(String string) {
        if (string != null && this.suppressedKeys.contains(string)) {
            this.suppressedKeys.removeElement(string);
        }
    }

    public Vector getSuppressedKeys() {
        return this.suppressedKeys;
    }

    public void message(long l, Object object, String string, String string2) {
        if (this.isLoggable(l)) {
            String string3 = object.getClass().getName();
            this.logMsg(l, string3, string, string2, this.getMessageFile(), null, null);
        }
    }

    public void message(long l, Object object, String string, String string2, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object2};
            String string3 = object.getClass().getName();
            this.logMsg(l, string3, string, string2, this.getMessageFile(), objectArray, null);
        }
    }

    public void message(long l, Object object, String string, String string2, Object object2, Object object3) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object2, object3};
            String string3 = object.getClass().getName();
            this.logMsg(l, string3, string, string2, this.getMessageFile(), objectArray, null);
        }
    }

    public void message(long l, Object object, String string, String string2, Object[] objectArray) {
        if (this.isLoggable(l)) {
            String string3 = object.getClass().getName();
            this.logMsg(l, string3, string, string2, this.getMessageFile(), objectArray, null);
        }
    }

    public void message(long l, String string, String string2, String string3) {
        if (this.isLoggable(l)) {
            this.logMsg(l, string, string2, string3, this.getMessageFile(), null, null);
        }
    }

    public void message(long l, String string, String string2, String string3, Object object) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object};
            this.logMsg(l, string, string2, string3, this.getMessageFile(), objectArray, null);
        }
    }

    public void message(long l, String string, String string2, String string3, Object object, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object, object2};
            this.logMsg(l, string, string2, string3, this.getMessageFile(), objectArray, null);
        }
    }

    public void message(long l, String string, String string2, String string3, Object[] objectArray) {
        if (this.isLoggable(l)) {
            this.logMsg(l, string, string2, string3, this.getMessageFile(), objectArray, null);
        }
    }

    public void msg(long l, Object object, String string, String string2, String string3) {
        if (this.isLoggable(l)) {
            String string4 = object.getClass().getName();
            this.logMsg(l, string4, string, string2, string3, null, null);
        }
    }

    public void msg(long l, Object object, String string, String string2, String string3, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object2};
            String string4 = object.getClass().getName();
            this.logMsg(l, string4, string, string2, string3, objectArray, null);
        }
    }

    public void msg(long l, Object object, String string, String string2, String string3, Object object2, Object object3) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object2, object3};
            String string4 = object.getClass().getName();
            this.logMsg(l, string4, string, string2, string3, objectArray, null);
        }
    }

    public void msg(long l, Object object, String string, String string2, String string3, Object[] objectArray) {
        if (this.isLoggable(l)) {
            String string4 = object.getClass().getName();
            this.logMsg(l, string4, string, string2, string3, objectArray, null);
        }
    }

    public void msg(long l, String string, String string2, String string3, String string4) {
        if (this.isLoggable(l)) {
            this.logMsg(l, string, string2, string3, string4, null, null);
        }
    }

    public void msg(long l, String string, String string2, String string3, String string4, Object object) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object};
            this.logMsg(l, string, string2, string3, string4, objectArray, null);
        }
    }

    public void msg(long l, String string, String string2, String string3, String string4, Object object, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object, object2};
            this.logMsg(l, string, string2, string3, string4, objectArray, null);
        }
    }

    public void msg(long l, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (this.isLoggable(l)) {
            this.logMsg(l, string, string2, string3, string4, objectArray, null);
        }
    }

    public void textMessage(long l, Object object, String string, String string2) {
        if (this.isLoggable(l)) {
            String string3 = object.getClass().getName();
            this.logMsg(l, string3, string, string2, null, null, null);
        }
    }

    public void textMessage(long l, Object object, String string, String string2, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object2};
            String string3 = object.getClass().getName();
            this.logMsg(l, string3, string, string2, null, objectArray, null);
        }
    }

    public void textMessage(long l, Object object, String string, String string2, Object object2, Object object3) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object2, object3};
            String string3 = object.getClass().getName();
            this.logMsg(l, string3, string, string2, null, objectArray, null);
        }
    }

    public void textMessage(long l, Object object, String string, String string2, Object[] objectArray) {
        if (this.isLoggable(l)) {
            String string3 = object.getClass().getName();
            this.logMsg(l, string3, string, string2, null, objectArray, null);
        }
    }

    public void textMessage(long l, String string, String string2, String string3) {
        if (this.isLoggable(l)) {
            this.logMsg(l, string, string2, string3, null, null, null);
        }
    }

    public void textMessage(long l, String string, String string2, String string3, Object object) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object};
            this.logMsg(l, string, string2, string3, null, objectArray, null);
        }
    }

    public void textMessage(long l, String string, String string2, String string3, Object object, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object, object2};
            this.logMsg(l, string, string2, string3, null, objectArray, null);
        }
    }

    public void textMessage(long l, String string, String string2, String string3, Object[] objectArray) {
        if (this.isLoggable(l)) {
            this.logMsg(l, string, string2, string3, null, objectArray, null);
        }
    }

    public void exception(long l, Object object, String string, Exception exception) {
        this.exception(l, object, string, (Throwable)exception);
    }

    public void exception(long l, String string, String string2, Exception exception) {
        this.exception(l, string, string2, (Throwable)exception);
    }

    public void exception(long l, Object object, String string, Throwable throwable) {
        if (this.isLoggable(l)) {
            String string2 = object.getClass().getName();
            this.logMsg(l, string2, string, null, null, null, throwable);
        }
    }

    public void exception(long l, String string, String string2, Throwable throwable) {
        if (this.isLoggable(l)) {
            this.logMsg(l, string, string2, null, null, null, throwable);
        }
    }

    protected void logMsg(long l, String string, String string2, String string3, String string4, Object[] objectArray, Throwable throwable) {
        if (string4 == null || !this.getSuppressedKeys().contains(string3)) {
            RASMessageEvent rASMessageEvent = new RASMessageEvent(l, string3, objectArray, string4, string, string2, this.getOrganization(), this.getProduct(), this.getComponent(), this.getServer(), this.getClient(), throwable);
            this.fireRASEvent(rASMessageEvent);
        }
    }

    public synchronized void maskValueChanged(RASMaskChangeEvent rASMaskChangeEvent) {
        this.isLoggableMask = 0L;
        Enumeration enumeration = this.getHandlers();
        while (enumeration.hasMoreElements()) {
            RASIHandler rASIHandler = (RASIHandler)enumeration.nextElement();
            this.isLoggableMask |= rASIHandler.getMessageMask();
        }
        this.isLoggableMask &= this.getMessageMask();
    }
}

