/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASFormatter;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASTraceEvent;
import java.io.StringWriter;

public class RASTraceFormatter
extends RASFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = -5685726042408116109L;
    protected static String[] attribs = new String[]{"loggingClass", "loggingMethod", "threadID", "logger"};

    public RASTraceFormatter() {
        this.addEventClass("com.ibm.ras.RASTraceEvent");
    }

    public String format(RASIEvent rASIEvent) {
        String string = this.getSeparator();
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.getTime(rASIEvent.getTimeStamp()) + string);
        for (int i = 0; i < attribs.length; ++i) {
            String string2 = (String)rASIEvent.getAttribute(attribs[i]);
            if (string2 == null) continue;
            stringBuffer.append(string2 + string);
        }
        stringBuffer.append(this.lineSep);
        stringBuffer.append("  ");
        stringBuffer.append(this.getText((RASTraceEvent)rASIEvent));
        return stringBuffer.toString();
    }

    protected String getText(RASTraceEvent rASTraceEvent) {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = (String)rASTraceEvent.getAttribute("exceptionTrace");
        byte[] byArray = (byte[])rASTraceEvent.getAttribute("hexData");
        if (string != null) {
            stringBuffer.append(string);
        } else if (byArray != null) {
            stringBuffer.append(this.bytesToHex(byArray));
        } else {
            stringBuffer.append(rASTraceEvent.getText());
            String[] stringArray = rASTraceEvent.getParameters();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(", p" + (i + 1) + "=" + stringArray[i]);
                }
            }
        }
        if (string == null) {
            stringBuffer.append(this.lineSep);
        }
        return stringBuffer.toString();
    }

    protected String bytesToHex(byte[] byArray) {
        int n = 1;
        StringWriter stringWriter = new StringWriter();
        for (int i = 0; i < byArray.length; i += 32) {
            int n2;
            int n3;
            int n4 = Math.min(i + 32, byArray.length);
            StringBuffer stringBuffer = new StringBuffer();
            for (n3 = i; n3 < n4; ++n3) {
                n2 = byArray[n3];
                if (n2 < 0) {
                    n2 += 256;
                }
                String string = Integer.toString(n2, 16).toUpperCase();
                if (n2 < 16) {
                    string = "0" + string;
                }
                stringWriter.write(string);
                if (n % 16 == 0) {
                    stringWriter.write("  ");
                } else if (n % 2 == 0) {
                    stringWriter.write(" ");
                }
                ++n;
                if (n2 >= 32 && n2 <= 126) {
                    stringBuffer.append((char)n2);
                    continue;
                }
                stringBuffer.append('.');
            }
            n3 = 32 - (n4 - i);
            for (n2 = 0; n2 < n3; ++n2) {
                stringWriter.write("  ");
                if (n % 16 == 0) {
                    stringWriter.write("  ");
                } else if (n % 2 == 0) {
                    stringWriter.write(" ");
                }
                ++n;
            }
            stringWriter.write(stringBuffer.toString());
            stringWriter.write(this.lineSep);
            stringWriter.write("  ");
        }
        return stringWriter.toString();
    }
}

