/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASMessageCatalog;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class RASUtil {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    public static final String RAS_MSG_CAT = "com.ibm.ras.RASMsgs";
    private static final String MISSING_MSG_CAT = "The RAS message file, com.ibm.ras.RASMsgs, was not found.  No RAS messages can be displayed.";
    public static RASMessageCatalog rasMsgs = null;
    private static Hashtable localeToCodePage;
    private static PrintWriter errWriter;
    static /* synthetic */ Class class$com$ibm$ras$RASUtil;

    public static Object[] checkNullObjects(Object[] objectArray) {
        String string = null;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) continue;
                if (string == null) {
                    string = rasMsgs.getMessage("NULL_OBJECT");
                }
                objectArray[i] = string;
            }
        }
        return objectArray;
    }

    public static Object createObject(String string) {
        Class<?> clazz = null;
        Object var2_2 = null;
        ClassLoader classLoader = (class$com$ibm$ras$RASUtil == null ? (class$com$ibm$ras$RASUtil = RASUtil.class$("com.ibm.ras.RASUtil")) : class$com$ibm$ras$RASUtil).getClassLoader();
        try {
            clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            var2_2 = clazz.newInstance();
        }
        catch (Exception exception) {
            RASUtil.errorMsg(rasMsgs.getMessage("ERR_OBJ_CREATE", string));
            exception.printStackTrace();
        }
        return var2_2;
    }

    public static void errorMsg(String string) {
        if (errWriter == null) {
            System.err.println(string);
        } else {
            errWriter.println(string);
        }
    }

    public static String getConsoleCodePage() {
        String string = null;
        try {
            String string2 = System.getProperty("os.name");
            if (string2 != null && string2.startsWith("Windows")) {
                Locale locale = Locale.getDefault();
                String string3 = locale.getLanguage();
                String string4 = locale.getCountry();
                string = (String)localeToCodePage.get(string3 + "_" + string4);
                if (string == null) {
                    string = (String)localeToCodePage.get(string3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String left(String string, int n, String string2) {
        String string3 = string;
        if (string.length() < n) {
            while (string3.length() < n) {
                string3 = string3 + string2;
            }
        } else if (string.length() > n) {
            string3 = string.substring(0, n);
        }
        return string3;
    }

    public static String left(String string, int n) {
        return RASUtil.left(string, n, " ");
    }

    public static boolean makePath(String string) throws SecurityException {
        File file;
        boolean bl = true;
        File file2 = new File(string = string.replace('/', File.separatorChar));
        String string2 = file2.getParent();
        if (string2 != null && !(file = new File(string2)).exists()) {
            bl = file.mkdirs();
        }
        return bl;
    }

    public static Vector arrayToVector(Object[] objectArray) {
        Vector<String> vector = null;
        if (objectArray != null) {
            vector = new Vector<String>();
            for (int i = 0; i < objectArray.length; ++i) {
                vector.addElement(objectArray[i].toString());
            }
        }
        return vector;
    }

    public static Vector stringToVector(String string) {
        Vector<String> vector = null;
        if (string != null) {
            vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken().trim());
            }
        }
        return vector;
    }

    public static String vectorToString(Vector vector) {
        String string = null;
        StringBuffer stringBuffer = null;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            stringBuffer = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(enumeration.nextElement());
                stringBuffer.append(" ");
            }
            string = stringBuffer.toString().trim();
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            rasMsgs = new RASMessageCatalog(RAS_MSG_CAT);
        }
        catch (MissingResourceException missingResourceException) {
            RASUtil.errorMsg(MISSING_MSG_CAT);
            missingResourceException.printStackTrace();
        }
        localeToCodePage = new Hashtable();
        errWriter = null;
        localeToCodePage.put("cs", "Cp852");
        localeToCodePage.put("da", "Cp850");
        localeToCodePage.put("en", "Cp850");
        localeToCodePage.put("de", "Cp850");
        localeToCodePage.put("es", "Cp850");
        localeToCodePage.put("fi", "Cp850");
        localeToCodePage.put("fr", "Cp850");
        localeToCodePage.put("hu", "Cp852");
        localeToCodePage.put("it", "Cp850");
        localeToCodePage.put("nl", "Cp949");
        localeToCodePage.put("no", "Cp850");
        localeToCodePage.put("pl", "Cp852");
        localeToCodePage.put("pt", "Cp850");
        localeToCodePage.put("ru", "Cp866");
        localeToCodePage.put("sl", "Cp852");
        localeToCodePage.put("sv", "Cp850");
        localeToCodePage.put("tr", "Cp857");
        try {
            String string = RASUtil.getConsoleCodePage();
            RASUtil rASUtil = new RASUtil();
            OutputStreamWriter outputStreamWriter = string != null && rASUtil.getClass().getClassLoader() == null ? new OutputStreamWriter((OutputStream)System.err, string) : new OutputStreamWriter(System.err);
            errWriter = new PrintWriter((Writer)outputStreamWriter, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

