/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.mgr;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASILogger;
import com.ibm.ras.RASObject;
import com.ibm.ras.mgr.RASConfig;
import com.ibm.ras.mgr.RASManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class RASGroup
extends RASObject
implements Cloneable,
RASConstants {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 16971700404675172L;
    private static final int ML_CFG = 1;
    private static final int TL_CFG = 2;
    private static final int H_CFG = 3;
    private static final int F_CFG = 4;
    private boolean modified = false;
    private Hashtable messageLoggerCfgs = new Hashtable();
    private Hashtable traceLoggerCfgs = new Hashtable();
    private Hashtable handlerCfgs = new Hashtable();
    private Hashtable formatterCfgs = new Hashtable();

    public RASGroup(String string) {
        super(string);
    }

    public RASGroup(String string, String string2) {
        super(string, string2);
    }

    public synchronized Object clone() {
        RASGroup rASGroup = (RASGroup)super.clone();
        rASGroup.messageLoggerCfgs = (Hashtable)this.messageLoggerCfgs.clone();
        rASGroup.traceLoggerCfgs = (Hashtable)this.traceLoggerCfgs.clone();
        rASGroup.handlerCfgs = (Hashtable)this.handlerCfgs.clone();
        rASGroup.formatterCfgs = (Hashtable)this.formatterCfgs.clone();
        return rASGroup;
    }

    public void addMessageLoggerConfig(RASConfig rASConfig) {
        this.addConfig(rASConfig, 1);
    }

    public void removeMessageLoggerConfig(String string) {
        this.removeConfig(string, 1);
    }

    public RASConfig getMessageLoggerConfig(String string) {
        return this.getConfig(string, 1);
    }

    public Hashtable getMessageLoggerConfigs() {
        return this.messageLoggerCfgs;
    }

    public void addTraceLoggerConfig(RASConfig rASConfig) {
        this.addConfig(rASConfig, 2);
    }

    public void removeTraceLoggerConfig(String string) {
        this.removeConfig(string, 2);
    }

    public RASConfig getTraceLoggerConfig(String string) {
        return this.getConfig(string, 2);
    }

    public Hashtable getTraceLoggerConfigs() {
        return this.traceLoggerCfgs;
    }

    public void addHandlerConfig(RASConfig rASConfig) {
        this.addConfig(rASConfig, 3);
    }

    public void removeHandlerConfig(String string) {
        this.removeConfig(string, 3);
    }

    public RASConfig getHandlerConfig(String string) {
        return this.getConfig(string, 3);
    }

    public Hashtable getHandlerConfigs() {
        return this.handlerCfgs;
    }

    public void addFormatterConfig(RASConfig rASConfig) {
        this.addConfig(rASConfig, 4);
    }

    public void removeFormatterConfig(String string) {
        this.removeConfig(string, 4);
    }

    public RASConfig getFormatterConfig(String string) {
        return this.getConfig(string, 4);
    }

    public Hashtable getFormatterConfigs() {
        return this.formatterCfgs;
    }

    private void addConfig(RASConfig rASConfig, int n) {
        String string;
        if (rASConfig != null && (string = (String)rASConfig.get("name")) != null) {
            String string2 = this.getClass().getName();
            if (!rASConfig.containsKey("group") && !string2.equals("com.ibm.ras.mgr.RASBaseGroup")) {
                rASConfig.put("group", this.getName());
            }
            Hashtable hashtable = this.getConfigTable(n);
            hashtable.put(string, rASConfig);
        }
    }

    private void removeConfig(String string, int n) {
        if (string != null) {
            Hashtable hashtable = this.getConfigTable(n);
            hashtable.remove(string);
        }
    }

    private RASConfig getConfig(String string, int n) {
        RASConfig rASConfig = null;
        if (string != null) {
            Hashtable hashtable = this.getConfigTable(n);
            rASConfig = (RASConfig)hashtable.get(string);
        }
        return rASConfig;
    }

    private Hashtable getConfigTable(int n) {
        Hashtable hashtable = null;
        switch (n) {
            case 1: {
                hashtable = this.messageLoggerCfgs;
                break;
            }
            case 2: {
                hashtable = this.traceLoggerCfgs;
                break;
            }
            case 3: {
                hashtable = this.handlerCfgs;
                break;
            }
            case 4: {
                hashtable = this.formatterCfgs;
            }
        }
        return hashtable;
    }

    protected void updateActiveObjects(RASGroup rASGroup, RASManager rASManager) {
        if (rASGroup != null) {
            RASILogger rASILogger;
            RASConfig rASConfig;
            String string;
            RASConfig rASConfig2;
            Enumeration enumeration = rASGroup.getMessageLoggerConfigs().elements();
            while (enumeration.hasMoreElements()) {
                rASConfig2 = (RASConfig)enumeration.nextElement();
                string = (String)rASConfig2.get("name");
                rASConfig = this.getMessageLoggerConfig(string);
                if (rASConfig == null) {
                    this.addConfig(rASConfig2, 1);
                    continue;
                }
                rASConfig.updateActiveObjects(rASConfig2);
                rASILogger = (RASILogger)((Object)rASConfig.getObject());
                if (rASILogger == null) continue;
                rASManager.addHandlers(rASILogger, rASConfig, this);
            }
            enumeration = rASGroup.getTraceLoggerConfigs().elements();
            while (enumeration.hasMoreElements()) {
                rASConfig2 = (RASConfig)enumeration.nextElement();
                string = (String)rASConfig2.get("name");
                rASConfig = this.getTraceLoggerConfig(string);
                if (rASConfig == null) {
                    this.addConfig(rASConfig2, 2);
                    continue;
                }
                rASConfig.updateActiveObjects(rASConfig2);
                rASILogger = (RASILogger)((Object)rASConfig.getObject());
                if (rASILogger == null) continue;
                rASManager.addHandlers(rASILogger, rASConfig, this);
            }
            enumeration = rASGroup.getHandlerConfigs().elements();
            while (enumeration.hasMoreElements()) {
                rASConfig2 = (RASConfig)enumeration.nextElement();
                string = (String)rASConfig2.get("name");
                rASConfig = this.getHandlerConfig(string);
                if (rASConfig == null) {
                    this.addConfig(rASConfig2, 3);
                    continue;
                }
                rASConfig.updateActiveObjects(rASConfig2);
            }
            enumeration = rASGroup.getFormatterConfigs().elements();
            while (enumeration.hasMoreElements()) {
                rASConfig2 = (RASConfig)enumeration.nextElement();
                string = (String)rASConfig2.get("name");
                rASConfig = this.getFormatterConfig(string);
                if (rASConfig == null) {
                    this.addConfig(rASConfig2, 4);
                    continue;
                }
                rASConfig.updateActiveObjects(rASConfig2);
            }
        }
    }

    public synchronized void setModified(boolean bl) {
        this.modified = bl;
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RASGroup:  " + this.getName() + "\r\n");
        if (!this.messageLoggerCfgs.isEmpty()) {
            stringBuffer.append("  Message Loggers:\r\n");
            stringBuffer.append(this.tableToString(this.messageLoggerCfgs));
        }
        if (!this.traceLoggerCfgs.isEmpty()) {
            stringBuffer.append("  Trace Loggers:\r\n");
            stringBuffer.append(this.tableToString(this.traceLoggerCfgs));
        }
        if (!this.handlerCfgs.isEmpty()) {
            stringBuffer.append("  Handlers:\r\n");
            stringBuffer.append(this.tableToString(this.handlerCfgs));
        }
        if (!this.formatterCfgs.isEmpty()) {
            stringBuffer.append("  Formatters:\r\n");
            stringBuffer.append(this.tableToString(this.formatterCfgs));
        }
        return stringBuffer.toString();
    }

    private String tableToString(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!hashtable.isEmpty()) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                RASConfig rASConfig = (RASConfig)enumeration.nextElement();
                stringBuffer.append(rASConfig.toString());
            }
        }
        return stringBuffer.toString();
    }
}

