/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.CORBA.iiop.OrbTrcLogger;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceStateChangeListener;
import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASITraceEvent;
import com.ibm.ras.RASStackTrace;
import com.ibm.ras.RASTraceLogger;
import com.ibm.websphere.ras.WsHandler;
import com.ibm.websphere.ras.WsOrbRasManager;
import java.util.Enumeration;

public class WsJrasTraceLogger
extends RASTraceLogger
implements RASITraceEvent,
OrbTrcLogger,
TraceStateChangeListener {
    private static String svByteArrayText = "tracing a byte array";
    private static String svExceptionText = "The following exception was logged";
    private static String svEmptyString = "";
    private static Object[] svNullParms = new Object[]{null};
    private static long svEvent = 1128L;
    private static long svEE = 903L;
    private static long svDebug = 16L;
    private static long svMapEvent = svEvent | 0x800L;
    private static long svMapEntryExit = svEE | 0x800L | 0x1000L;
    private static long svMapDebug = svDebug | 0x800L | 0x1000L | 0x2000L;
    private static long svEventMask = svEvent | 0x800L;
    private static long svEEMask = svEE | 0x1000L;
    private static long svDebugMask = svDebug | 0x2000L;
    private static long svAllTrace = svEventMask | svEEMask | svDebugMask;
    private WsHandler svWsHandler = new WsHandler();
    private TraceComponent ivTc = null;
    String ivTrName = null;
    private boolean ivWsHandlerInstalled = true;
    private boolean ivUserHandlerInstalled = false;
    private boolean ivOrbLogger = false;
    private boolean ivInitialized = false;
    private String ivOrganization;
    private String ivProduct;
    private String ivComponent;

    WsJrasTraceLogger(String string, String string2, String string3, String string4) {
        super(string4, "");
        this.ivOrganization = string;
        this.ivProduct = string2;
        this.ivComponent = string3;
        this.ivTc = Tr.register(string4);
        this.ivTrName = this.ivTc.getName();
        super.setSynchronous(true);
        super.addHandler(this.svWsHandler);
        this.ivInitialized = true;
        this.ivTc.setLoggerForCallback(this);
        this.traceStateChanged();
    }

    protected void init() {
        super.init();
    }

    public synchronized void traceStateChanged() {
        long l = 0L;
        if (this.ivTc.isEventEnabled()) {
            l |= svMapEvent;
        }
        if (this.ivTc.isEntryEnabled()) {
            l |= svMapEntryExit;
        }
        if (this.ivTc.isDebugEnabled()) {
            l |= svMapDebug;
        }
        long l2 = this.getTraceMask();
        l2 &= svAllTrace ^ 0xFFFFFFFFFFFFFFFFL;
        this.setTraceMask(l2 |= l);
        this.isLogging = l2 != 0L;
        if (this.ivOrbLogger) {
            WsOrbRasManager.setTrcLogging((boolean)this.isLogging);
        }
    }

    public void setLoggingOutput(String string) {
    }

    public void exception(long l, Object object, String string, Exception exception) {
        this.exception(l, object, string, (Throwable)exception);
    }

    public void exception(long l, String string, String string2, Exception exception) {
        this.exception(l, string, string2, (Throwable)exception);
    }

    void setOrbLogger() {
        this.ivOrbLogger = true;
    }

    public void setName(String string) {
        if (!this.ivInitialized) {
            super.setName(string);
        }
    }

    public String getGroup() {
        return null;
    }

    public long getMessageMask() {
        return 0L;
    }

    public void setMessageMask(long l) {
    }

    public void addMessageEventClass(String string) {
    }

    public void removeMessageEventClass(String string) {
    }

    public void setLogging(boolean bl) {
        super.setLogging(bl);
        if (this.ivOrbLogger) {
            WsOrbRasManager.setTrcLogging((boolean)bl);
        }
    }

    public void addHandler(RASIHandler rASIHandler) {
        if (rASIHandler != null) {
            if (rASIHandler instanceof WsHandler) {
                return;
            }
            this.ivUserHandlerInstalled = true;
            super.addHandler(rASIHandler);
        }
    }

    public void removeHandler(RASIHandler rASIHandler) {
        if (rASIHandler == null) {
            return;
        }
        if (rASIHandler instanceof WsHandler) {
            this.ivWsHandlerInstalled = false;
        }
        super.removeHandler(rASIHandler);
        Enumeration enumeration = this.getHandlers();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            RASIHandler rASIHandler2 = (RASIHandler)enumeration.nextElement();
            if (rASIHandler2 instanceof WsHandler) continue;
            ++n;
        }
        if (n == 0) {
            this.ivUserHandlerInstalled = false;
        }
    }

    public boolean isSynchronous() {
        return true;
    }

    public void setSynchronous(boolean bl) {
    }

    public void entry(long l, Object object, String string) {
        if (this.isLoggable(l |= 4L)) {
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Entry", null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Entry", null, null);
            }
        }
    }

    public void entry(long l, Object object, String string, Object object2) {
        if (this.isLoggable(l |= 4L)) {
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Entry", object2, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] objectArray = new Object[]{object2};
                this.logTrace(l, string2, string, "Entry", objectArray, null);
            }
        }
    }

    public void entry(long l, Object object, String string, Object object2, Object object3) {
        if (this.isLoggable(l |= 4L)) {
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            Object[] objectArray = new Object[]{object2, object3};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Entry", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Entry", objectArray, null);
            }
        }
    }

    public void entry(long l, Object object, String string, Object[] objectArray) {
        if (this.isLoggable(l |= 4L)) {
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Entry", objectArray, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Entry", objectArray, null);
            }
        }
    }

    public void entry(long l, String string, String string2) {
        if (this.isLoggable(l |= 4L)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Entry", null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Entry", null, null);
            }
        }
    }

    public void entry(long l, String string, String string2, Object object) {
        if (this.isLoggable(l |= 4L)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Entry", object, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] objectArray = new Object[]{object};
                this.logTrace(l, string, string2, "Entry", objectArray, null);
            }
        }
    }

    public void entry(long l, String string, String string2, Object object, Object object2) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{object, object2};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Entry", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Entry", objectArray, null);
            }
        }
    }

    public void entry(long l, String string, String string2, Object[] objectArray) {
        if (this.isLoggable(l |= 4L)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Entry", objectArray, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Entry", objectArray, null);
            }
        }
    }

    public void exit(long l, Object object, String string) {
        if (this.isLoggable(l |= 4L)) {
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Exit", null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Exit", null, null);
            }
        }
    }

    public void exit(long l, Object object, String string, byte by) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Byte(by)};
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, Object object, String string, short s) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Short(s)};
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, Object object, String string, int n) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Integer(n)};
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, Object object, String string, long l2) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Long(l2)};
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, Object object, String string, float f) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Float(f)};
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, Object object, String string, double d) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Double(d)};
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, Object object, String string, char c) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Character(c)};
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, Object object, String string, boolean bl) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Boolean(bl)};
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, Object object, String string, Object object2) {
        if (this.isLoggable(l |= 4L)) {
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, "Exit", object2, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] objectArray = new Object[]{object2};
                this.logTrace(l, string2, string, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, String string, String string2) {
        if (this.isLoggable(l |= 4L)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Exit", null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Exit", null, null);
            }
        }
    }

    public void exit(long l, String string, String string2, byte by) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Byte(by)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, String string, String string2, short s) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Short(s)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, String string, String string2, int n) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Integer(n)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, String string, String string2, long l2) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Long(l2)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, String string, String string2, float f) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Float(f)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, String string, String string2, double d) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Double(d)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, String string, String string2, char c) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Character(c)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, String string, String string2, boolean bl) {
        if (this.isLoggable(l |= 4L)) {
            Object[] objectArray = new Object[]{new Boolean(bl)};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Exit", objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, "Exit", objectArray, null);
            }
        }
    }

    public void exit(long l, String string, String string2, Object object) {
        if (this.isLoggable(l |= 4L)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, "Exit", object, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] objectArray = new Object[]{object};
                this.logTrace(l, string, string2, "Exit", objectArray, null);
            }
        }
    }

    public void trace(long l, Object object, String string, String string2) {
        if (this.isLoggable(l)) {
            String string3 = svEmptyString;
            if (object != null) {
                string3 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string3, string, string2, null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string3, string, string2, null, null);
            }
        }
    }

    public void trace(long l, Object object, String string, String string2, Object object2) {
        if (this.isLoggable(l)) {
            String string3 = svEmptyString;
            if (object != null) {
                string3 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string3, string, string2, object2, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] objectArray = new Object[]{object2};
                this.logTrace(l, string3, string, string2, objectArray, null);
            }
        }
    }

    public void trace(long l, Object object, String string, String string2, Object object2, Object object3) {
        if (this.isLoggable(l)) {
            String string3 = svEmptyString;
            if (object != null) {
                string3 = object.getClass().getName();
            }
            Object[] objectArray = new Object[]{object2, object3};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string3, string, string2, objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string3, string, string2, objectArray, null);
            }
        }
    }

    public void trace(long l, Object object, String string, String string2, Object[] objectArray) {
        if (this.isLoggable(l)) {
            String string3 = svEmptyString;
            if (object != null) {
                string3 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string3, string, string2, objectArray, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string3, string, string2, objectArray, null);
            }
        }
    }

    public void trace(long l, String string, String string2, String string3) {
        if (this.isLoggable(l)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, string3, null, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, string3, null, null);
            }
        }
    }

    public void trace(long l, String string, String string2, String string3, Object object) {
        if (this.isLoggable(l)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, string3, object, true);
            }
            if (this.ivUserHandlerInstalled) {
                Object[] objectArray = new Object[]{object};
                this.logTrace(l, string, string2, string3, objectArray, null);
            }
        }
    }

    public void trace(long l, String string, String string2, String string3, Object object, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object, object2};
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, string3, objectArray, false);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, string3, objectArray, null);
            }
        }
    }

    public void trace(long l, String string, String string2, String string3, Object[] objectArray) {
        if (this.isLoggable(l)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, string3, objectArray, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, string3, objectArray, null);
            }
        }
    }

    public void trace(long l, Object object, String string, byte[] byArray) {
        if (this.isLoggable(l)) {
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string2, string, svByteArrayText, byArray, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, byArray);
            }
        }
    }

    public void trace(long l, String string, String string2, byte[] byArray) {
        if (this.isLoggable(l)) {
            if (this.ivWsHandlerInstalled) {
                this.logTraceToTr(l, string, string2, svByteArrayText, byArray, true);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, byArray);
            }
        }
    }

    public void exception(long l, Object object, String string, Throwable throwable) {
        if (this.isLoggable(l |= 8L)) {
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(l, string2, string, throwable);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, null, null, throwable);
            }
        }
    }

    public void exception(long l, String string, String string2, Throwable throwable) {
        if (this.isLoggable(l |= 8L)) {
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(l, string, string2, throwable);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, null, null, throwable);
            }
        }
    }

    public void stackTrace(long l, Object object, String string) {
        if (this.isLoggable(l)) {
            String string2 = svEmptyString;
            if (object != null) {
                string2 = object.getClass().getName();
            }
            RASStackTrace rASStackTrace = new RASStackTrace();
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(l, string2, string, rASStackTrace);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string2, string, null, null, rASStackTrace);
            }
        }
    }

    public void stackTrace(long l, Object object, String string, String string2) {
        if (this.isLoggable(l)) {
            String string3 = svEmptyString;
            if (object != null) {
                string3 = object.getClass().getName();
            }
            RASStackTrace rASStackTrace = new RASStackTrace(string2);
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(l, string3, string, rASStackTrace);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string3, string, null, null, rASStackTrace);
            }
        }
    }

    public void stackTrace(long l, String string, String string2) {
        if (this.isLoggable(l)) {
            RASStackTrace rASStackTrace = new RASStackTrace();
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(l, string, string2, rASStackTrace);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, null, null, rASStackTrace);
            }
        }
    }

    public void stackTrace(long l, String string, String string2, String string3) {
        if (this.isLoggable(l)) {
            RASStackTrace rASStackTrace = new RASStackTrace(string3);
            if (this.ivWsHandlerInstalled) {
                this.logThrowableToTr(l, string, string2, rASStackTrace);
            }
            if (this.ivUserHandlerInstalled) {
                this.logTrace(l, string, string2, null, null, rASStackTrace);
            }
        }
    }

    private void logTraceToTr(long l, String string, String string2, String string3, Object objectArray, boolean bl) {
        try {
            if (this.ivOrbLogger) {
                String string4 = Thread.currentThread().getName();
                string2 = string2 == null ? string4 : string2 + " " + string4;
            }
            if (bl && objectArray == null) {
                objectArray = svNullParms;
            }
            int n = this.mapJrasTypeToTr(l, string3);
            TraceEvent traceEvent = new TraceEvent(n, this.ivTc, string3, objectArray, this.ivOrganization, this.ivProduct, this.ivComponent, string, string2, null);
            Tr.logJrasEvent(traceEvent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void logThrowableToTr(long l, String string, String string2, Throwable throwable) {
        try {
            if (this.ivOrbLogger) {
                String string3 = Thread.currentThread().getName();
                string2 = string2 == null ? string3 : string2 + " " + string3;
            }
            int n = this.mapJrasTypeToTr(l, null);
            String string4 = RasHelper.throwableToString(throwable);
            TraceEvent traceEvent = new TraceEvent(n, this.ivTc, svExceptionText, (Object)string4, this.ivOrganization, this.ivProduct, this.ivComponent, string, string2, string4);
            Tr.logJrasEvent(traceEvent);
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
        }
    }

    private int mapJrasTypeToTr(long l, String string) {
        if ((l & svDebugMask) != 0L) {
            return 2;
        }
        if ((l & svEventMask) != 0L) {
            return 5;
        }
        if (string == "Exit") {
            return 7;
        }
        return 6;
    }
}

