/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class binascii {
    public static String __doc__ = "Conversion between binary data and ASCII";
    public static final PyString Error = new PyString("binascii.Error");
    public static final PyString Incomplete = new PyString("binascii.Incomplete");
    private static char RUNCHAR = (char)144;
    private static short DONE = (short)127;
    private static short SKIP = (short)126;
    private static short FAIL = (short)125;
    private static short[] table_a2b_hqx = new short[]{FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, SKIP, FAIL, FAIL, SKIP, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, FAIL, FAIL, 13, 14, 15, 16, 17, 18, 19, FAIL, 20, 21, DONE, FAIL, FAIL, FAIL, FAIL, FAIL, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, FAIL, 37, 38, 39, 40, 41, 42, 43, FAIL, 44, 45, 46, 47, FAIL, FAIL, FAIL, FAIL, 48, 49, 50, 51, 52, 53, 54, FAIL, 55, 56, 57, 58, 59, 60, FAIL, FAIL, 61, 62, 63, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL};
    private static byte[] table_b2a_hqx = "!\"#$%&'()*+,-012345689@ABCDEFGHIJKLMNPQRSTUVXYZ[`abcdefhijklmpqr".getBytes();
    private static short[] table_a2b_base64 = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    private static char BASE64_PAD = (char)61;
    private static int BASE64_MAXBIN = 57;
    private static byte[] table_b2a_base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
    private static int[] crctab_hqx = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935, 4657, 528, 12915, 8786, 21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076, 62463, 58334, 9314, 13379, 1056, 5121, 25830, 29895, 17572, 21637, 42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669, 13907, 9842, 5649, 1584, 30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616, 63455, 59390, 55197, 51132, 18628, 22757, 26758, 30887, 2112, 6241, 10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403, 23285, 19156, 31415, 27286, 6769, 2640, 14899, 10770, 56317, 52188, 64447, 60318, 39801, 35672, 47931, 43802, 27814, 31879, 19684, 23749, 11298, 15363, 3168, 7233, 60846, 64911, 52716, 56781, 44330, 48395, 36200, 40265, 32407, 28342, 24277, 20212, 15891, 11826, 7761, 3696, 65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728, 37256, 33193, 45514, 41451, 53516, 49453, 61774, 57711, 4224, 161, 12482, 8419, 20484, 16421, 28742, 24679, 33721, 37784, 41979, 46042, 49981, 54044, 58239, 62302, 689, 4752, 8947, 13010, 16949, 21012, 25207, 29270, 46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411, 5280, 1153, 29798, 25671, 21540, 17413, 42971, 47098, 34713, 38840, 59231, 63358, 50973, 55100, 9939, 14066, 1681, 5808, 26199, 30326, 17941, 22068, 55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435, 22596, 18533, 30726, 26663, 6336, 2273, 14466, 10403, 52093, 56156, 60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254, 2801, 6864, 10931, 14994, 64814, 60687, 56684, 52557, 48554, 44427, 40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392, 3265, 61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310, 20053, 24180, 11923, 16050, 3793, 7920};
    public static PyString __doc__a2b_uu = new PyString("(ascii) -> bin. Decode a line of uuencoded data");
    public static PyString __doc__b2a_uu = new PyString("(bin) -> ascii. Uuencode line of data");
    public static PyString __doc__a2b_base64 = new PyString("(ascii) -> bin. Decode a line of base64 data");
    public static PyString __doc__b2a_base64 = new PyString("(bin) -> ascii. Base64-code line of data");
    public static PyString __doc__a2b_hqx = new PyString("ascii -> bin, done. Decode .hqx coding");
    public static PyString __doc__rlecode_hqx = new PyString("Binhex RLE-code binary data");
    public static PyString __doc__b2a_hqx = new PyString("Encode .hqx data");
    public static PyString __doc__rledecode_hqx = new PyString("Decode hexbin RLE-coded string");
    public static PyString __doc__crc_hqx = new PyString("(data, oldcrc) -> newcrc. Compute hqx CRC incrementally");
    static long[] crc_32_tab = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};
    private static char[] hexdigit = "0123456789abcdef".toCharArray();
    public static PyString __doc__b2a_hex = new PyString("b2a_hex(data) -> s; Hexadecimal representation of binary data.\n\nThis function is also available as \"hexlify()\".");
    public static PyString a2b_hex$doc = new PyString("a2b_hex(hexstr) -> s; Binary data of hexadecimal representation.\n\nhexstr must contain an even number of hex digits (upper or lower case).\nThis function is also available as \"unhexlify()\"");

    public static String a2b_uu(String string) {
        char c;
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length() - 1;
        int n4 = string.charAt(0) - 32 & 0x3F;
        int n5 = 0;
        while (n4 > 0) {
            c = string.charAt(n5 + 1);
            if (c == '\n' || c == '\r' || n3 <= 0) {
                c = '\u0000';
            } else {
                if (c < ' ' || c > '`') {
                    throw new PyException((PyObject)Error, "Illegal char");
                }
                c = (char)(c - 32 & 0x3F);
            }
            n2 = n2 << 6 | c;
            if ((n += 6) >= 8) {
                stringBuffer.append((char)(n2 >> (n -= 8) & 0xFF));
                n2 &= (1 << n) - 1;
                --n4;
            }
            ++n5;
            --n3;
        }
        while (n3-- > 0) {
            if ((c = string.charAt(++n5)) == ' ' || c == '@' || c == '\n' || c == '\r') continue;
            throw new PyException((PyObject)Error, "Trailing garbage");
        }
        return stringBuffer.toString();
    }

    public static String b2a_uu(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        if (n3 > 45) {
            throw new PyException((PyObject)Error, "At most 45 bytes at once");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(32 + (n3 & 0x3F)));
        int n4 = 0;
        while (n3 > 0 || n != 0) {
            n2 = n3 > 0 ? n2 << 8 | string.charAt(n4) : (n2 <<= 8);
            n += 8;
            while (n >= 6) {
                char c = (char)(n2 >> n - 6 & 0x3F);
                n -= 6;
                stringBuffer.append((char)(c + 32));
            }
            ++n4;
            --n3;
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private static int binascii_find_valid(String string, int n, int n2) {
        int n3 = string.length() - n;
        int n4 = -1;
        while (n3 > 0 && n4 == -1) {
            char c = string.charAt(n);
            short s = table_a2b_base64[c & 0x7F];
            if (c <= '\u007f' && s != -1) {
                if (n2 == 0) {
                    n4 = c;
                }
                --n2;
            }
            ++n;
            --n3;
        }
        return n4;
    }

    public static String a2b_base64(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = 0;
        while (n4 > 0) {
            char c = string.charAt(n6);
            if (c <= '\u007f' && c != '\r' && c != '\n' && c != ' ') {
                if (c == BASE64_PAD) {
                    if (n3 >= 2 && (n3 != 2 || binascii.binascii_find_valid(string, n6, 1) == BASE64_PAD)) {
                        n = 0;
                        break;
                    }
                } else {
                    short s = table_a2b_base64[c];
                    if (s != -1) {
                        n3 = n3 + 1 & 3;
                        n2 = n2 << 6 | s;
                        if ((n += 6) >= 8) {
                            stringBuffer.append((char)(n2 >> (n -= 8) & 0xFF));
                            ++n5;
                            n2 &= (1 << n) - 1;
                        }
                    }
                }
            }
            --n4;
            ++n6;
        }
        if (n != 0) {
            throw new PyException((PyObject)Error, "Incorrect padding");
        }
        return stringBuffer.toString();
    }

    public static String b2a_base64(String string) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        if (n3 > BASE64_MAXBIN) {
            throw new PyException((PyObject)Error, "Too much data for base64 line");
        }
        int n4 = 0;
        while (n3 > 0) {
            n2 = n2 << 8 | string.charAt(n4);
            n += 8;
            while (n >= 6) {
                char c = (char)(n2 >> n - 6 & 0x3F);
                n -= 6;
                stringBuffer.append((char)table_b2a_base64[c]);
            }
            --n3;
            ++n4;
        }
        if (n == 2) {
            stringBuffer.append((char)table_b2a_base64[(n2 & 3) << 4]);
            stringBuffer.append(BASE64_PAD);
            stringBuffer.append(BASE64_PAD);
        } else if (n == 4) {
            stringBuffer.append((char)table_b2a_base64[(n2 & 0xF) << 2]);
            stringBuffer.append(BASE64_PAD);
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public static PyTuple a2b_hqx(String string) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n3 > 0) {
            char c = (char)table_a2b_hqx[string.charAt(n4)];
            if (c != SKIP) {
                if (c == FAIL) {
                    throw new PyException((PyObject)Error, "Illegal char");
                }
                if (c == DONE) {
                    bl = true;
                    break;
                }
                n2 = n2 << 6 | c;
                if ((n += 6) >= 8) {
                    stringBuffer.append((char)(n2 >> (n -= 8) & 0xFF));
                    n2 &= (1 << n) - 1;
                }
            }
            --n3;
            ++n4;
        }
        if (n != 0 && !bl) {
            throw new PyException((PyObject)Incomplete, "String has incomplete number of bytes");
        }
        return new PyTuple(new PyObject[]{Py.java2py(stringBuffer.toString()), Py.newInteger(bl ? 1 : 0)});
    }

    public static String rlecode_hqx(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == RUNCHAR) {
                stringBuffer.append(RUNCHAR);
                stringBuffer.append(0);
            } else {
                int n3 = n2 + 1;
                while (n3 < n && string.charAt(n3) == c && n3 < n2 + 255) {
                    ++n3;
                }
                if (n3 - n2 > 3) {
                    stringBuffer.append(c);
                    stringBuffer.append(RUNCHAR);
                    stringBuffer.append((char)(n3 - n2));
                    n2 = n3 - 1;
                } else {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String b2a_hqx(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n3 > 0) {
            n2 = n2 << 8 | string.charAt(n4);
            n += 8;
            while (n >= 6) {
                char c = (char)(n2 >> n - 6 & 0x3F);
                n -= 6;
                stringBuffer.append((char)table_b2a_hqx[c]);
            }
            --n3;
            ++n4;
        }
        if (n != 0) {
            stringBuffer.append((char)table_b2a_hqx[(n2 <<= 6 - n) & 0x3F]);
        }
        return stringBuffer.toString();
    }

    public static String rledecode_hqx(String string) {
        char c;
        char c2;
        int n = string.length();
        int n2 = 0;
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (--n < 0) {
            throw new PyException(Incomplete);
        }
        if ((c2 = string.charAt(n2++)) == RUNCHAR) {
            if (--n < 0) {
                throw new PyException(Incomplete);
            }
            if ((c = string.charAt(n2++)) != '\u0000') {
                throw new PyException((PyObject)Error, "Orphaned RLE code at start");
            }
            stringBuffer.append(RUNCHAR);
        } else {
            stringBuffer.append(c2);
        }
        while (n > 0) {
            if (--n < 0) {
                throw new PyException(Incomplete);
            }
            if ((c2 = string.charAt(n2++)) == RUNCHAR) {
                if (--n < 0) {
                    throw new PyException(Incomplete);
                }
                if ((c = string.charAt(n2++)) == '\u0000') {
                    stringBuffer.append(RUNCHAR);
                    continue;
                }
                c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                while ((c = (char)(c - '\u0001')) > '\u0000') {
                    stringBuffer.append(c2);
                }
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static int crc_hqx(String string, int n) {
        int n2 = string.length();
        int n3 = 0;
        while (n2-- > 0) {
            n = n << 8 & 0xFF00 ^ crctab_hqx[n >> 8 & 0xFF ^ string.charAt(n3++)];
        }
        return n;
    }

    public static int crc32(String string) {
        return binascii.crc32(string, 0L);
    }

    public static int crc32(String string, long l) {
        int n = string.length();
        l &= 0xFFFFFFFFL;
        l ^= 0xFFFFFFFFL;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            l = (long)((int)crc_32_tab[(int)((l ^ (long)c) & 0xFFL)]) ^ l >> 8;
            l &= 0xFFFFFFFFL;
            ++n2;
        }
        if (l >= Integer.MIN_VALUE) {
            return -((int)(l + 1L & 0xFFFFFFFFFFFFFFFFL));
        }
        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public static String b2a_hex(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            stringBuffer.append(hexdigit[c >>> 4 & 0xF]);
            stringBuffer.append(hexdigit[c & 0xF]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String hexlify(String string) {
        return binascii.b2a_hex(string);
    }

    public static String a2b_hex(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw Py.TypeError("Odd-length string");
        }
        StringBuffer stringBuffer = new StringBuffer(n / 2);
        int n2 = 0;
        while (n2 < n) {
            int n3 = Character.digit(string.charAt(n2), 16);
            int n4 = Character.digit(string.charAt(n2 + 1), 16);
            if (n3 == -1 || n4 == -1) {
                throw Py.TypeError("Non-hexadecimal digit found");
            }
            stringBuffer.append((char)((n3 << 4) + n4));
            n2 += 2;
        }
        return stringBuffer.toString();
    }

    public static String unhexlify(String string) {
        return binascii.a2b_hex(string);
    }
}

