/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.applicationclient;

import com.ibm.etools.archive.command.ValidateXmlCommand;
import com.ibm.etools.client.ApplicationClient;
import com.ibm.etools.commonarchive.ApplicationClientFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.j2ee.common.EjbRef;
import com.ibm.etools.j2ee.common.ResourceEnvRef;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.applicationclient.ApplicationClientMessageConstants;
import com.ibm.etools.validation.j2ee.J2EEValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;

public class ApplicationClientValidator
extends J2EEValidator
implements ApplicationClientMessageConstants {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected ApplicationClientFile appClientFile;
    protected ApplicationClient appClientDD;

    public String getBaseName() {
        return "applicationclientvalidation";
    }

    public void validate() throws ValidationException {
        this.validateMainClassInManifest();
        this.validateEJBRefs();
        this.validateResourceRefs();
        this.validateResourceEnvRefs();
    }

    protected void validateMainClassInManifest() {
        String string;
        if (this.appClientFile != null && this.appClientFile.getManifest() != null && ((string = this.appClientFile.getManifest().getMainClass()) == null || string.length() == 0)) {
            Object object = this.getManifestTarget();
            this.addError(this.getBaseName(), "APPCLIENT_MAIN_CLASS_ERROR_", new String[0], object);
        }
    }

    protected Object getManifestTarget() {
        return null;
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        super.validate(iHelper, iReporter, iFileDeltaArray);
        try {
            this.setAppClientFile((ApplicationClientFile)iHelper.loadModel("APPLICATIONCLIENT_VALIDATION"));
            if (this.appClientFile == null) {
                Message message = new Message(this.getBaseName(), 1, "ERROR_APPLICATIONCLIENT_INVALID_APPCLIENT_FILE");
                throw new ValidationException((IMessage)message);
            }
            this.setAppClientDD(this.appClientFile.getDeploymentDescriptor());
            this.validate();
        }
        catch (ValidationException validationException) {
            throw validationException;
        }
        catch (Exception exception) {
            Message message = new Message(this.getBaseName(), 1, "ERROR_APPCLIENT_VALIDATION_FAILED");
            throw new ValidationException((IMessage)message, (Throwable)exception);
        }
    }

    public void validateEJBDupicateRefs() {
        EList eList = this.appClientDD.getEjbReferences();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!eList.isEmpty()) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                EjbRef ejbRef = (EjbRef)iterator.next();
                if (ejbRef == null) continue;
                if (arrayList.contains(ejbRef.getName())) {
                    String[] stringArray = new String[]{ejbRef.getName()};
                    this.addError(this.getBaseName(), "APPCLIENT_DUP_EJB_REF_ERROR_", stringArray, this.getAppClientDD());
                    continue;
                }
                arrayList.add(ejbRef.getName());
            }
        }
    }

    public void validateEJBRefs() {
        this.validateEJBDupicateRefs();
        this.validateEJBRefManadatory();
    }

    public void validateEJBRefManadatory() {
        EList eList = this.appClientDD.getEjbReferences();
        if (eList != null && !eList.isEmpty()) {
            int n = 0;
            while (n < eList.size()) {
                EjbRef ejbRef = (EjbRef)eList.get(n);
                if (ejbRef != null) {
                    this.validateEJBRefManadatoryElements(ejbRef, this.appClientDD.getDisplayName());
                }
                ++n;
            }
        }
    }

    public void validateResourceRefs() {
        EList eList = this.appClientDD.getResourceRefs();
        this.validateResourceRefs((List)eList);
    }

    public void validateResourceEnvRefs() {
        EList eList = this.appClientDD.getResourceEnvRefs();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!eList.isEmpty()) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ResourceEnvRef resourceEnvRef = (ResourceEnvRef)iterator.next();
                if (resourceEnvRef == null) continue;
                if (arrayList.contains(resourceEnvRef.getName())) {
                    String[] stringArray = new String[]{resourceEnvRef.getName()};
                    this.addError(this.getBaseName(), "APPCLIENT_DUP_RES_ENV_REF_ERROR_", stringArray, this.getAppClientDD());
                    continue;
                }
                arrayList.add(resourceEnvRef.getName());
            }
        }
    }

    public Command createValidateXMLCommand() {
        ValidateXmlCommand validateXmlCommand = new ValidateXmlCommand((ModuleFile)this.appClientFile);
        return validateXmlCommand;
    }

    public ApplicationClientFile getAppClientFile() {
        return this.appClientFile;
    }

    public void setAppClientFile(ApplicationClientFile applicationClientFile) {
        this.appClientFile = applicationClientFile;
    }

    public ApplicationClient getAppClientDD() {
        return this.appClientDD;
    }

    public void setAppClientDD(ApplicationClient applicationClient) {
        this.appClientDD = applicationClient;
    }
}

