/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ear;

import com.ibm.etools.application.Application;
import com.ibm.etools.application.Module;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.archive.command.ValidateXmlCommand;
import com.ibm.etools.archive.exception.ArchiveWrappedException;
import com.ibm.etools.archive.exception.NoModuleFileException;
import com.ibm.etools.archive.util.EARFileUtil;
import com.ibm.etools.client.ApplicationClient;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.common.EJBLocalRef;
import com.ibm.etools.j2ee.common.EjbRef;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.logger.proxy.Logger;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.IValidator;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ear.EARMessageConstants;
import com.ibm.etools.validation.j2ee.J2EEValidator;
import com.ibm.etools.webapplication.WebApp;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;

public class EarValidator
extends J2EEValidator
implements EARMessageConstants {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected EARFile earFile;
    protected Application appDD;

    public Command createValidateXMLCommand() {
        ValidateXmlCommand validateXmlCommand = new ValidateXmlCommand((ModuleFile)this.earFile);
        return validateXmlCommand;
    }

    public String getBaseName() {
        return "earvalidation";
    }

    public void validate() throws ValidationException {
        this.validateModules(this.appDD.getModules());
        this.validateSecurity();
        this.validateRefs();
        this.validateWebContexts();
        this.validateSpecLevel();
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        iReporter.removeAllMessages((IValidator)this);
        super.validate(iHelper, iReporter, iFileDeltaArray);
        try {
            this.earFile = (EARFile)this._helper.loadModel("EAR_VALIDATION");
            if (this.earFile == null) {
                Message message = new Message(this.getBaseName(), 1, "ERROR_EAR_INVALID_EAR_FILE", new String[]{this.getResourceName()});
                throw new ValidationException((IMessage)message);
            }
            this.appDD = this.earFile.getDeploymentDescriptor();
            this.validate();
        }
        catch (ValidationException validationException) {
            throw validationException;
        }
        catch (Exception exception) {
            String string = exception.getMessage() == null ? exception.toString() : exception.getMessage();
            Message message = new Message(this.getBaseName(), 1, "ERROR_EAR_VALIDATION_FAILED", new String[]{string});
            throw new ValidationException((IMessage)message, (Throwable)exception);
        }
    }

    protected String getResourceName() {
        return this.earFile.getURI();
    }

    public void validateEarRoles(EList eList) {
        HashSet<String> hashSet = new HashSet<String>(eList.size());
        int n = 0;
        while (n < eList.size()) {
            SecurityRole securityRole = (SecurityRole)eList.get(n);
            if (!hashSet.add(securityRole.getRoleName())) {
                String string = securityRole.getRoleName();
                String[] stringArray = new String[]{string};
                this.addWarning(this.getBaseName(), "ERROR_EAR_DUPLICATE_ROLES", stringArray, this.appDD);
            }
            ++n;
        }
    }

    public void validateEJBRefMandatoryElements(EjbRef ejbRef, String string) {
        String string2 = ejbRef.getName();
        String[] stringArray = new String[]{string2, string};
        if (ejbRef.getName().trim() == null || ejbRef.getName().trim().length() == 0) {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFNAME", stringArray);
        }
        if (ejbRef.isSetType()) {
            if (ejbRef.getType() == null) {
                this.addWarning("erefvalidation", "ERROR_EAR_INVALID_EREFTYPE", stringArray);
            }
        } else {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFTYPE", stringArray);
        }
        if (ejbRef.getHome() == null || ejbRef.getHome().trim().length() == 0) {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFHOME", stringArray);
        }
        if (ejbRef.getRemote() == null || ejbRef.getRemote().trim().length() == 0) {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFREMOTE", stringArray);
        }
    }

    public void validateEJBRef(EjbRef ejbRef, String string) {
        if (ejbRef != null && ejbRef.getLink() != null && ejbRef.getLink().length() > 0) {
            EnterpriseBean enterpriseBean = this.earFile.getEnterpiseBeanFromRef(ejbRef, string);
            if (enterpriseBean == null) {
                String[] stringArray = new String[]{ejbRef.getName(), string, this.earFile.getName()};
                this.addWarning("erefvalidation", "UNRESOLVED_EJB_REF_WARN_", stringArray);
            } else if (!this.isSimilarEJBInterface(ejbRef, enterpriseBean)) {
                String[] stringArray = new String[]{enterpriseBean.getName(), ejbRef.getName(), string};
                this.addError(this.getBaseName(), "EJB_BEAN_EJB_LINK_INTEFACE_MISMATCH_ERROR_", stringArray, this.appDD);
            }
        }
    }

    public boolean isSimilarEJBInterface(EjbRef ejbRef, EnterpriseBean enterpriseBean) {
        if (ejbRef.isLocal()) {
            if (enterpriseBean.getLocalHomeInterfaceName() == null || enterpriseBean.getLocalInterfaceName() == null || ((EJBLocalRef)ejbRef).getLocalHome() == null || ((EJBLocalRef)ejbRef).getLocal() == null) {
                return false;
            }
            boolean bl = enterpriseBean.getLocalHomeInterfaceName().equals(((EJBLocalRef)ejbRef).getLocalHome());
            boolean bl2 = enterpriseBean.getLocalInterfaceName().equals(((EJBLocalRef)ejbRef).getLocal());
            return bl && bl2;
        }
        if (enterpriseBean.getHomeInterfaceName() == null || enterpriseBean.getRemoteInterfaceName() == null || ejbRef.getHome() == null || ejbRef.getRemote() == null) {
            return false;
        }
        boolean bl = enterpriseBean.getHomeInterfaceName().equals(ejbRef.getHome());
        boolean bl3 = enterpriseBean.getRemoteInterfaceName().equals(ejbRef.getRemote());
        return bl && bl3;
    }

    public void validateEJBRefs(List list, String string) {
        int n = 0;
        while (n < list.size()) {
            EjbRef ejbRef = (EjbRef)list.get(n);
            this.validateEJBRef(ejbRef, string);
            this.validateEJBRefMandatoryElements(ejbRef, string);
            ++n;
        }
    }

    public void validateEJBRolesWithEARRoles(EList eList, EList eList2) {
        int n = 0;
        while (n < eList2.size()) {
            if (!eList.contains(eList2.get(n))) {
                String[] stringArray = new String[]{((SecurityRole)eList2.get(n)).getRoleName()};
                this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EJB_ROLE", stringArray);
            }
            ++n;
        }
    }

    public void validateModules(EList eList) {
        HashSet<String[]> hashSet = new HashSet<String[]>();
        int n = 0;
        while (n < eList.size()) {
            String[] stringArray;
            String[] stringArray2;
            Module module = (Module)eList.get(n);
            String[] stringArray3 = module.getUri();
            if (stringArray3 == null || stringArray3.length() == 0) {
                this.addError(this.getBaseName(), "MESSAGE_EAR_NO_MODULE_URI", null);
            } else {
                if (stringArray3.indexOf(" ") != -1) {
                    stringArray2 = new String[]{stringArray3};
                    this.addError(this.getBaseName(), "URI_CONTAINS_SPACES_ERROR_", stringArray2, this.appDD);
                }
                try {
                    this.earFile.getFile((String)stringArray3);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    stringArray = new String[]{stringArray3};
                    this.addError(this.getBaseName(), "MESSAGE_EAR_MISSING_URI", stringArray, this.appDD);
                }
            }
            stringArray2 = module.getAltDD();
            if (stringArray2 != null) {
                stringArray2 = stringArray2.trim();
            }
            this.validateAltDD(module, (String)stringArray2);
            String[] stringArray4 = stringArray = stringArray2 == null ? (String)stringArray3 + (String)stringArray2 : stringArray3;
            if (!hashSet.add(stringArray)) {
                String[] stringArray5 = new String[]{module.getUri(), this.earFile.getName()};
                this.addError(this.getBaseName(), "MESSAGE_EAR_DUPLICATE_URI_ERROR_", stringArray5, this.appDD);
            }
            ++n;
        }
    }

    protected void validateAltDD(Module module, String string) {
        if ("".equals(string)) {
            String[] stringArray = new String[]{module.getUri(), this.earFile.getName()};
            this.addError(this.getBaseName(), "MESSAGE_EMPTY_ALT_DD_ERROR_", stringArray, this.appDD);
        } else if (string != null && !this.earFile.isDuplicate(string)) {
            String[] stringArray = new String[]{module.getUri(), string, this.earFile.getName()};
            this.addWarning(this.getBaseName(), "MESSAGE_INVALID_ALT_DD_WARN_", stringArray, this.appDD);
        }
    }

    public void validateRefs() {
        EList eList = this.earFile.getModuleRefs();
        int n = 0;
        while (n < eList.size()) {
            ModuleRef moduleRef;
            List list;
            ArrayList arrayList;
            block14: {
                Exception exception;
                arrayList = Collections.EMPTY_LIST;
                list = Collections.EMPTY_LIST;
                moduleRef = (ModuleRef)eList.get(n);
                try {
                    WebApp webApp;
                    if (moduleRef.isWeb()) {
                        webApp = (WebApp)moduleRef.getDeploymentDescriptor();
                        if (webApp != null) {
                            arrayList = new ArrayList();
                            this.addEJBRefs((List)webApp.getEjbRefs(), arrayList);
                            this.addEJBRefs((List)webApp.getEjbLocalRefs(), arrayList);
                            list = webApp.getResourceRefs();
                        }
                    } else if (moduleRef.isClient()) {
                        webApp = (ApplicationClient)moduleRef.getDeploymentDescriptor();
                        if (webApp != null) {
                            arrayList = new ArrayList();
                            this.addEJBRefs((List)webApp.getEjbReferences(), arrayList);
                            list = webApp.getResourceRefs();
                        }
                    } else if (moduleRef.isEJB() && (webApp = (EJBJar)moduleRef.getDeploymentDescriptor()) != null) {
                        exception = webApp.getEnterpriseBeans();
                        arrayList = new ArrayList();
                        if (exception != null || !exception.isEmpty()) {
                            Iterator iterator = exception.iterator();
                            while (iterator.hasNext()) {
                                EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
                                if (enterpriseBean == null) continue;
                                this.addEJBRefs((List)enterpriseBean.getEjbRefs(), arrayList);
                                this.addEJBRefs((List)enterpriseBean.getEjbLocalRefs(), arrayList);
                            }
                        }
                    }
                }
                catch (ArchiveWrappedException archiveWrappedException) {
                    exception = archiveWrappedException.getNestedException();
                    if (exception instanceof NoModuleFileException) break block14;
                    Logger.getLogger().logError((Throwable)archiveWrappedException);
                }
            }
            if (!arrayList.isEmpty()) {
                this.validateEJBRefs(arrayList, moduleRef.getUri());
            }
            if (!list.isEmpty()) {
                this.validateResourceRefs(list);
            }
            ++n;
        }
    }

    public void addEJBRefs(List list, List list2) {
        if (list == null || list2 == null) {
            return;
        }
        list2.addAll(list);
    }

    public void validateSecurity() {
        EList eList;
        EList eList2 = this.appDD.getSecurityRoles();
        if (!eList2.isEmpty()) {
            this.validateEarRoles(eList2);
        }
        if (!(eList = this.appDD.getModules()).isEmpty()) {
            int n = 0;
            while (n < eList.size()) {
                EList eList3;
                Module module = (Module)eList.get(n);
                if (module.isEjbModule() && !(eList3 = module.getApplication().getSecurityRoles()).isEmpty()) {
                    this.validateEJBRolesWithEARRoles(eList2, eList3);
                }
                if (module.isWebModule() && !(eList3 = module.getApplication().getSecurityRoles()).isEmpty()) {
                    this.validateWEBRolesWithEARRoles(eList2, eList3);
                }
                ++n;
            }
        }
    }

    public void validateWebContexts() {
        EList eList = this.appDD.getModules();
        HashMap<String, WebModule> hashMap = new HashMap<String, WebModule>();
        if (!eList.isEmpty()) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                WebModule webModule;
                Module module = (Module)iterator.next();
                if (!module.isWebModule() || (webModule = (WebModule)module) == null) continue;
                if (hashMap.containsKey(webModule.getContextRoot())) {
                    WebModule webModule2 = (WebModule)hashMap.get(webModule.getContextRoot());
                    String[] stringArray = new String[]{webModule.getContextRoot(), webModule.getUri(), webModule2.getUri()};
                    this.addError(this.getBaseName(), "MESSAGE_EAR_DUPICATE_ROOTCONTEXT_ERROR_", stringArray, this.appDD);
                    continue;
                }
                hashMap.put(webModule.getContextRoot(), webModule);
            }
        }
    }

    public void validateSpecLevel() {
        List list = EARFileUtil.getIncompatibleModuleFiles((EARFile)this.earFile);
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ModuleFile moduleFile = (ModuleFile)iterator.next();
                if (moduleFile == null) continue;
                String[] stringArray = new String[]{moduleFile.getURI()};
                this.addWarning(this.getBaseName(), "MESSAGE_INCOMPATIBLE_SPEC_ERROR_", stringArray, this.appDD);
            }
        }
    }
}

