/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb;

import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.validation.ejb.ITypeConstants;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import java.util.Arrays;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class ClassUtility {
    public static long supertype_counter = 1L;
    private long[] _classTypeIndex;
    private AClassType[] _classNames;
    private static ClassUtility _inst = null;

    private ClassUtility() {
        this.buildTypeList();
    }

    public static ClassUtility getUtility() {
        if (_inst == null) {
            _inst = new ClassUtility();
        }
        return _inst;
    }

    public boolean isClassType(EnterpriseBean enterpriseBean, JavaClass javaClass, long l) throws InvalidInputException {
        AClassType aClassType = this.getClassType(l);
        if (aClassType == null) {
            return false;
        }
        return aClassType.equals(enterpriseBean, javaClass);
    }

    public String getClassName(EnterpriseBean enterpriseBean, long l) throws InvalidInputException {
        AClassType aClassType = this.getClassType(l);
        if (aClassType == null) {
            return null;
        }
        return aClassType.getName(enterpriseBean);
    }

    public AClassType getClassType(long l) {
        int n = Arrays.binarySearch(this._classTypeIndex, l);
        if (n > this._classNames.length) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        if (this._classNames[n].getId() != l) {
            return null;
        }
        return this._classNames[n];
    }

    public JavaHelpers getSupertype(EnterpriseBean enterpriseBean, long l) throws InvalidInputException {
        AClassType aClassType = this.getClassType(l);
        if (aClassType == null) {
            return null;
        }
        return aClassType.getClass(enterpriseBean);
    }

    private void buildTypeList() {
        int n = 12;
        this._classTypeIndex = new long[n];
        this._classNames = new AClassType[n];
        int n2 = 0;
        this._classTypeIndex[n2] = ITypeConstants.LOCAL_COMPONENT_INTERFACE;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                JavaHelpers javaHelpers = this.getClass(enterpriseBean);
                if (javaHelpers == null) {
                    return null;
                }
                return javaHelpers.getQualifiedName();
            }

            public long getId() {
                return ITypeConstants.LOCAL_COMPONENT_INTERFACE;
            }

            public JavaHelpers getClass(EnterpriseBean enterpriseBean) {
                if (enterpriseBean == null) {
                    return null;
                }
                if (enterpriseBean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalInterface())) {
                    JavaClass javaClass = enterpriseBean.getLocalInterface();
                    try {
                        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass);
                    }
                    catch (InvalidInputException invalidInputException) {
                        return null;
                    }
                    return javaClass;
                }
                return null;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.REMOTE_COMPONENT_INTERFACE;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                JavaHelpers javaHelpers = this.getClass(enterpriseBean);
                if (javaHelpers == null) {
                    return null;
                }
                return javaHelpers.getQualifiedName();
            }

            public long getId() {
                return ITypeConstants.REMOTE_COMPONENT_INTERFACE;
            }

            public JavaHelpers getClass(EnterpriseBean enterpriseBean) {
                if (enterpriseBean == null) {
                    return null;
                }
                if (enterpriseBean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_RemoteInterface())) {
                    JavaClass javaClass = enterpriseBean.getRemoteInterface();
                    try {
                        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass);
                    }
                    catch (InvalidInputException invalidInputException) {
                        return null;
                    }
                    return javaClass;
                }
                return null;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.JAVAX_EJB_ENTITYBEAN;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                return "javax.ejb.EntityBean";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_ENTITYBEAN;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.JAVAX_EJB_EJBLOCALHOME;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                return "javax.ejb.EJBLocalHome";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_EJBLOCALHOME;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.JAVAX_EJB_EJBLOCALOBJECT;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                return "javax.ejb.EJBLocalObject";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_EJBLOCALOBJECT;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.JAVAX_EJB_EJBHOME;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                return "javax.ejb.EJBHome";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_EJBHOME;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.JAVAX_EJB_EJBOBJECT;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                return "javax.ejb.EJBObject";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_EJBOBJECT;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.JAVA_LANG_OBJECT;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                return "java.lang.Object";
            }

            public long getId() {
                return ITypeConstants.JAVA_LANG_OBJECT;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.JAVAX_EJB_MESSAGEDRIVENBEAN;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                return "javax.ejb.MessageDrivenBean";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_MESSAGEDRIVENBEAN;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.JAVAX_JMS_MESSAGELISTENER;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                return "javax.jms.MessageListener";
            }

            public long getId() {
                return ITypeConstants.JAVAX_JMS_MESSAGELISTENER;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.JAVAX_EJB_SESSIONBEAN;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                return "javax.ejb.SessionBean";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_SESSIONBEAN;
            }
        };
        this._classTypeIndex[n2] = ITypeConstants.JAVAX_EJB_SESSIONSYNCHRONIZATION;
        this._classNames[n2++] = new AClassType(){

            public String getName(EnterpriseBean enterpriseBean) {
                return "javax.ejb.SessionSynchronization";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_SESSIONSYNCHRONIZATION;
            }
        };
    }

    private abstract class AClassType {
        private AClassType() {
        }

        public abstract String getName(EnterpriseBean var1) throws InvalidInputException;

        public abstract long getId();

        public JavaHelpers getClass(EnterpriseBean enterpriseBean) throws InvalidInputException {
            return ValidationRuleUtility.getType(this.getName(enterpriseBean), enterpriseBean);
        }

        public boolean equals(EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
            if (javaClass == null) {
                return false;
            }
            JavaHelpers javaHelpers = this.getClass(enterpriseBean);
            if (javaHelpers == null) {
                return false;
            }
            return javaClass.equals(javaHelpers);
        }
    }
}

