/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb;

import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.IValidator;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.MessageLimitException;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.LogEntry;
import com.ibm.etools.validation.ejb.Logger;
import com.ibm.etools.validation.ejb.ValidationCancelledException;

public class EJBValidationContext
implements IValidationContext {
    private IValidator _validator = null;
    private IHelper _helper = null;
    private IReporter _reporter = null;

    public EJBValidationContext(IValidator iValidator, IHelper iHelper, IReporter iReporter) {
        this.setValidator(iValidator);
        this.setHelper(iHelper);
        this.setReporter(iReporter);
    }

    public IValidator getValidator() {
        return this._validator;
    }

    public void setValidator(IValidator iValidator) {
        this._validator = iValidator;
    }

    public IHelper getHelper() {
        return this._helper;
    }

    public void setHelper(IHelper iHelper) {
        this._helper = iHelper;
    }

    public IReporter getReporter() {
        return this._reporter;
    }

    public void setReporter(IReporter iReporter) {
        this._reporter = iReporter;
    }

    public IMessage getMessage() {
        Message message = new Message();
        message.setBundleName("ejbvalidator");
        return message;
    }

    protected void reset(IMessage iMessage) {
        iMessage.setId(null);
        iMessage.setParams(null);
        iMessage.setSeverity(-1);
        iMessage.setTargetObject(null);
        iMessage.setBundleName(null);
        iMessage.setGroupName(null);
        iMessage.setLineNo(0);
        iMessage.setOffset(-1);
        iMessage.setLength(-1);
    }

    public MsgLogger getMsgLogger() {
        return Logger.getMsgLogger();
    }

    public LogEntry getLogEntry() {
        return Logger.getLogEntry();
    }

    public Object loadModel(String string) {
        return this.getHelper().loadModel(string);
    }

    public Object loadModel(String string, Object[] objectArray) {
        return this.getHelper().loadModel(string, objectArray);
    }

    public void removeAllMessages() {
        this.getReporter().removeAllMessages(this.getValidator());
    }

    public void removeMessages(Object object) {
        this.getReporter().removeAllMessages(this.getValidator(), object);
    }

    public void removeMessages(Object object, String string) {
        this.getReporter().removeMessageSubset(this.getValidator(), object, string);
    }

    public void addMessage(IMessage iMessage) throws MessageLimitException {
        if (iMessage == null) {
            return;
        }
        this.getReporter().addMessage(this.getValidator(), iMessage);
    }

    public void addMessage(int n, String string) throws MessageLimitException {
        IMessage iMessage = this.getMessage();
        iMessage.setSeverity(n);
        iMessage.setId(string);
        this.getReporter().addMessage(this.getValidator(), iMessage);
    }

    public void addMessage(int n, String string, String[] stringArray) throws MessageLimitException {
        IMessage iMessage = this.getMessage();
        iMessage.setSeverity(n);
        iMessage.setId(string);
        iMessage.setParams(stringArray);
        this.getReporter().addMessage(this.getValidator(), iMessage);
    }

    public void addMessage(int n, String string, Object object) throws MessageLimitException {
        IMessage iMessage = this.getMessage();
        iMessage.setSeverity(n);
        iMessage.setId(string);
        iMessage.setTargetObject(object);
        this.getReporter().addMessage(this.getValidator(), iMessage);
    }

    public void addMessage(int n, String string, String[] stringArray, Object object) throws MessageLimitException {
        IMessage iMessage = this.getMessage();
        iMessage.setSeverity(n);
        iMessage.setId(string);
        iMessage.setParams(stringArray);
        iMessage.setTargetObject(object);
        this.getReporter().addMessage(this.getValidator(), iMessage);
    }

    public void addMessage(int n, String string, Object object, String string2) throws MessageLimitException {
        IMessage iMessage = this.getMessage();
        iMessage.setSeverity(n);
        iMessage.setId(string);
        iMessage.setTargetObject(object);
        iMessage.setGroupName(string2);
        this.getReporter().addMessage(this.getValidator(), iMessage);
    }

    public void addMessage(int n, String string, String[] stringArray, Object object, String string2) throws MessageLimitException {
        IMessage iMessage = this.getMessage();
        iMessage.setSeverity(n);
        iMessage.setId(string);
        iMessage.setParams(stringArray);
        iMessage.setTargetObject(object);
        iMessage.setGroupName(string2);
        this.getReporter().addMessage(this.getValidator(), iMessage);
    }

    public void terminateIfCancelled() throws ValidationCancelledException {
        if (this.getReporter().isCancelled()) {
            throw new ValidationCancelledException();
        }
    }

    public void subtask(String string) {
        this.subtask(string, null);
    }

    public void subtask(String string, String[] stringArray) {
        if (string == null || string.equals("")) {
            return;
        }
        IMessage iMessage = this.getMessage();
        iMessage.setId(string);
        iMessage.setParams(stringArray);
        this.getReporter().displaySubtask(this.getValidator(), iMessage);
    }
}

