/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb;

import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.IValidator;
import com.ibm.etools.validation.MessageLimitException;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.EJBValidationContext;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.LogEntry;
import com.ibm.etools.validation.ejb.Logger;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class EJBValidator
implements IValidator {
    private static EJBValidator _inst = null;
    private Map _validated = new HashMap();
    private IValidationContext _vc = null;
    private static TargetObjectPool _targetObjectPoolSingleton = null;

    public void cleanup(IReporter iReporter) {
        Iterator iterator = this._validated.keySet().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)this._validated.get(iterator.next());
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                TargetObject targetObject = (TargetObject)iterator2.next();
                EJBValidator.getTargetObjectPool().release(targetObject);
            }
            set.clear();
        }
        this._validated.clear();
        this._vc = null;
    }

    public EJBValidator() {
        _inst = this;
    }

    public static EJBValidator getValidator() {
        return _inst;
    }

    public void setValidated(Object object, Object object2, Object object3) {
        Set<TargetObject> set = null;
        set = this._validated.containsKey(object) ? (Set)this._validated.get(object) : new HashSet<TargetObject>();
        set.add(EJBValidator.getTargetObjectPool().getTargetObject(object2, object3));
        this._validated.put(object, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidated(Object object, Object object2, Object object3) {
        TargetObject targetObject;
        block4: {
            if (!this._validated.containsKey(object)) {
                return false;
            }
            Set set = (Set)this._validated.get(object);
            targetObject = EJBValidator.getTargetObjectPool().getTargetObject(object2, object3);
            try {
                if (!set.contains(targetObject)) break block4;
                boolean bl = true;
                Object var8_8 = null;
                EJBValidator.getTargetObjectPool().release(targetObject);
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                EJBValidator.getTargetObjectPool().release(targetObject);
                throw throwable;
            }
        }
        boolean bl = false;
        Object var8_9 = null;
        EJBValidator.getTargetObjectPool().release(targetObject);
        return bl;
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        long l = System.currentTimeMillis();
        MsgLogger msgLogger = Logger.getMsgLogger();
        if (msgLogger.isLoggingLevel(6)) {
            long l2 = System.currentTimeMillis();
            LogEntry logEntry = Logger.getLogEntry();
            logEntry.setSourceID("EJBValidator::validate");
            logEntry.setText("validate took " + (l2 - l) + " milliseconds.");
            msgLogger.write(6, (Object)logEntry);
        }
        EJBValidationContext eJBValidationContext = new EJBValidationContext(this, iHelper, iReporter);
        this.setValidationContext(eJBValidationContext);
        if (this.isFullValidate(eJBValidationContext, iFileDeltaArray)) {
            this.fullValidate(eJBValidationContext);
        } else {
            this.incrementalValidate(eJBValidationContext, iFileDeltaArray);
        }
        if (msgLogger.isLoggingLevel(6)) {
            long l3 = System.currentTimeMillis();
            LogEntry logEntry = Logger.getLogEntry();
            logEntry.setSourceID("EJBValidator::validate");
            logEntry.setText("validate took " + (l3 - l) + " milliseconds.");
            msgLogger.write(6, (Object)logEntry);
        }
    }

    public boolean isFullValidate(IValidationContext iValidationContext, IFileDelta[] iFileDeltaArray) {
        if (iFileDeltaArray == null) {
            return true;
        }
        if (iFileDeltaArray.length == 0) {
            return true;
        }
        int n = 0;
        while (n < iFileDeltaArray.length) {
            IFileDelta iFileDelta = iFileDeltaArray[n];
            if (iFileDelta.getFileName().endsWith("ejb-jar.xml")) {
                iValidationContext.removeAllMessages();
                return true;
            }
            ++n;
        }
        return false;
    }

    private IValidationContext getValidationContext() {
        return this._vc;
    }

    private void setValidationContext(IValidationContext iValidationContext) {
        this._vc = iValidationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IValidationRule iValidationRule, Object object, Object object2, boolean bl) throws ValidationException {
        block9: {
            if (this.isValidated(iValidationRule.getId(), object, object2)) {
                return;
            }
            if (!bl) {
                this.getValidationContext().removeMessages(object2, MessageUtility.getGroupName(object));
            }
            try {
                try {
                    iValidationRule.preValidate(this.getValidationContext(), object, object2);
                    iValidationRule.validate(this.getValidationContext(), object, object2);
                    iValidationRule.postValidate(this.getValidationContext(), object, object2);
                }
                catch (ValidationCancelledException validationCancelledException) {
                    Object var10_6 = null;
                    this.setValidated(iValidationRule.getId(), object, object2);
                    ValidationRuleFactory.getFactory().release(iValidationRule);
                    break block9;
                }
                catch (ValidationException validationException) {
                    throw validationException;
                }
                catch (MessageLimitException messageLimitException) {
                    throw messageLimitException;
                }
                catch (Throwable throwable) {
                    this.addInternalErrorMessage(this.getValidationContext(), throwable);
                    Object var10_7 = null;
                    this.setValidated(iValidationRule.getId(), object, object2);
                    ValidationRuleFactory.getFactory().release(iValidationRule);
                }
                Object var10_5 = null;
                this.setValidated(iValidationRule.getId(), object, object2);
                ValidationRuleFactory.getFactory().release(iValidationRule);
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.setValidated(iValidationRule.getId(), object, object2);
                ValidationRuleFactory.getFactory().release(iValidationRule);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDependents(IValidationContext iValidationContext, IValidationRule iValidationRule, Object object, Object object2) throws ValidationException {
        Set set = iValidationRule.getDependents();
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object var12_12;
            try {
                block9: {
                    try {
                        IValidationRule iValidationRule2 = (IValidationRule)iterator.next();
                        Object object3 = iValidationRule2.getTarget(object, object2);
                        if (object3 == null) break block9;
                        this.run(iValidationRule2, object, object3, false);
                    }
                    catch (ValidationCancelledException validationCancelledException) {
                        throw validationCancelledException;
                    }
                    catch (ValidationException validationException) {
                        throw validationException;
                    }
                    catch (MessageLimitException messageLimitException) {
                        throw messageLimitException;
                    }
                    catch (Throwable throwable) {
                        this.addInternalErrorMessage(this.getValidationContext(), throwable);
                        var12_12 = null;
                        ValidationRuleFactory.getFactory().release(iValidationRule);
                        continue;
                    }
                }
                var12_12 = null;
                ValidationRuleFactory.getFactory().release(iValidationRule);
            }
            catch (Throwable throwable) {
                var12_12 = null;
                ValidationRuleFactory.getFactory().release(iValidationRule);
                throw throwable;
            }
        }
    }

    private void addInternalErrorMessage(IValidationContext iValidationContext) {
        this.addInternalErrorMessage(iValidationContext, null);
    }

    private void addInternalErrorMessage(IValidationContext iValidationContext, Throwable throwable) {
        MsgLogger msgLogger;
        IMessage iMessage = iValidationContext.getMessage();
        iMessage.setId("CHKJ2900");
        iValidationContext.addMessage(iMessage);
        if (throwable != null && (msgLogger = iValidationContext.getMsgLogger()).isLoggingLevel(4)) {
            msgLogger.write(4, (Object)throwable);
        }
    }

    private void logMissingRule(IValidationContext iValidationContext, Object object) {
        MsgLogger msgLogger = iValidationContext.getMsgLogger();
        if (msgLogger.isLoggingLevel(4)) {
            msgLogger.write(4, (Object)(object + " = null"));
        }
        this.addInternalErrorMessage(iValidationContext);
    }

    public void fullValidate(IValidationContext iValidationContext) throws ValidationException {
        EJBJar eJBJar = (EJBJar)iValidationContext.loadModel("EJB_MODEL");
        if (eJBJar == null) {
            IMessage iMessage = iValidationContext.getMessage();
            iMessage.setId("CHKJ2905");
            iValidationContext.addMessage(iMessage);
            return;
        }
        Object object = ValidationRuleFactory.getFactory().getRuleId(iValidationContext, "ejb-jar.xml");
        if (object == null) {
            this.logMissingRule(iValidationContext, "ejb-jar.xml");
            return;
        }
        IValidationRule iValidationRule = ValidationRuleFactory.getFactory().getRule(iValidationContext, object);
        if (iValidationRule == null) {
            this.logMissingRule(iValidationContext, object);
            return;
        }
        this.run(iValidationRule, null, eJBJar, true);
        object = ValidationRuleFactory.getFactory().getRuleId(iValidationContext, "META-INF/ibm-ejb-jar-ext.xmi");
        if (object == null) {
            this.logMissingRule(iValidationContext, "META-INF/ibm-ejb-jar-ext.xmi");
            return;
        }
        IValidationRule iValidationRule2 = ValidationRuleFactory.getFactory().getRule(iValidationContext, object);
        if (iValidationRule2 == null) {
            this.logMissingRule(iValidationContext, object);
            return;
        }
        this.run(iValidationRule2, null, eJBJar, true);
        EList eList = eJBJar.getEnterpriseBeans();
        Iterator iterator = eList.iterator();
        object = null;
        while (iterator.hasNext()) {
            EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
            JavaClass[] javaClassArray = this.getJavaClass(enterpriseBean);
            int n = 0;
            while (n < javaClassArray.length) {
                JavaClass javaClass = javaClassArray[n];
                object = ValidationRuleFactory.getFactory().getRuleId(iValidationContext, javaClass, enterpriseBean);
                IValidationRule iValidationRule3 = ValidationRuleFactory.getFactory().getRule(iValidationContext, object);
                if (iValidationRule3 != null) {
                    this.run(iValidationRule3, enterpriseBean, javaClass, true);
                }
                ++n;
            }
        }
    }

    protected JavaClass[] getJavaClass(EnterpriseBean enterpriseBean) {
        JavaClass[] javaClassArray;
        JavaClass javaClass;
        JavaClass javaClass2;
        JavaClass javaClass3;
        JavaClass javaClass4;
        int n = 0;
        JavaClass[] javaClassArray2 = new JavaClass[6];
        JavaClass javaClass5 = enterpriseBean.getEjbClass();
        if (javaClass5 != null && javaClass5.isExistingType()) {
            javaClassArray2[n++] = javaClass5;
        }
        if ((javaClass4 = enterpriseBean.getRemoteInterface()) != null && javaClass4.isExistingType()) {
            javaClassArray2[n++] = javaClass4;
        }
        if ((javaClass3 = enterpriseBean.getLocalInterface()) != null && javaClass3.isExistingType()) {
            javaClassArray2[n++] = javaClass3;
        }
        if ((javaClass2 = enterpriseBean.getHomeInterface()) != null && javaClass2.isExistingType()) {
            javaClassArray2[n++] = javaClass2;
        }
        if ((javaClass = enterpriseBean.getLocalHomeInterface()) != null && javaClass.isExistingType()) {
            javaClassArray2[n++] = javaClass;
        }
        if (enterpriseBean instanceof Entity && (javaClassArray = ((Entity)enterpriseBean).getPrimaryKey()) != null && javaClassArray.isExistingType()) {
            javaClassArray2[n++] = javaClassArray;
        }
        if (n == 6) {
            return javaClassArray2;
        }
        javaClassArray = new JavaClass[n];
        System.arraycopy(javaClassArray2, 0, javaClassArray, 0, n);
        return javaClassArray;
    }

    public void incrementalValidate(IValidationContext iValidationContext, IFileDelta[] iFileDeltaArray) throws ValidationException {
        Object object;
        JavaClass[] javaClassArray;
        Collection collection;
        IValidationRule iValidationRule;
        Object object2;
        Object object3;
        IFileDelta iFileDelta;
        int n = 0;
        while (n < iFileDeltaArray.length) {
            iFileDelta = iFileDeltaArray[n];
            if (iFileDelta != null && iFileDelta.getFileName() != null) {
                object3 = ValidationRuleFactory.getFactory().getRuleId(iValidationContext, iFileDelta);
                if (object3 == null) {
                    if (iFileDelta.getDeltaType() == 3) {
                        object2 = (EJBJar)iValidationContext.loadModel("EJB_MODEL");
                        if (object2 != null) {
                            object3 = ValidationRuleFactory.getFactory().getRuleId(iValidationContext, "ejb-jar.xml");
                            if (object3 == null) {
                                this.logMissingRule(iValidationContext, object3);
                            } else {
                                iValidationRule = ValidationRuleFactory.getFactory().getRule(iValidationContext, object3);
                                if (iValidationRule == null) {
                                    this.logMissingRule(iValidationContext, object3);
                                } else {
                                    this.run(iValidationRule, null, object2, false);
                                }
                            }
                        }
                    } else {
                        object2 = (Object[])iValidationContext.loadModel(iFileDelta.getFileName(), null);
                        if (object2 == null) {
                            this.logMissingRule(iValidationContext, object3);
                        } else {
                            iValidationRule = (JavaClass)object2[0];
                            collection = (List)object2[1];
                            if (collection != null && collection.size() != 0) {
                                javaClassArray = collection.iterator();
                                while (javaClassArray.hasNext()) {
                                    object = (EnterpriseBean)javaClassArray.next();
                                    object3 = ValidationRuleFactory.getFactory().getRuleId(iValidationContext, (JavaClass)iValidationRule, (EnterpriseBean)object);
                                    IValidationRule iValidationRule2 = ValidationRuleFactory.getFactory().getRule(iValidationContext, object3);
                                    if (iValidationRule2 == null) continue;
                                    this.run(iValidationRule2, object, iValidationRule, false);
                                }
                            }
                            if ((javaClassArray = (JavaClass[])iValidationContext.loadModel("children", new Object[]{iValidationRule})) != null && javaClassArray.length != 0) {
                                object = null;
                                int n2 = 0;
                                while (n2 < javaClassArray.length) {
                                    JavaClass javaClass = javaClassArray[n2];
                                    collection = (List)iValidationContext.loadModel("EJB", new Object[]{javaClass});
                                    if (collection != null && collection.size() != 0) {
                                        object = collection.iterator();
                                        while (object.hasNext()) {
                                            EnterpriseBean enterpriseBean = (EnterpriseBean)object.next();
                                            object3 = ValidationRuleFactory.getFactory().getRuleId(iValidationContext, javaClass, enterpriseBean);
                                            IValidationRule iValidationRule3 = ValidationRuleFactory.getFactory().getRule(iValidationContext, object3);
                                            if (iValidationRule3 == null) continue;
                                            this.run(iValidationRule3, enterpriseBean, javaClass, false);
                                        }
                                    }
                                    ++n2;
                                }
                            }
                        }
                    }
                } else {
                    object2 = (EJBJar)iValidationContext.loadModel("EJB_MODEL");
                    if (object2 != null && (iValidationRule = ValidationRuleFactory.getFactory().getRule(iValidationContext, object3)) != null) {
                        this.run(iValidationRule, null, object2, false);
                    }
                }
            }
            ++n;
        }
        iFileDelta = new HashMap();
        iFileDelta.putAll(this._validated);
        object3 = iFileDelta.keySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            iValidationRule = ValidationRuleFactory.getFactory().getRule(iValidationContext, object2);
            if (iValidationRule == null || (collection = (Set)iFileDelta.get(object2)) == null) continue;
            javaClassArray = collection.iterator();
            while (javaClassArray.hasNext()) {
                object = (TargetObject)javaClassArray.next();
                this.runDependents(iValidationContext, iValidationRule, ((TargetObject)object).getTargetParent(), ((TargetObject)object).getTarget());
            }
        }
        iFileDelta.clear();
    }

    private static TargetObjectPool getTargetObjectPool() {
        if (_targetObjectPoolSingleton == null) {
            EJBValidator eJBValidator = EJBValidator.getValidator();
            eJBValidator.getClass();
            _targetObjectPoolSingleton = eJBValidator.new TargetObjectPool(100);
        }
        return _targetObjectPoolSingleton;
    }

    private class TargetObjectPool {
        private int _growSize = 0;
        private Vector _pool = null;

        public TargetObjectPool(int n) {
            this._growSize = n;
            this._pool = new Vector(n, this._growSize);
            this.grow();
        }

        private void grow() {
            int n = 0;
            while (n < this._growSize) {
                this._pool.add(new TargetObject());
                ++n;
            }
        }

        public TargetObject getTargetObject(Object object, Object object2) {
            if (this._pool.size() <= 0) {
                this.grow();
            }
            TargetObject targetObject = (TargetObject)this._pool.remove(0);
            targetObject.setTargetParent(object);
            targetObject.setTarget(object2);
            return targetObject;
        }

        public void release(TargetObject targetObject) {
            targetObject.setTargetParent(null);
            targetObject.setTarget(null);
            this._pool.add(targetObject);
        }
    }

    private class TargetObject {
        private Object _parent = null;
        private Object _target = null;

        public Object getTargetParent() {
            return this._parent;
        }

        public Object getTarget() {
            return this._target;
        }

        public void setTargetParent(Object object) {
            this._parent = object;
        }

        public void setTarget(Object object) {
            this._target = object;
        }

        public int hashCode() {
            int n = this.getTargetParent() == null ? 0 : this.getTargetParent().hashCode();
            int n2 = this.getTarget() == null ? 0 : this.getTarget().hashCode();
            return n + n2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof TargetObject)) {
                return false;
            }
            Object object2 = this.getTargetParent();
            Object object3 = ((TargetObject)object).getTargetParent();
            Object object4 = this.getTarget();
            Object object5 = ((TargetObject)object).getTarget();
            if (object2 != null || object3 != null) {
                if (object2 != null && object3 != null) {
                    if (!object2.equals(object3)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (object4 == null && object5 == null) {
                return true;
            }
            if (object4 != null && object5 != null) {
                return object4.equals(object5);
            }
            return false;
        }
    }
}

