/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb;

import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.IValidationRuleList;
import com.ibm.etools.validation.ejb.Logger;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.EJBExt11VRule;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.EJBJar11VRule;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.EnterpriseBean11VRule;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateBMPBean;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateBMPHome;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateBMPKey;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateBMPRemote;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateCMPBean;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateCMPHome;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateCMPKey;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateCMPRemote;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateSessionBean;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateSessionHome;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.ValidateSessionRemote;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.BMPBeanClassVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.BMPKeyClassVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.BMPLocalComponentVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.BMPLocalHomeVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.BMPRemoteComponentVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.BMPRemoteHomeVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.CMPBeanClassVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.CMPKeyClassVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.CMPLocalComponentVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.CMPLocalHomeVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.CMPRemoteComponentVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.CMPRemoteHomeVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.EJBExt20VRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.EJBJar20VRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.EnterpriseBean20VRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.MessageDrivenBeanClassVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.StatefulSessionBeanClassVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.StatefulSessionLocalComponentVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.StatefulSessionLocalHomeVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.StatefulSessionRemoteComponentVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.StatefulSessionRemoteHomeVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.StatelessSessionBeanClassVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.StatelessSessionLocalComponentVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.StatelessSessionLocalHomeVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.StatelessSessionRemoteComponentVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.StatelessSessionRemoteHomeVRule;
import java.util.HashMap;
import java.util.Iterator;

public class ValidationRuleFactory {
    private HashMap _ruleList = null;
    private static ValidationRuleFactory _inst = null;

    private ValidationRuleFactory() {
        this.createRuleList();
    }

    public static ValidationRuleFactory getFactory() {
        if (_inst == null) {
            _inst = new ValidationRuleFactory();
        }
        return _inst;
    }

    public IValidationRule getRule(IValidationContext iValidationContext, Object object) {
        Object v = this._ruleList.get(object);
        if (v == null) {
            MsgLogger msgLogger = iValidationContext.getMsgLogger();
            if (msgLogger.isLoggingLevel(5)) {
                msgLogger.write(5, (Object)("Cannot load rule from ruleId: " + object));
            }
            return null;
        }
        return (IValidationRule)v;
    }

    public void release(IValidationRule iValidationRule) {
        if (iValidationRule == null) {
            return;
        }
        iValidationRule.reset();
    }

    private void createRuleList() {
        Object object;
        Object object2;
        Object object3;
        this._ruleList = new HashMap();
        this._ruleList.put(IValidationRuleList.EJB11_EJBJAR, new EJBJar11VRule());
        this._ruleList.put(IValidationRuleList.EJB11_EJBEXT, new EJBExt11VRule());
        this._ruleList.put(IValidationRuleList.EJB20_EJBJAR, new EJBJar20VRule());
        this._ruleList.put(IValidationRuleList.EJB20_EJBEXT, new EJBExt20VRule());
        this._ruleList.put(IValidationRuleList.EJB11_ENTERPRISEBEAN, new EnterpriseBean11VRule());
        this._ruleList.put(IValidationRuleList.EJB20_ENTERPRISEBEAN, new EnterpriseBean20VRule());
        this._ruleList.put(IValidationRuleList.EJB11_SESSION_BEANCLASS, new ValidateSessionBean());
        this._ruleList.put(IValidationRuleList.EJB11_SESSION_REMOTE, new ValidateSessionRemote());
        this._ruleList.put(IValidationRuleList.EJB11_SESSION_HOME, new ValidateSessionHome());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_BEANCLASS, new StatelessSessionBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_REMOTE, new StatelessSessionRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_HOME, new StatelessSessionRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_LOCAL, new StatelessSessionLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_LOCALHOME, new StatelessSessionLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS, new StatefulSessionBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE, new StatefulSessionRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_HOME, new StatefulSessionRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL, new StatefulSessionLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME, new StatefulSessionLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB11_CMP_BEANCLASS, new ValidateCMPBean());
        this._ruleList.put(IValidationRuleList.EJB11_CMP_REMOTE, new ValidateCMPRemote());
        this._ruleList.put(IValidationRuleList.EJB11_CMP_HOME, new ValidateCMPHome());
        this._ruleList.put(IValidationRuleList.EJB11_CMP_KEYCLASS, new ValidateCMPKey());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_BEANCLASS, new CMPBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_REMOTE, new CMPRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_HOME, new CMPRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_LOCAL, new CMPLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_LOCALHOME, new CMPLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_KEYCLASS, new CMPKeyClassVRule());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_BEANCLASS, new ValidateBMPBean());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_REMOTE, new ValidateBMPRemote());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_HOME, new ValidateBMPHome());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_KEYCLASS, new ValidateBMPKey());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_BEANCLASS, new BMPBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_REMOTE, new BMPRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_HOME, new BMPRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_LOCAL, new BMPLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_LOCALHOME, new BMPLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_KEYCLASS, new BMPKeyClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_MESSAGE_BEANCLASS, new MessageDrivenBeanClassVRule());
        Iterator iterator = this._ruleList.values().iterator();
        while (iterator.hasNext()) {
            object3 = (IValidationRule)iterator.next();
            object2 = object3.getDependsOn();
            if (object2 == null) continue;
            int n = 0;
            while (n < ((Object[])object2).length) {
                object = (IValidationRule)this._ruleList.get(object2[n]);
                if (object != null) {
                    object.addDependent((IValidationRule)object3);
                }
                ++n;
            }
        }
        object3 = Logger.getMsgLogger();
        if (object3.isLoggingLevel(7)) {
            iterator = this._ruleList.values().iterator();
            object2 = null;
            while (iterator.hasNext()) {
                IValidationRule iValidationRule = (IValidationRule)iterator.next();
                object = iValidationRule.getDependents();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("list of dependents for rule:");
                stringBuffer.append(iValidationRule.getClass().getName());
                stringBuffer.append("\n");
                if (object != null) {
                    object2 = object.iterator();
                    while (object2.hasNext()) {
                        IValidationRule iValidationRule2 = (IValidationRule)object2.next();
                        stringBuffer.append("\t");
                        stringBuffer.append(iValidationRule2.getClass().getName());
                        stringBuffer.append("\n");
                    }
                }
                stringBuffer.append("\n");
                object3.write(7, (Object)stringBuffer.toString());
            }
        }
    }

    public final Object getRuleId(IValidationContext iValidationContext, IFileDelta iFileDelta) {
        if (iFileDelta == null) {
            MsgLogger msgLogger = iValidationContext.getMsgLogger();
            if (msgLogger.isLoggingLevel(5)) {
                msgLogger.write(5, (Object)("Cannot load rule from delta: " + iFileDelta));
            }
            return null;
        }
        return this.getRuleId(iValidationContext, iFileDelta.getFileName());
    }

    public final Object getRuleId(IValidationContext iValidationContext, String string) {
        if (string == null) {
            MsgLogger msgLogger = iValidationContext.getMsgLogger();
            if (msgLogger.isLoggingLevel(5)) {
                msgLogger.write(5, (Object)("Cannot load rule from fileName: " + string));
            }
            return null;
        }
        EJBJar eJBJar = (EJBJar)iValidationContext.loadModel("EJB_MODEL");
        if (string.endsWith("META-INF/ibm-ejb-jar-ext.xmi")) {
            if (eJBJar.isVersion1_1Descriptor()) {
                return IValidationRuleList.EJB11_EJBEXT;
            }
            return IValidationRuleList.EJB20_EJBEXT;
        }
        if (string.endsWith("ejb-jar.xml")) {
            if (eJBJar.isVersion1_1Descriptor()) {
                return IValidationRuleList.EJB11_EJBJAR;
            }
            return IValidationRuleList.EJB20_EJBJAR;
        }
        return null;
    }

    public final Object getRuleId(IValidationContext iValidationContext, JavaClass javaClass, EnterpriseBean enterpriseBean) {
        MsgLogger msgLogger;
        boolean bl;
        if (javaClass == null || enterpriseBean == null) {
            MsgLogger msgLogger2 = iValidationContext.getMsgLogger();
            if (msgLogger2.isLoggingLevel(5)) {
                msgLogger2.write(5, (Object)("Cannot load rule because either bean (" + enterpriseBean + ") or class (" + javaClass + ") is null"));
            }
            return null;
        }
        boolean bl2 = enterpriseBean.isSession() && ValidationRuleUtility.isStateless(enterpriseBean);
        boolean bl3 = bl = enterpriseBean.isSession() && ValidationRuleUtility.isStateful(enterpriseBean);
        if (enterpriseBean.isVersion2_X()) {
            if (javaClass.equals(enterpriseBean.getEjbClass())) {
                if (bl2) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_BEANCLASS;
                }
                if (bl) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS;
                }
                if (enterpriseBean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_BEANCLASS;
                }
                if (enterpriseBean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_BEANCLASS;
                }
                if (enterpriseBean.isMessageDriven()) {
                    return IValidationRuleList.EJB20_MESSAGE_BEANCLASS;
                }
                MsgLogger msgLogger3 = iValidationContext.getMsgLogger();
                if (msgLogger3.isLoggingLevel(5)) {
                    msgLogger3.write(5, (Object)"Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getEjbClass()");
                }
                return null;
            }
            if (javaClass.equals(enterpriseBean.getRemoteInterface())) {
                if (bl2) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_REMOTE;
                }
                if (bl) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE;
                }
                if (enterpriseBean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_REMOTE;
                }
                if (enterpriseBean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_REMOTE;
                }
                MsgLogger msgLogger4 = iValidationContext.getMsgLogger();
                if (msgLogger4.isLoggingLevel(5)) {
                    msgLogger4.write(5, (Object)"Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getRemoteInterface()");
                }
                return null;
            }
            if (javaClass.equals(enterpriseBean.getHomeInterface())) {
                if (bl2) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_HOME;
                }
                if (bl) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_HOME;
                }
                if (enterpriseBean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_HOME;
                }
                if (enterpriseBean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_HOME;
                }
                MsgLogger msgLogger5 = iValidationContext.getMsgLogger();
                if (msgLogger5.isLoggingLevel(5)) {
                    msgLogger5.write(5, (Object)"Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getHomeInterface()");
                }
                return null;
            }
            if (javaClass.equals(enterpriseBean.getLocalHomeInterface())) {
                if (bl2) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_LOCALHOME;
                }
                if (bl) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME;
                }
                if (enterpriseBean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_LOCALHOME;
                }
                if (enterpriseBean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_LOCALHOME;
                }
                MsgLogger msgLogger6 = iValidationContext.getMsgLogger();
                if (msgLogger6.isLoggingLevel(5)) {
                    msgLogger6.write(5, (Object)"Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getLocalHomeInterface()");
                }
                return null;
            }
            if (javaClass.equals(enterpriseBean.getLocalInterface())) {
                if (bl2) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_LOCAL;
                }
                if (bl) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL;
                }
                if (enterpriseBean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_LOCAL;
                }
                if (enterpriseBean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_LOCAL;
                }
                MsgLogger msgLogger7 = iValidationContext.getMsgLogger();
                if (msgLogger7.isLoggingLevel(5)) {
                    msgLogger7.write(5, (Object)"Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getLocalInterface()");
                }
                return null;
            }
            if (enterpriseBean instanceof Entity && javaClass.equals(((Entity)enterpriseBean).getPrimaryKey())) {
                if (enterpriseBean.isContainerManagedEntity()) {
                    ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)enterpriseBean;
                    if (ValidationRuleUtility.isPrimitivePrimaryKey(containerManagedEntity)) {
                        return null;
                    }
                    if (ValidationRuleUtility.usesUnknownPrimaryKey(containerManagedEntity)) {
                        return null;
                    }
                    return IValidationRuleList.EJB20_CMP_KEYCLASS;
                }
                if (enterpriseBean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_KEYCLASS;
                }
                MsgLogger msgLogger8 = iValidationContext.getMsgLogger();
                if (msgLogger8.isLoggingLevel(5)) {
                    msgLogger8.write(5, (Object)"Cannot load rule: bean.isVersion2_X() && clazz.equals(((Entity)bean).getPrimaryKey()");
                }
                return null;
            }
            MsgLogger msgLogger9 = iValidationContext.getMsgLogger();
            if (msgLogger9.isLoggingLevel(5)) {
                msgLogger9.write(5, (Object)"Cannot load rule: bean.isVersion2_X()");
            }
            return null;
        }
        if (enterpriseBean.isVersion1_X()) {
            if (javaClass.equals(enterpriseBean.getEjbClass())) {
                if (enterpriseBean.isSession()) {
                    return IValidationRuleList.EJB11_SESSION_BEANCLASS;
                }
                if (enterpriseBean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB11_CMP_BEANCLASS;
                }
                if (enterpriseBean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_BEANCLASS;
                }
                MsgLogger msgLogger10 = iValidationContext.getMsgLogger();
                if (msgLogger10.isLoggingLevel(5)) {
                    msgLogger10.write(5, (Object)"Cannot load rule: bean.isVersion1_X() && clazz.equals(bean.getEjbClass()");
                }
                return null;
            }
            if (javaClass.equals(enterpriseBean.getRemoteInterface())) {
                if (enterpriseBean.isSession()) {
                    return IValidationRuleList.EJB11_SESSION_REMOTE;
                }
                if (enterpriseBean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB11_CMP_REMOTE;
                }
                if (enterpriseBean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_REMOTE;
                }
                MsgLogger msgLogger11 = iValidationContext.getMsgLogger();
                if (msgLogger11.isLoggingLevel(5)) {
                    msgLogger11.write(5, (Object)"Cannot load rule: bean.isVersion1_X() && clazz.equals(bean.getRemoteInterface()");
                }
                return null;
            }
            if (javaClass.equals(enterpriseBean.getHomeInterface())) {
                if (enterpriseBean.isSession()) {
                    return IValidationRuleList.EJB11_SESSION_HOME;
                }
                if (enterpriseBean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB11_CMP_HOME;
                }
                if (enterpriseBean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_HOME;
                }
                MsgLogger msgLogger12 = iValidationContext.getMsgLogger();
                if (msgLogger12.isLoggingLevel(5)) {
                    msgLogger12.write(5, (Object)"Cannot load rule: bean.isVersion1_X() && clazz.equals(bean.getHomeInterface()");
                }
                return null;
            }
            if (enterpriseBean instanceof Entity && javaClass.equals(((Entity)enterpriseBean).getPrimaryKey())) {
                if (enterpriseBean.isContainerManagedEntity()) {
                    ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)enterpriseBean;
                    if (ValidationRuleUtility.isPrimitivePrimaryKey(containerManagedEntity)) {
                        return null;
                    }
                    if (ValidationRuleUtility.usesUnknownPrimaryKey(containerManagedEntity)) {
                        return null;
                    }
                    return IValidationRuleList.EJB11_CMP_KEYCLASS;
                }
                if (enterpriseBean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_KEYCLASS;
                }
                MsgLogger msgLogger13 = iValidationContext.getMsgLogger();
                if (msgLogger13.isLoggingLevel(5)) {
                    msgLogger13.write(5, (Object)"Cannot load rule: bean.isVersion1_X() && clazz.equals(((Entity)bean).getPrimaryKey()");
                }
                return null;
            }
        }
        if ((msgLogger = iValidationContext.getMsgLogger()).isLoggingLevel(5)) {
            msgLogger.write(5, (Object)"Cannot load rule: !bean.isVersion1_X() && !bean.isVersion2_X()");
        }
        return null;
    }
}

